/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.coreimpl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.utils.FileUtils;

public class ZinikiClassLoader
extends ClassLoader {
    private final Logger logger = LoggerFactory.getLogger((String)"ZinikiServer");
    private final Comparator<String> invertor = (x, y) -> -x.compareTo((String)y);
    private final TreeMap<String, ContentObject> packages = new TreeMap(this.invertor);

    public ZinikiClassLoader(@Param(value="loader") ClassLoader loader, @Param(value="contentStore") ContentStorage contentStore) {
        super(loader);
        if (contentStore != null) {
            List packages = contentStore.matching("packages/", "/jar/");
            for (ContentObject co : packages) {
                this.addPackage(co);
            }
        }
    }

    public void addPackage(ContentObject co) {
        this.packages.put(co.key().replaceFirst("packages/", ""), co);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = FileUtils.convertDottedToSlashPath((String)name) + ".class";
        for (Map.Entry<String, ContentObject> e : this.packages.entrySet()) {
            String pfx = e.getKey();
            int idx = pfx.indexOf("/");
            if (idx != -1) {
                pfx = pfx.substring(0, idx);
            }
            if (!name.startsWith(pfx)) continue;
            ByteArrayInputStream bais = new ByteArrayInputStream(e.getValue().asByteArray());
            ZipInputStream zis = new ZipInputStream(bais);
            try {
                ZipEntry ze;
                TreeSet<String> have = new TreeSet<String>();
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.getName().equals(path)) {
                        byte[] bs = FileUtils.readAllStream((InputStream)zis);
                        return super.defineClass(name, bs, 0, bs.length);
                    }
                    have.add(ze.getName());
                }
                this.logger.error("No class found for " + name + " have package " + e.getKey() + " with " + have);
            }
            catch (IOException ex) {
                this.logger.error("error unzipping package " + e.getKey(), (Throwable)ex);
            }
            break;
        }
        if (name.startsWith("org.zinapps")) {
            this.logger.error("did not find package for " + name + " in " + this.packages.keySet());
        }
        return super.findClass(name);
    }

    public String toString() {
        return "ZinikiClassLoader[" + this.packages + "]";
    }
}

