/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.apigatewayv2.model.ApiGatewayV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIntegrationRequest
extends ApiGatewayV2Request
implements ToCopyableBuilder<Builder, GetIntegrationRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIntegrationRequest.getter(GetIntegrationRequest::apiId)).setter(GetIntegrationRequest.setter(Builder::apiId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()}).build();
    private static final SdkField<String> INTEGRATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIntegrationRequest.getter(GetIntegrationRequest::integrationId)).setter(GetIntegrationRequest.setter(Builder::integrationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("integrationId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, INTEGRATION_ID_FIELD));
    private final String apiId;
    private final String integrationId;

    private GetIntegrationRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.integrationId = builder.integrationId;
    }

    public String apiId() {
        return this.apiId;
    }

    public String integrationId() {
        return this.integrationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.apiId());
        hashCode = 31 * hashCode + Objects.hashCode(this.integrationId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIntegrationRequest)) {
            return false;
        }
        GetIntegrationRequest other = (GetIntegrationRequest)((Object)obj);
        return Objects.equals(this.apiId(), other.apiId()) && Objects.equals(this.integrationId(), other.integrationId());
    }

    public String toString() {
        return ToString.builder((String)"GetIntegrationRequest").add("ApiId", (Object)this.apiId()).add("IntegrationId", (Object)this.integrationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApiId": {
                return Optional.ofNullable(clazz.cast(this.apiId()));
            }
            case "IntegrationId": {
                return Optional.ofNullable(clazz.cast(this.integrationId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIntegrationRequest, T> g) {
        return obj -> g.apply((GetIntegrationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ApiGatewayV2Request.BuilderImpl
    implements Builder {
        private String apiId;
        private String integrationId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIntegrationRequest model) {
            super(model);
            this.apiId(model.apiId);
            this.integrationId(model.integrationId);
        }

        public final String getApiId() {
            return this.apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        public final String getIntegrationId() {
            return this.integrationId;
        }

        @Override
        public final Builder integrationId(String integrationId) {
            this.integrationId = integrationId;
            return this;
        }

        public final void setIntegrationId(String integrationId) {
            this.integrationId = integrationId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIntegrationRequest build() {
            return new GetIntegrationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ApiGatewayV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIntegrationRequest> {
        public Builder apiId(String var1);

        public Builder integrationId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

