/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.ziniki.CodePackageVersion;
import org.ziniki.DataHandler;
import org.ziniki.DataStore;
import org.ziniki.FileProvider;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;

public class ProvideFile
implements RelationHandler {
    private final ContentStorage cs;
    private final UnitOfWork uow;
    private final String packageName;
    private final String version;
    private final String kind;
    private final String fileName;
    private final FileProvider fp;
    private final FLEvalContext cx;

    public ProvideFile(ContentStorage cs, ZiIdFactory factory, UnitOfWork uow, DataStore ds, ZiId appArena, String packageName, String version, String kind, String fileName, FileProvider fp) {
        this.cs = cs;
        this.uow = uow;
        this.packageName = packageName;
        this.version = version;
        this.kind = kind;
        this.fileName = fileName;
        this.fp = fp;
        this.cx = (FLEvalContext)uow;
    }

    public DataHandler handleCode(Relation r) {
        return new UpdateIt(r, this.packageName, this.version);
    }

    public void update(Relation r, @Slot(value="codepkgvers") CodePackageVersion codepkgvers) {
        ContentObject co = this.cs.newObject(this.cx, this.fileName, "text/plain");
        r.load("co", (Object)co);
        switch (this.kind) {
            case "sources": 
            case "unitTests": 
            case "assemblies": 
            case "systemTests": {
                if (codepkgvers.get(this.kind) == null) {
                    codepkgvers.set(this.kind, new ArrayList());
                }
                ((List)codepkgvers.get(this.kind)).add(co);
                r.update(codepkgvers.id(), (Object)codepkgvers);
                break;
            }
            default: {
                this.uow.fatalError((Throwable)new RuntimeException("cannot handle kind: " + this.kind));
            }
        }
    }

    public void reply(@Slot(value="co") ContentObject co) {
        this.fp.uploadTo(this.cx, new Object[]{co, new LoggingIdempotentHandler()});
        this.fp.success((EvalContext)this.cx);
    }

    public void error(TxError error) {
        String msg = "unknown error";
        if (error != null) {
            msg = error.toString();
        }
        this.fp.failure((EvalContext)this.cx, (Object)msg);
    }

    public static final class UpdateIt
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String packageName;
        private final String version;

        public UpdateIt(Relation r, String packageName, String version) {
            this.r = r;
            this.packageName = packageName;
            this.version = version;
        }

        public String _handlerID() {
            return null;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("There is no package " + this.packageName + ":" + this.version));
            return null;
        }

        public Object value(FLEvalContext cx, Object[] args) {
            try {
                this.r.load("codepkgvers", args[0]);
                this.r.logic("update");
            }
            catch (Throwable t) {
                ((UnitOfWork)cx).fatalError(t);
            }
            return null;
        }

        public Object name() {
            return null;
        }
    }
}

