/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.uploader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.CodePackage;
import org.ziniki.CodePackageVersion;
import org.ziniki.DataHandler;
import org.ziniki.DataStore;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.fl.JVMEntityReference;
import org.ziniki.core.fl.JVMSecondaryKeyEntry;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.secondaries.PackageByName;
import org.ziniki.secondaries.PackageByNameVersion;
import org.ziniki.services.datastore.NotifyDataHandlerSubscriber;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.DessicatableHandler;
import org.ziniki.ziwsh.intf.Dessication;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class CreateNewPackage
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final ZiIdFactory factory;
    private final UnitOfWork uow;
    private final FLEvalContext cx;
    private final DataStore ds;
    private final ZiId appArena;
    private final String name;
    private final String version;
    private final List<String> modules;
    private final List<String> dependencies;
    private final IdempotentHandler ih;
    private final HandlerNameProvider handlerNameProvider;
    private final AtomicInteger depcount = new AtomicInteger();
    private CodePackage codepkg;
    private String pkguri;
    private String pkgsk;
    private String pkgversuri;
    private String pkgverssk;
    private CodePackageVersion codepkgvers;

    public CreateNewPackage(ZiIdFactory factory, UnitOfWork uow, DataStore ds, ZiId appArena, String name, String version, List<String> modules, List<String> dependencies, IdempotentHandler ih, HandlerNameProvider handlerNameProvider) {
        this.factory = factory;
        this.uow = uow;
        this.ds = ds;
        this.appArena = appArena;
        this.name = name;
        this.version = version;
        this.modules = modules;
        this.dependencies = dependencies;
        this.ih = ih;
        this.handlerNameProvider = handlerNameProvider;
        this.cx = (FLEvalContext)uow;
    }

    public DataHandler packages(Relation r) {
        return new PackagesHandler(r, this.handlerNameProvider.newName());
    }

    public void createPackage(Relation r) {
        logger.info("createPackage called in " + r);
        this.codepkg = (CodePackage)CodePackage.eval((FLEvalContext)this.cx, (Object[])new Object[]{this.name, this.version});
        try {
            this.pkguri = this.factory.nextInSequence("data", ((UOWHost)this.uow.trait(UOWHost.class)).host, "arena").toString();
            r.create(this.pkguri, (Object)this.codepkg);
            this.pkgsk = ((ZiIdURI)this.appArena).makeScheme("seckey").append(PackageByName.class.getName()).append((String)this.codepkg.get("packageName")).toString();
            r.upsert(this.pkgsk, (Object)new JVMSecondaryKeyEntry(this.cx, this.pkguri));
            logger.info("desiring createVersion to be called in " + r);
            r.logic("createVersion");
        }
        catch (GLSException gLSException) {
            // empty catch block
        }
    }

    public DataHandler versions(Relation r) {
        return new VersionsHandler(r, this.handlerNameProvider.newName());
    }

    public void createVersion(Relation r) throws GLSException {
        logger.info("createVersion called in " + r);
        this.codepkgvers = (CodePackageVersion)CodePackageVersion.eval((FLEvalContext)this.cx, (Object[])new Object[]{this.name, this.version, new ArrayList()});
        r.load("codepkgvers", (Object)this.codepkgvers);
        logger.info("loaded codepkgvers from " + this.codepkgvers + " in " + r);
        this.pkgversuri = this.factory.nextInSequence("data", ((UOWHost)this.uow.trait(UOWHost.class)).host, "entity").toString();
        r.create(this.pkgversuri, (Object)this.codepkgvers);
        this.pkgverssk = ((ZiIdURI)this.appArena).makeScheme("seckey").append(PackageByNameVersion.class.getName()).append((String)this.codepkgvers.get("packageName")).append((String)this.codepkgvers.get("version")).toString();
        r.upsert(this.pkgverssk, (Object)new JVMSecondaryKeyEntry(this.cx, this.pkgversuri));
    }

    public void resolveDependencies(Relation r, @Slot(value="codepkgvers") CodePackageVersion codepkgvers) throws GLSException {
        this.depcount.set(1);
        this.ds.secondaryKey(this.cx, new Object[]{this.appArena.toString(), PackageByName.class.getName(), Arrays.asList("flascklib"), new FindDependencyVersion(r, codepkgvers, Type.FLASCKLIB, "flascklib", this.handlerNameProvider.newName())});
        r.background("dependenciesReady");
        r.logic("waitForDependencies");
        if (this.modules != null && !this.modules.isEmpty()) {
            this.depcount.addAndGet(this.modules.size());
            for (String m : this.modules) {
                this.ds.secondaryKey(this.cx, new Object[]{this.appArena.toString(), PackageByName.class.getName(), Arrays.asList(m), new FindDependencyVersion(r, codepkgvers, Type.MODULE, m, this.handlerNameProvider.newName())});
            }
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            this.depcount.addAndGet(this.dependencies.size());
            for (String d : this.dependencies) {
                this.ds.secondaryKey(this.cx, new Object[]{this.appArena.toString(), PackageByName.class.getName(), Arrays.asList(d), new FindDependencyVersion(r, codepkgvers, Type.DEPENDENCY, d, this.handlerNameProvider.newName())});
            }
        }
    }

    public void waitForDependencies(@Slot(value="dependenciesReady") Object ready) {
    }

    public void attachJsToCPV(Relation r, @Slot(value="codepkgvers") CodePackageVersion cpv, @Slot(value="mainjs") List<ContentObject> mainjs, @Slot(value="livejs") List<ContentObject> livejs, @Slot(value="testjs") List<ContentObject> testjs) {
        cpv.set("mainjs", mainjs);
        cpv.set("livejs", livejs);
        cpv.set("testjs", testjs);
        this.codepkg.set("latestVersion", (Object)this.version);
        r.update(this.codepkg.id(), (Object)this.codepkg);
    }

    public void reply(Relation r) {
        logger.info("entering CreateNewPackage.reply()");
        this.ih.success((EvalContext)this.cx);
        try {
            if (this.pkgsk != null) {
                r.sendNotifications(this.pkgsk, (NotifySubscriber)new NotifyDataHandlerSubscriber((FieldsContainerWrapper)this.codepkg));
            }
            if (this.pkgverssk != null) {
                r.sendNotifications(this.pkgverssk, (NotifySubscriber)new NotifyDataHandlerSubscriber((FieldsContainerWrapper)this.codepkgvers));
            }
        }
        catch (Throwable t) {
            logger.error("error sending notifications about " + this.pkguri, t);
        }
        logger.info("leaving CreateNewPackage.reply()");
    }

    public static final class VersionsHandler
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String handlerID;

        public VersionsHandler(Relation r, String handlerID) {
            this.r = r;
            this.handlerID = handlerID;
        }

        public String _handlerID() {
            return this.handlerID;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            try {
                this.r.logic("createVersion");
            }
            catch (GLSException gLSException) {
                // empty catch block
            }
            return null;
        }

        public Object value(FLEvalContext arg0, Object[] args) {
            CodePackageVersion cpv = (CodePackageVersion)args[0];
            cpv.set("sources", new ArrayList());
            cpv.set("unitTests", new ArrayList());
            cpv.set("assemblies", new ArrayList());
            cpv.set("systemTests", new ArrayList());
            cpv.set("dependencies", new ArrayList());
            cpv.set("modules", new ArrayList());
            this.r.update(cpv.id(), (Object)cpv);
            this.r.load("codepkgvers", (Object)cpv);
            return null;
        }

        public Object name() {
            return null;
        }
    }

    public final class PackagesHandler
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final String handlerID;

        public PackagesHandler(Relation r, String handlerID) {
            this.r = r;
            this.handlerID = handlerID;
        }

        public String _handlerID() {
            return this.handlerID;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            CreateNewPackage.this.uow.fatalError((Throwable)new RuntimeException((String)error));
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            try {
                this.r.logic("createPackage");
            }
            catch (GLSException gLSException) {
                // empty catch block
            }
            return null;
        }

        public Object value(FLEvalContext arg0, Object[] args) {
            CreateNewPackage.this.codepkg = (CodePackage)args[0];
            CreateNewPackage.this.ds.secondaryKey(CreateNewPackage.this.cx, new Object[]{CreateNewPackage.this.appArena.toString(), PackageByNameVersion.class.getName(), Arrays.asList(CreateNewPackage.this.name, CreateNewPackage.this.version), CreateNewPackage.this.versions(this.r)});
            return null;
        }

        public Object name() {
            return null;
        }
    }

    public class AttachDependencyVersion
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final CodePackageVersion codepkgvers;
        private final Type ty;
        private final String askedFor;
        private final String refv;
        private final String handlerID;

        public AttachDependencyVersion(Relation r, CodePackageVersion codepkgvers, Type ty, String d, String version, String handlerID) {
            this.r = r;
            this.codepkgvers = codepkgvers;
            this.ty = ty;
            this.askedFor = d;
            this.refv = version;
            this.handlerID = handlerID;
        }

        public String _handlerID() {
            return this.handlerID;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            logger.error("failure recovering dependency" + error);
            CreateNewPackage.this.ih.failure(cx, error);
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
            this.r.load("dependenciesReady", error);
        }

        public Object missing(FLEvalContext arg0, Object[] arg1) {
            logger.error("no such dependency: " + this.askedFor + " " + this.refv);
            CreateNewPackage.this.ih.failure((EvalContext)CreateNewPackage.this.cx, (Object)("no such dependency " + this.askedFor + " " + this.refv));
            ((UnitOfWork)CreateNewPackage.this.cx).fatalError((Throwable)new RuntimeException("no such dependency " + this.askedFor + " " + this.refv));
            this.r.load("dependenciesReady", (Object)(this.askedFor + " " + this.refv));
            return null;
        }

        public Object name() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object value(FLEvalContext cx, Object[] args) {
            CodePackageVersion refv = (CodePackageVersion)args[0];
            JVMEntityReference er = new JVMEntityReference(cx, refv.getClass().getName(), refv.id());
            CodePackageVersion codePackageVersion = this.codepkgvers;
            synchronized (codePackageVersion) {
                switch (this.ty) {
                    case FLASCKLIB: {
                        this.codepkgvers.set("flascklib", (Object)er);
                        break;
                    }
                    case MODULE: {
                        if (this.codepkgvers.get("modules") == null) {
                            this.codepkgvers.set("modules", new ArrayList());
                        }
                        ((List)this.codepkgvers.get("modules")).add(er);
                        break;
                    }
                    case DEPENDENCY: {
                        if (this.codepkgvers.get("dependencies") == null) {
                            this.codepkgvers.set("dependencies", new ArrayList());
                        }
                        ((List)this.codepkgvers.get("dependencies")).add(er);
                    }
                }
            }
            if (CreateNewPackage.this.depcount.decrementAndGet() == 0) {
                this.r.load("dependenciesReady", (Object)this.codepkgvers);
            }
            return null;
        }
    }

    public class FindDependencyVersion
    implements DataHandler,
    DessicatableHandler {
        private final Relation r;
        private final CodePackageVersion codepkgvers;
        private final Type ty;
        private final String askedFor;
        private final String handlerID;

        public FindDependencyVersion(Relation r, CodePackageVersion codepkgvers, Type ty, String d, String handlerID) {
            this.r = r;
            this.codepkgvers = codepkgvers;
            this.ty = ty;
            this.askedFor = d;
            this.handlerID = handlerID;
        }

        public String _handlerID() {
            return this.handlerID;
        }

        public Dessication _dessication() {
            return null;
        }

        public void success(EvalContext cx) {
        }

        public void failure(EvalContext cx, Object error) {
            logger.error("failure recovering dependency " + error);
            CreateNewPackage.this.ih.failure(cx, error);
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException((String)error));
            this.r.load("dependenciesReady", error);
        }

        public Object missing(FLEvalContext cx, Object[] arg1) {
            logger.error("no such dependency " + this.askedFor);
            CreateNewPackage.this.ih.failure((EvalContext)cx, (Object)("no such dependency " + this.askedFor));
            ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("no such dependency " + this.askedFor));
            this.r.load("dependenciesReady", (Object)this.askedFor);
            return null;
        }

        public Object name() {
            return null;
        }

        public Object value(FLEvalContext cx, Object[] args) {
            CodePackage refs = (CodePackage)args[0];
            String rv = (String)refs._field_latestVersion(cx, new Object[0]);
            if (rv == null) {
                logger.error("no version provided for dependency " + this.askedFor);
                CreateNewPackage.this.ih.failure((EvalContext)cx, (Object)("no version provided for dependency " + this.askedFor));
                ((UnitOfWork)cx).fatalError((Throwable)new RuntimeException("no version provided for dependency " + this.askedFor));
                this.r.load("dependenciesReady", (Object)this.askedFor);
                return null;
            }
            CreateNewPackage.this.ds.secondaryKey(cx, new Object[]{CreateNewPackage.this.appArena.toString(), PackageByNameVersion.class.getName(), Arrays.asList(this.askedFor, rv), new AttachDependencyVersion(this.r, this.codepkgvers, this.ty, this.askedFor, rv, CreateNewPackage.this.handlerNameProvider.newName())});
            return null;
        }
    }

    public static enum Type {
        FLASCKLIB,
        MODULE,
        DEPENDENCY;

    }
}

