/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Bench;
import org.ziniki.core.fl.CrobagEntry;
import org.ziniki.core.fl.EntityOnBench;
import org.ziniki.core.fl.JVMSecondaryKeyEntry;
import org.ziniki.core.fl.SecondaryInArena;
import org.ziniki.intf.ZiId;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.services.datastore.NotifyCrobagAddKeySubscriber;
import org.ziniki.services.datastore.NotifyDataHandlerSubscriber;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.zinutils.reflection.Reflection;

public class PublishToArena
implements RelationHandler {
    public final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final ClassLoader loader;
    private final UnitOfWork uow;
    private final List<String> benches;
    private final IdempotentHandler handler;
    private final List<String> toNotify = new ArrayList<String>();
    private final List<CrobagEntry> cbNotify = new ArrayList<CrobagEntry>();
    private FieldsContainerWrapper entity;

    public PublishToArena(FLEvalContext cx, ClassLoader loader, UnitOfWork uow, List<String> benches, IdempotentHandler handler) {
        this.cx = cx;
        this.loader = loader;
        this.uow = uow;
        this.benches = benches;
        this.handler = handler;
    }

    public void publishToArena(Relation r, @Slot(value="thing") FieldsContainerWrapper thing, @Slot(value="arena") Arena arena, @Slot(value="secondaries") List<SecondaryInArena> secondaries) {
        if (thing == null) {
            this.uow.fatalError((Throwable)new RuntimeException("the entity was not found"));
            return;
        }
        if (arena == null) {
            this.uow.fatalError((Throwable)new RuntimeException("the arena was not found"));
            return;
        }
        this.entity = thing;
        String clz = thing.getClass().getName();
        JVMSecondaryKeyEntry pointsTo = new JVMSecondaryKeyEntry(this.cx, thing.id());
        for (SecondaryInArena sia : secondaries) {
            ZiIdURI ziid;
            this.logger.info("need to update " + sia + ": " + sia.bytype + " " + sia.ofEntity);
            ZiIdURI base = ziid = ZiIdURI.fromString((String)sia.range()).makeScheme(sia.iskey() ? "seckey" : "secidx");
            if (sia.bytype) {
                ziid = ziid.append(clz);
            } else {
                String skclz = sia.indexClass();
                List fieldNames = (List)Reflection.callStatic((ClassLoader)this.loader, (String)skclz, (String)"fieldNames", (Object[])new Object[]{this.cx});
                for (String fn : fieldNames) {
                    ziid = ziid.append(this.entity.get(fn).toString());
                }
            }
            if (sia.iskey()) {
                r.create(ziid.toString(), (Object)pointsTo);
                this.toNotify.add(ziid.toString());
                continue;
            }
            CrobagEntry cbe = new CrobagEntry((ZiId)base, ziid.toString().substring(base.toString().length() + 1), (ZiId)ZiIdURI.fromString((String)thing.id()));
            r.link((EntityLink)cbe);
            this.cbNotify.add(cbe);
        }
        ZiIdURI eid = ZiIdURI.fromString((String)thing.id());
        for (String s : this.benches) {
            Bench b = arena.bench(s);
            if (b == null) {
                this.uow.fatalError((Throwable)new RuntimeException("there is no bench " + s + " in " + arena.ziid()));
                return;
            }
            this.logger.info("Adding link action from " + b.ziid() + " to " + eid);
            r.link((EntityLink)new EntityOnBench(b.ziid(), (ZiId)eid, arena.ziid()));
        }
    }

    public void sendHappyResponse(Relation r) {
        this.handler.success((EvalContext)this.cx);
        for (String s : this.toNotify) {
            try {
                r.sendNotifications(s, (NotifySubscriber)new NotifyDataHandlerSubscriber(this.entity));
            }
            catch (Throwable t) {
                this.logger.error("failed to send notification", t);
            }
        }
        for (CrobagEntry ce : this.cbNotify) {
            try {
                r.sendNotifications(ce.hash(), (NotifySubscriber)new NotifyCrobagAddKeySubscriber(ce.range(), this.entity.id()));
            }
            catch (Throwable t) {
                this.logger.error("failed to send notification", t);
            }
        }
    }

    public void sendFailureResponse(TxError err) {
        this.handler.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

