/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataHandler;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.core.concepts.SecondaryKeyEntry;
import org.ziniki.services.datastore.SubscribeTo;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.HandlerNameProvider;
import org.ziniki.ziwsh.intf.IdempotentHandler;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;

public class GetSecondaryKey
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final String catalogueName;
    private final List<String> fieldNames;
    private final List<String> fields;
    private final DataHandler dh;

    public GetSecondaryKey(FLEvalContext cx, HandlerNameProvider nameProvider, String catalogueName, List<String> fieldNames, List<String> fields, DataHandler dh) {
        this.cx = cx;
        this.catalogueName = catalogueName;
        this.fieldNames = fieldNames;
        this.fields = fields;
        this.dh = dh;
    }

    public void doGet(Relation r) throws GLSException {
        Object key = this.catalogueName;
        logger.info("cat = " + this.catalogueName);
        try {
            if (this.fieldNames == null) {
                throw new InvalidUsageException("use bytype on " + this.catalogueName);
            }
            if (this.fieldNames.size() != this.fields.size()) {
                throw new NotImplementedException("should report an error");
            }
            for (String s : this.fields) {
                if (s == null || s.length() == 0) {
                    this.dh.failure((EvalContext)this.cx, (Object)"invalid key field");
                    return;
                }
                key = (String)key + "/" + URLEncoder.encode(s, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            this.dh.failure((EvalContext)this.cx, (Object)e.toString());
        }
        logger.info("get secondary key for " + (String)key);
        r.get("record", (String)key);
        r.logic("determineOutcome");
        r.subscribe((String)key, (IdempotentHandler)this.dh);
    }

    public void determineOutcome(Relation r, @Slot(value="record") SecondaryKeyEntry ske) throws GLSException {
        logger.info("get secondary key returned " + ske);
        if (ske == null) {
            r.logic("sendMissing");
        } else {
            r.get("entity", ske.pointsTo().toString());
            r.logic("sendValue");
        }
    }

    public void sendMissing() {
        this.dh.missing(this.cx, new Object[]{new LoggingIdempotentHandler()});
        this.dh.success((EvalContext)this.cx);
    }

    public void sendValue(@Slot(value="entity") Object entity) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.dh.value(this.cx, new Object[]{SubscribeTo.translate(this.cx, entity), new LoggingIdempotentHandler()});
        this.dh.success((EvalContext)this.cx);
    }

    public void sendFailure(TxError err) {
        this.dh.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

