/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.lang.reflect.InvocationTargetException;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.DataHandler;
import org.ziniki.MyRecord;
import org.ziniki.coreimpl.FailUOWHandler;
import org.ziniki.intf.ZiId;
import org.ziniki.services.datastore.SubscribeTo;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class FetchMy
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final UnitOfWork uow;
    private final ZiId simple;
    private final DataHandler handler;
    private final FLEvalContext cx;

    public FetchMy(UnitOfWork uow, ZiId simple, DataHandler handler) {
        this.uow = uow;
        this.cx = (FLEvalContext)uow;
        this.simple = simple;
        this.handler = handler;
    }

    public void checkIfMissing(Relation r, @Slot(value="currentMy") MyRecord my) {
        if (my == null) {
            logger.info("ZDS.my() could not find " + this.simple);
            this.handler.missing(this.cx, new Object[]{new FailUOWHandler(this.uow)});
            this.handler.success((EvalContext)this.cx);
        } else {
            String pointsTo = (String)my._field_pointsTo(this.cx, new Object[0]);
            logger.info("pointsTo = " + pointsTo);
            try {
                r.load("pointsTo", (Object)pointsTo);
                r.get("pointedTo", pointsTo);
                r.logic("subscribeToActualThing");
            }
            catch (Throwable t) {
                this.uow.fatalError(t);
            }
        }
        r.subscribe(this.simple.toString(), (IdempotentHandler)this.handler);
    }

    public void subscribeToActualThing(Relation r, @Slot(value="pointsTo") String pointsTo, @Slot(value="pointedTo") Object obj) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        if (obj == null) {
            logger.info("ZDS.my() could not find referenced " + pointsTo);
            this.handler.missing(this.cx, new Object[]{new FailUOWHandler(this.uow)});
            this.handler.success((EvalContext)this.cx);
        } else {
            this.handler.value(this.cx, new Object[]{SubscribeTo.translate(this.cx, obj), new FailUOWHandler(this.uow)});
            this.handler.success((EvalContext)this.cx);
        }
        r.subscribe(pointsTo, (IdempotentHandler)this.handler);
    }
}

