/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.ArrayList;
import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.fl.JVMFieldsContainerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.EntityCreated;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.UOWHost;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Bench;
import org.ziniki.core.fl.EntityOnBench;
import org.ziniki.core.fl.JVMArena;
import org.ziniki.core.fl.JVMSecondaryKeyEntry;
import org.ziniki.core.fl.SecondaryInArena;
import org.ziniki.coreimpl.FailUOWHandler;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.services.datastore.NotifyDataHandlerSubscriber;
import org.ziniki.tdastore.NotifySubscriber;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;
import org.zinutils.exceptions.NotImplementedException;

public class CreateAnArena
implements RelationHandler {
    public final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final FLEvalContext cx;
    private final UnitOfWork uow;
    private final ZiIdFactory factory;
    private final String onbench;
    private final JVMFieldsContainerWrapper proto;
    private final EntityCreated handler;
    private JVMArena created;
    private final List<String> toNotify = new ArrayList<String>();

    public CreateAnArena(FLEvalContext cx, UnitOfWork uow, ZiIdFactory factory, String onbench, JVMFieldsContainerWrapper proto, EntityCreated handler) {
        this.cx = cx;
        this.uow = uow;
        this.factory = factory;
        this.onbench = onbench;
        this.proto = proto;
        this.handler = handler;
    }

    public void createIt(Relation r, @Slot(value="secondaries") List<SecondaryInArena> secondaries, @Slot(value="parent") Arena parent) {
        if (parent == null) {
            this.uow.fatalError((Throwable)new RuntimeException("the parent arena was not found"));
            return;
        }
        if (secondaries == null) {
            this.uow.fatalError((Throwable)new RuntimeException("Secondaries were not found"));
            return;
        }
        Bench bench = parent.bench(this.onbench);
        if (bench == null) {
            this.uow.fatalError((Throwable)new RuntimeException("there is no bench " + this.onbench));
            return;
        }
        this.created = JVMArena.projected((FLEvalContext)this.cx, (String)this.proto.getClass().getName());
        ZiId id = this.factory.nextInSequence("data", ((UOWHost)this.uow.trait(UOWHost.class)).host, "arena");
        r.create(id.toString(), (Object)this.created);
        this.proto.set("_id", (Object)id.toString());
        r.link((EntityLink)new EntityOnBench(bench.ziid(), id, parent.ziid()));
        for (SecondaryInArena sia : secondaries) {
            if (!sia.bytype) {
                throw new NotImplementedException("need to check entity type matches");
            }
            String sic = ZiIdURI.fromString((String)sia.range()).makeScheme("seckey").append(this.proto.getClass().getName()).toString();
            r.create(sic, (Object)new JVMSecondaryKeyEntry(this.cx, id.toString()));
            this.toNotify.add(sic);
        }
        this.proto.all((x, y) -> this.created.set(x, y));
    }

    public void sendHappyResponse(Relation r) {
        this.handler.created(this.cx, new Object[]{this.proto, new FailUOWHandler(this.uow)});
        this.handler.success((EvalContext)this.cx);
        for (String z : this.toNotify) {
            try {
                r.sendNotifications(z, (NotifySubscriber)new NotifyDataHandlerSubscriber((FieldsContainerWrapper)this.proto));
            }
            catch (Throwable e) {
                this.logger.error("error sending put notification on " + z, e);
            }
        }
    }

    public void sendFailureResponse(TxError err) {
        this.handler.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

