/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.TreeMap;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.EntityCreated;
import org.ziniki.common.UOWHost;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Identity;
import org.ziniki.core.fl.EntityOnBench;
import org.ziniki.coreimpl.FailUOWHandler;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.intf.ZinikiUOW;
import org.ziniki.paas.interfaces.EntityLink;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.FieldsContainerWrapper;

public class AttachPersonalArena
implements RelationHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private final ZiIdFactory factory;
    private final FieldsContainerWrapper entity;
    private final EntityCreated handler;
    private final UnitOfWork uow;

    public AttachPersonalArena(ZiIdFactory factory, UnitOfWork uow, ZinikiUOW zx, FieldsContainerWrapper entity, EntityCreated handler) {
        this.factory = factory;
        this.uow = uow;
        this.entity = entity;
        this.handler = handler;
    }

    public void getPersonalArena(Relation r, @Slot(value="user") Identity user) throws GLSException {
        ZiId pa = user.getPersonalArena();
        r.get("arena", pa.toString());
        r.logic("attachArena");
    }

    public void attachArena(Relation r, @Slot(value="user") Identity user, @Slot(value="arena") Arena personalArena) throws GLSException {
        ZiId pa = personalArena.ziid();
        TreeMap<String, String> sec = new TreeMap<String, String>();
        sec.put("ownedBy", user.ziid().toString());
        sec.put("securedBy", (String)pa);
        this.entity.set("_security", sec);
        ZiId entityID = this.factory.nextInSequence("data", ((UOWHost)this.uow.trait(UOWHost.class)).host, "entity");
        logger.info("creating new entity " + entityID + " in attachPersonalArena");
        r.load("entityID", (Object)entityID.toString());
        r.create(entityID.toString(), (Object)this.entity);
        r.link((EntityLink)new EntityOnBench(personalArena.bench("me").ziid(), entityID, personalArena.ziid()));
    }

    public void sendReply() {
        this.handler.created((FLEvalContext)this.uow, new Object[]{this.entity, new FailUOWHandler(this.uow)});
    }
}

