/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.datastore;

import java.util.List;
import org.flasck.jvm.FLEvalContext;
import org.ziniki.cbtxstore.gls.TxError;
import org.ziniki.common.ZiIdURI;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Bench;
import org.ziniki.core.fl.JVMBench;
import org.ziniki.intf.ZiId;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.IdempotentHandler;

public class AddBenchToArena
implements RelationHandler {
    private final FLEvalContext cx;
    private final UnitOfWork uow;
    private final String bench;
    private final List<Object> perms;
    private final IdempotentHandler handler;

    public AddBenchToArena(FLEvalContext cx, UnitOfWork uow, String bench, List<Object> perms, IdempotentHandler handler) {
        this.cx = cx;
        this.uow = uow;
        this.bench = bench;
        this.perms = perms;
        this.handler = handler;
    }

    public void createBenchInArena(Relation r, @Slot(value="arena") Arena arena) {
        if (arena == null) {
            this.uow.fatalError((Throwable)new RuntimeException("the arena was not found"));
            return;
        }
        Bench curr = arena.bench(this.bench);
        if (curr != null) {
            this.uow.fatalError((Throwable)new RuntimeException("there is already a bench " + this.bench));
            return;
        }
        ZiIdURI aid = (ZiIdURI)arena.ziid();
        ZiIdURI bid = aid.makeType("bench").append("owner");
        JVMBench newBench = new JVMBench(this.cx, (ZiId)bid, this.bench);
        arena.addBench((Bench)newBench);
        r.update(aid.toString(), (Object)arena);
    }

    public void sendHappyResponse() {
        this.handler.success((EvalContext)this.cx);
    }

    public void sendFailureResponse(TxError err) {
        this.handler.failure((EvalContext)this.cx, (Object)err.toString());
    }
}

