/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.services.contentstore;

import org.flasck.jvm.FLEvalContext;
import org.flasck.jvm.ziniki.ContentObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ContentProvider;
import org.ziniki.ContentStore;
import org.ziniki.paas.interfaces.ContentStorage;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.jvm.LoggingIdempotentHandler;

public class ZinikiContentStore
implements ContentStore {
    private static final Logger logger = LoggerFactory.getLogger((String)"Ziniki");
    private ContentStorage cs;

    public ZinikiContentStore(@Param(value="broker") ZiwshBroker broker, @Param(value="contentStore") ContentStorage cs) {
        this.cs = cs;
        broker.register(ContentStore.class, (Object)this);
    }

    public Object name() {
        return null;
    }

    public Object newObject(FLEvalContext cx, Object[] args) {
        String name = (String)args[0];
        String contentType = (String)args[1];
        logger.info("creating new content object " + name + "/" + contentType);
        ContentProvider cp = (ContentProvider)args[2];
        ContentObject co = this.cs.newObject(cx, name, contentType);
        cp.provide(cx, new Object[]{co, new LoggingIdempotentHandler()});
        return null;
    }

    public Object objectPath(FLEvalContext cx, Object[] args) {
        try {
            String path = (String)args[0];
            String contentType = (String)args[1];
            logger.info("creating new content object " + path + "/" + contentType);
            ContentProvider cp = (ContentProvider)args[2];
            ContentObject co = this.cs.objectPath(cx, path, contentType);
            cp.provide(cx, new Object[]{co, new LoggingIdempotentHandler()});
        }
        catch (Throwable t) {
            ((UnitOfWork)cx).fatalError(t);
        }
        return null;
    }
}

