/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.cnc.events.core.DnsSrvLookupDisabledEvent;
import com.couchbase.client.core.cnc.events.core.DnsSrvLookupFailedEvent;
import com.couchbase.client.core.cnc.events.core.DnsSrvRecordsLoadedEvent;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.util.ConnectionString;
import com.couchbase.client.core.util.DnsSrv;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NameNotFoundException;

@Stability.Internal
public class ConnectionStringUtil {
    private ConnectionStringUtil() {
    }

    public static Set<SeedNode> seedNodesFromConnectionString(String cs, boolean dnsSrvEnabled, boolean tlsEnabled, EventBus eventBus) {
        ConnectionString connectionString = ConnectionString.create(cs);
        if (dnsSrvEnabled && connectionString.isValidDnsSrv()) {
            String srvHostname = connectionString.hosts().get(0).hostname();
            long start = System.nanoTime();
            try {
                if (srvHostname.startsWith("_couchbase._tcp.")) {
                    srvHostname = srvHostname.replace("_couchbase._tcp.", "");
                } else if (srvHostname.startsWith("_couchbases._tcp.")) {
                    srvHostname = srvHostname.replace("_couchbases._tcp.", "");
                }
                List<String> foundNodes = DnsSrv.fromDnsSrv(srvHostname, false, tlsEnabled);
                if (foundNodes.isEmpty()) {
                    throw new IllegalStateException("The loaded DNS SRV list from " + srvHostname + " is empty!");
                }
                Duration took = Duration.ofNanos(System.nanoTime() - start);
                eventBus.publish(new DnsSrvRecordsLoadedEvent(took, foundNodes));
                return foundNodes.stream().map(SeedNode::create).collect(Collectors.toSet());
            }
            catch (Throwable t) {
                Duration took = Duration.ofNanos(System.nanoTime() - start);
                if (t instanceof NameNotFoundException) {
                    eventBus.publish(new DnsSrvLookupFailedEvent(Event.Severity.INFO, took, null, DnsSrvLookupFailedEvent.Reason.NAME_NOT_FOUND));
                } else {
                    eventBus.publish(new DnsSrvLookupFailedEvent(Event.Severity.WARN, took, t, DnsSrvLookupFailedEvent.Reason.OTHER));
                }
                return ConnectionStringUtil.populateSeedsFromConnectionString(connectionString);
            }
        }
        eventBus.publish(new DnsSrvLookupDisabledEvent(dnsSrvEnabled, connectionString.isValidDnsSrv()));
        return ConnectionStringUtil.populateSeedsFromConnectionString(connectionString);
    }

    private static Set<SeedNode> populateSeedsFromConnectionString(ConnectionString connectionString) {
        return connectionString.hosts().stream().map(a -> SeedNode.create(a.hostname(), a.port() > 0 ? Optional.of(a.port()) : Optional.empty(), Optional.empty())).collect(Collectors.toSet());
    }
}

