/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.annotation.Stability;

@Stability.Volatile
public enum RetryReason {
    UNKNOWN(false, false),
    ENDPOINT_NOT_AVAILABLE(true, false),
    ENDPOINT_TEMPORARILY_NOT_AVAILABLE(true, true),
    ENDPOINT_CIRCUIT_OPEN(true, false),
    SERVICE_NOT_AVAILABLE(true, false),
    NODE_NOT_AVAILABLE(true, false),
    KV_NOT_MY_VBUCKET(true, true),
    KV_COLLECTION_OUTDATED(true, true),
    KV_ERROR_MAP_INDICATED(true, false),
    KV_LOCKED(true, false),
    KV_TEMPORARY_FAILURE(true, false),
    KV_SYNC_WRITE_IN_PROGRESS(true, false),
    KV_SYNC_WRITE_RE_COMMIT_IN_PROGRESS(true, false),
    NOT_PIPELINED_REQUEST_IN_FLIGHT(true, true),
    ENDPOINT_NOT_WRITABLE(true, false),
    CHANNEL_CLOSED_WHILE_IN_FLIGHT(false, false),
    BUCKET_NOT_AVAILABLE(true, false),
    BUCKET_OPEN_IN_PROGRESS(true, false),
    GLOBAL_CONFIG_LOAD_IN_PROGRESS(true, false),
    COLLECTION_MAP_REFRESH_IN_PROGRESS(true, false),
    VIEWS_TEMPORARY_FAILURE(true, false),
    VIEWS_NO_ACTIVE_PARTITION(true, true),
    SEARCH_TOO_MANY_REQUESTS(true, false),
    QUERY_PREPARED_STATEMENT_FAILURE(true, false),
    QUERY_INDEX_NOT_FOUND(true, false),
    ANALYTICS_TEMPORARY_FAILURE(true, false);

    private final boolean allowsNonIdempotentRetry;
    private final boolean alwaysRetry;

    private RetryReason(boolean allowsNonIdempotentRetry, boolean alwaysRetry) {
        this.allowsNonIdempotentRetry = allowsNonIdempotentRetry;
        this.alwaysRetry = alwaysRetry;
    }

    boolean allowsNonIdempotentRetry() {
        return this.allowsNonIdempotentRetry;
    }

    boolean alwaysRetry() {
        return this.alwaysRetry;
    }
}

