/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.io;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.logging.RedactableArgument;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Optional;

public class IoContext
extends CoreContext {
    private final SocketAddress localSocket;
    private final SocketAddress remoteSocket;
    private final Optional<String> bucket;

    public IoContext(CoreContext ctx, SocketAddress localSocket, SocketAddress remoteSocket, Optional<String> bucket) {
        super(ctx.core(), ctx.id(), ctx.environment(), ctx.authenticator());
        this.localSocket = localSocket;
        this.remoteSocket = remoteSocket;
        this.bucket = bucket;
    }

    @Override
    public void injectExportableParams(Map<String, Object> input) {
        super.injectExportableParams(input);
        input.put("local", RedactableArgument.redactSystem(this.localSocket()));
        input.put("remote", RedactableArgument.redactSystem(this.remoteSocket()));
        this.bucket.ifPresent(s -> input.put("bucket", RedactableArgument.redactMeta(s)));
    }

    public SocketAddress localSocket() {
        return this.localSocket;
    }

    public SocketAddress remoteSocket() {
        return this.remoteSocket;
    }

    public Optional<String> bucket() {
        return this.bucket;
    }
}

