/*
 * Decompiled with CFR 0.152.
 */
package org.dmfs.httpessentials.headers;

import java.util.ArrayList;
import java.util.List;
import org.dmfs.httpessentials.converters.ListConverter;
import org.dmfs.httpessentials.headers.BasicHeader;
import org.dmfs.httpessentials.headers.Header;
import org.dmfs.httpessentials.headers.HeaderType;
import org.dmfs.httpessentials.headers.ListHeaderType;
import org.dmfs.httpessentials.typedentity.EntityConverter;

public final class BasicListHeaderType<ValueType>
implements ListHeaderType<ValueType> {
    private final String mHeaderName;
    private final EntityConverter<List<ValueType>> mValueConverter;

    public BasicListHeaderType(String headerName, EntityConverter<ValueType> valueConverter) {
        this.mHeaderName = headerName;
        this.mValueConverter = new ListConverter(valueConverter);
    }

    public String name() {
        return this.mHeaderName;
    }

    public Header<List<ValueType>> entityFromString(String headerValueString) {
        return new BasicHeader<Object>((HeaderType<Object>)this, this.mValueConverter.value(headerValueString));
    }

    public Header<List<ValueType>> entity(List<ValueType> value) {
        return new BasicHeader<List<ValueType>>(this, value);
    }

    public String valueString(List<ValueType> headerValue) {
        return this.mValueConverter.valueString(headerValue);
    }

    public List<ValueType> valueFromString(String valueString) {
        return (List)this.mValueConverter.value(valueString);
    }

    public int hashCode() {
        return this.mHeaderName.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof ListHeaderType && this.mHeaderName.equals(((HeaderType)obj).name());
    }

    public Header<List<ValueType>> merged(Header<List<ValueType>> value1, Header<List<ValueType>> value2) {
        List list1 = (List)value1.value();
        List list2 = (List)value2.value();
        if (list1.size() == 0) {
            return value2;
        }
        if (list2.size() == 0) {
            return value1;
        }
        ArrayList merged = new ArrayList(list1.size() + list2.size());
        merged.addAll(list1);
        merged.addAll(list2);
        return this.entity(merged);
    }
}

