/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.traverser.impl;

import org.flasck.flas.compiler.ModuleExtensible;
import org.flasck.flas.compiler.jsgen.JSGenerator;
import org.flasck.flas.compiler.modules.TraverserModule;
import org.flasck.flas.method.ConvertRepositoryMethods;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryVisitor;
import org.flasck.flas.repository.Traverser;
import org.flasck.flas.repository.flim.FlimVisitor;
import org.flasck.flas.resolver.RepositoryResolver;
import org.ziniki.compiler.flim.ZinikiFlimWriter;
import org.ziniki.compiler.gen.ZinikiConvertor;
import org.ziniki.compiler.gen.ZinikiGenerator;
import org.ziniki.compiler.parsing.impl.SecondaryDefn;
import org.ziniki.compiler.parsing.impl.ZinikiBindPersonaStep;
import org.ziniki.compiler.parsing.impl.ZinikiBindStep;
import org.ziniki.compiler.parsing.impl.ZinikiDataStep;
import org.ziniki.compiler.parsing.impl.ZinikiDumpStep;
import org.ziniki.compiler.parsing.impl.ZinikiHasBenchStep;
import org.ziniki.compiler.parsing.impl.ZinikiHasEntityLinkStep;
import org.ziniki.compiler.parsing.impl.ZinikiUserStep;
import org.ziniki.compiler.resolver.ZinikiRepositoryResolver;
import org.ziniki.compiler.traverser.impl.ZinikiTraversalProcessor;

public class ZinikiTraverser
implements TraverserModule {
    public boolean visitEntry(Traverser traverser, RepositoryVisitor visitor, RepositoryEntry e) {
        this.attempt(traverser, visitor, e, ZinikiRepositoryResolver.class, RepositoryResolver.class);
        this.attempt(traverser, visitor, e, ZinikiConvertor.class, ConvertRepositoryMethods.class);
        this.attempt(traverser, visitor, e, ZinikiGenerator.class, JSGenerator.class);
        this.attempt(traverser, visitor, e, ZinikiFlimWriter.class, FlimVisitor.class);
        return e instanceof SecondaryDefn;
    }

    private void attempt(Traverser traverser, RepositoryVisitor visitor, RepositoryEntry e, Class<? extends ZinikiTraversalProcessor> isa, Class<? extends RepositoryVisitor> phase) {
        if (!(visitor instanceof ModuleExtensible)) {
            return;
        }
        ZinikiTraversalProcessor module = (ZinikiTraversalProcessor)((ModuleExtensible)visitor).forModule(isa, phase);
        if (module != null && e instanceof SecondaryDefn) {
            module.visitSecondaryDefn(visitor, (SecondaryDefn)e);
        }
    }

    public boolean visitUnitTestStep(Traverser traverser, RepositoryVisitor visitor, UnitTestStep s) {
        if (visitor instanceof ModuleExtensible) {
            if (this.consider(traverser, visitor, s, ZinikiRepositoryResolver.class, RepositoryResolver.class)) {
                return true;
            }
            if (this.consider(traverser, visitor, s, ZinikiConvertor.class, ConvertRepositoryMethods.class)) {
                return true;
            }
            if (this.consider(traverser, visitor, s, ZinikiGenerator.class, JSGenerator.class)) {
                return true;
            }
        }
        return s instanceof ZinikiDataStep || s instanceof ZinikiUserStep || s instanceof ZinikiDumpStep || s instanceof ZinikiBindStep || s instanceof ZinikiBindPersonaStep || s instanceof ZinikiHasBenchStep || s instanceof ZinikiHasEntityLinkStep;
    }

    private boolean consider(Traverser traverser, RepositoryVisitor visitor, UnitTestStep s, Class<? extends ZinikiTraversalProcessor> isa, Class<? extends RepositoryVisitor> phase) {
        ZinikiTraversalProcessor module = (ZinikiTraversalProcessor)((ModuleExtensible)visitor).forModule(isa, phase);
        if (module != null) {
            if (s instanceof ZinikiDataStep) {
                ZinikiDataStep zds = (ZinikiDataStep)s;
                module.visitDataStep(visitor, zds);
                traverser.visitExpr(zds.name, 0);
                module.leaveDataStep(visitor, zds);
                return true;
            }
            if (s instanceof ZinikiUserStep) {
                ZinikiUserStep zus = (ZinikiUserStep)s;
                module.visitUserStep(visitor, zus);
                traverser.visitExpr(zus.name, 0);
                module.leaveUserStep(visitor, zus);
                return true;
            }
            if (s instanceof ZinikiDumpStep) {
                ZinikiDumpStep zds = (ZinikiDumpStep)s;
                module.visitDumpStep(visitor, zds);
                traverser.visitExpr(zds.name, 0);
                module.leaveDumpStep(visitor, zds);
                return true;
            }
            if (s instanceof ZinikiHasBenchStep) {
                ZinikiHasBenchStep zhbs = (ZinikiHasBenchStep)s;
                module.visitHasBenchStep(visitor, zhbs);
                traverser.visitExpr(zhbs.name, 0);
                module.leaveHasBenchStep(visitor, zhbs);
                return true;
            }
            if (s instanceof ZinikiHasEntityLinkStep) {
                ZinikiHasEntityLinkStep zhels = (ZinikiHasEntityLinkStep)s;
                module.visitHasEntityLinkStep(visitor, zhels);
                traverser.visitExpr(zhels.name, 0);
                module.leaveHasEntityLinkStep(visitor, zhels);
                return true;
            }
            if (s instanceof ZinikiBindStep) {
                ZinikiBindStep zbs = (ZinikiBindStep)s;
                module.visitBindStep(visitor, zbs);
                traverser.visitExpr(zbs.zinikiName, 0);
                traverser.visitExpr(zbs.ziid(), 0);
                module.leaveBindStep(visitor, zbs);
                return true;
            }
            if (s instanceof ZinikiBindPersonaStep) {
                ZinikiBindPersonaStep zbs = (ZinikiBindPersonaStep)s;
                module.visitBindPersonaStep(visitor, zbs);
                traverser.visitExpr(zbs.zinikiName, 0);
                traverser.visitExpr(zbs.arena, 0);
                traverser.visitExpr(zbs.bench, 0);
                traverser.visitExpr(zbs.identity, 0);
                module.leaveBindPersonaStep(visitor, zbs);
                return true;
            }
        }
        return false;
    }
}

