/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.parsing.impl;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.st.SystemTestStage;
import org.flasck.flas.parsedForm.ut.UnitTestStep;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATypeReferenceParser;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.parser.VarNamer;
import org.flasck.flas.parser.ut.IntroduceNamer;
import org.flasck.flas.parser.ut.TestStepNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.StringToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.ziniki.compiler.parsing.impl.ZinikiBindPersonaStep;
import org.ziniki.compiler.parsing.impl.ZinikiBindStep;
import org.ziniki.compiler.parsing.impl.ZinikiDataStep;
import org.ziniki.compiler.parsing.impl.ZinikiDumpStep;
import org.ziniki.compiler.parsing.impl.ZinikiHasBenchStep;
import org.ziniki.compiler.parsing.impl.ZinikiHasEntityLinkStep;
import org.ziniki.compiler.parsing.impl.ZinikiUserStep;

public class ZinikiCommandParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final TestStepNamer namer;
    private final SystemTestStage stg;
    private final Expr zinikiName;
    private final TopLevelDefinitionConsumer topLevel;
    private final LocationTracker parentTracker;

    public ZinikiCommandParser(ErrorReporter errors, TestStepNamer namer, SystemTestStage stg, Expr expr, TopLevelDefinitionConsumer topLevel, LocationTracker parentTracker) {
        this.errors = errors;
        this.namer = namer;
        this.stg = stg;
        this.zinikiName = expr;
        this.topLevel = topLevel;
        this.parentTracker = parentTracker;
    }

    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken sc = KeywordToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
        if (sc == null) {
            this.errors.message(toks, "ziniki command requires a sub-command");
            return new IgnoreNestedParser(this.errors);
        }
        toks.skipWS(this.errors);
        int mark = toks.at();
        InputPosition loc = toks.realinfo();
        switch (sc.text) {
            case "datastore": {
                String dir = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                ExprToken tok = new ExprToken(loc, 5, dir).original(toks.fromMark(mark));
                this.errors.logParsingToken((LoggableToken)tok);
                if (dir == null) {
                    this.errors.message(toks, "data directory expected");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.stg.other((UnitTestStep)new ZinikiDataStep(this.zinikiName, new StringLiteral(loc, dir)));
                this.errors.logReduction("ziniki-st-datastore", sc.location, tok.location);
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
            case "user": {
                String user = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                this.errors.logParsingToken((LoggableToken)new ExprToken(loc, 5, user).original(toks.fromMark(mark)));
                if (user == null) {
                    this.errors.message(toks, "user name expected");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.stg.other((UnitTestStep)new ZinikiUserStep(this.zinikiName, new StringLiteral(loc, user)));
                this.errors.logReduction("ziniki-st-user", sc.location, loc);
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
            case "dump": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.stg.other((UnitTestStep)new ZinikiDumpStep(this.zinikiName));
                this.errors.logReduction("ziniki-st-dump", sc.location, loc);
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
            case "bind": {
                ArrayList trs = new ArrayList();
                Consumer<TypeReference> consumer = tr -> trs.add(tr);
                new TDATypeReferenceParser(this.errors, (VarNamer)this.namer, consumer, (FunctionScopeUnitConsumer)this.topLevel).tryParsing(toks);
                if (trs.isEmpty()) {
                    this.errors.message(toks, "ziniki bind requires a type");
                    return new IgnoreNestedParser(this.errors);
                }
                ValidIdentifierToken var = VarNameToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (var == null) {
                    this.errors.message(toks, "ziniki bind requires a var");
                    return new IgnoreNestedParser(this.errors);
                }
                ArrayList exprs = new ArrayList();
                Consumer<Expr> exprHandler = e -> exprs.add(e);
                TDAExpressionParser ep = new TDAExpressionParser(this.errors, exprHandler);
                ep.tryParsing(toks);
                if (exprs.isEmpty()) {
                    this.errors.message(toks, "ziniki bind requires an id");
                    return new IgnoreNestedParser(this.errors);
                }
                IntroduceVar iv = new IntroduceVar(var.location, (IntroduceNamer)this.namer, var.text);
                this.topLevel.newIntroduction(this.errors, iv);
                this.stg.other((UnitTestStep)new ZinikiBindStep(this.zinikiName, (TypeReference)trs.get(0), iv, (Expr)exprs.get(0)));
                this.errors.logReduction("ziniki-st-bind", sc.location, ((Expr)exprs.get(0)).location());
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
            case "hasbench": {
                InputPosition idloc = toks.realinfo();
                String arenaid = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (arenaid == null) {
                    this.errors.message(toks, "arena id expected");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken((LoggableToken)new ExprToken(loc, 5, arenaid).original(toks.fromMark(mark)));
                toks.skipWS(this.errors);
                mark = toks.at();
                InputPosition benchloc = toks.realinfo();
                String bench = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (bench == null) {
                    this.errors.message(toks, "bench name expected");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken((LoggableToken)new ExprToken(benchloc, 5, bench).original(toks.fromMark(mark)));
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.stg.other((UnitTestStep)new ZinikiHasBenchStep(this.zinikiName, new StringLiteral(idloc, arenaid), new StringLiteral(benchloc, bench)));
                this.errors.logReduction("ziniki-st-hasbench", sc.location, benchloc);
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
            case "hasentitylink": {
                InputPosition idloc = toks.realinfo();
                String benchId = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (benchId == null) {
                    this.errors.message(toks, "bench id expected");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken((LoggableToken)new ExprToken(loc, 5, benchId).original(toks.fromMark(mark)));
                toks.skipWS(this.errors);
                mark = toks.at();
                InputPosition entityloc = toks.realinfo();
                String entityid = StringToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (entityid == null) {
                    this.errors.message(toks, "entity id expected");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logParsingToken((LoggableToken)new ExprToken(entityloc, 5, entityid).original(toks.fromMark(mark)));
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "junk at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.stg.other((UnitTestStep)new ZinikiHasEntityLinkStep(this.zinikiName, new StringLiteral(idloc, benchId), new StringLiteral(entityloc, entityid)));
                this.parentTracker.updateLoc(sc.location);
                this.errors.logReduction("ziniki-st-hasentitylink", sc.location, entityloc);
                return new NoNestingParser(this.errors);
            }
            case "bindpersona": {
                Expr e2;
                ArrayList trs = new ArrayList();
                Consumer<TypeReference> consumer = tr -> trs.add(tr);
                new TDATypeReferenceParser(this.errors, (VarNamer)this.namer, consumer, (FunctionScopeUnitConsumer)this.topLevel).tryParsing(toks);
                if (trs.isEmpty()) {
                    this.errors.message(toks, "ziniki bindPersona requires a type");
                    return new IgnoreNestedParser(this.errors);
                }
                ValidIdentifierToken var = VarNameToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (var == null) {
                    this.errors.message(toks, "ziniki bind requires a var");
                    return new IgnoreNestedParser(this.errors);
                }
                ArrayList<Expr> exprs = new ArrayList<Expr>();
                Consumer<Expr> exprHandler = e -> exprs.add((Expr)e);
                TDAExpressionParser ep = new TDAExpressionParser(this.errors, exprHandler);
                ep.tryParsing(toks);
                if (exprs.size() == 1 && (e2 = (Expr)exprs.remove(0)) instanceof ApplyExpr) {
                    ApplyExpr ae = (ApplyExpr)e2;
                    exprs.add((Expr)ae.fn);
                    for (Object o : ae.args) {
                        exprs.add((Expr)o);
                    }
                }
                if (exprs.size() != 3) {
                    this.errors.message(toks, "ziniki bindPersona requires an arena, bench and identity");
                    return new IgnoreNestedParser(this.errors);
                }
                IntroduceVar iv = new IntroduceVar(var.location, (IntroduceNamer)this.namer, var.text);
                this.topLevel.newIntroduction(this.errors, iv);
                this.stg.other((UnitTestStep)new ZinikiBindPersonaStep(this.zinikiName, (TypeReference)trs.get(0), iv, (Expr)exprs.get(0), (Expr)exprs.get(1), (Expr)exprs.get(2)));
                this.errors.logReduction("ziniki-st-bindpersona", sc.location, ((Expr)exprs.get(2)).location());
                this.parentTracker.updateLoc(sc.location);
                return new NoNestingParser(this.errors);
            }
        }
        this.errors.message(sc.location, "no ziniki subcommand " + sc.text);
        return new IgnoreNestedParser(this.errors);
    }

    public void scopeComplete(InputPosition location) {
    }

    public InputPosition exprLoc() {
        return this.zinikiName.location();
    }
}

