/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.parsing.impl;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.ziniki.compiler.parsing.impl.SecondaryDefn;

public class SecondaryFieldParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final SecondaryDefn sd;
    private final LocationTracker locTracker;

    public SecondaryFieldParser(ErrorReporter errors, SecondaryDefn sd, LocationTracker locTracker) {
        this.errors = errors;
        this.sd = sd;
        this.locTracker = locTracker;
    }

    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken var = VarNameToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
        if (var == null) {
            this.errors.message(toks, "invalid or missing field name");
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.sd.addField(new UnresolvedVar(var.location, var.text));
        this.errors.logReduction("secondary-key-field", var.location, var.location);
        if (this.locTracker != null) {
            this.locTracker.updateLoc(var.location);
        }
        return new NoNestingParser(this.errors);
    }

    public void scopeComplete(InputPosition location) {
    }
}

