/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.compiler.flim;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;
import org.ziniki.compiler.parsing.impl.SecondaryDefn;
import org.zinutils.exceptions.CantHappenException;

public class SecondaryEntryParser
implements TDAParsing {
    private final ErrorReporter errors;
    private TypeReference contains;
    private String kind;
    private Repository repository;
    private NameOfThing container;
    private TypeNameToken tnt;
    private List<UnresolvedVar> fields = new ArrayList<UnresolvedVar>();

    public SecondaryEntryParser(ErrorReporter errors, Repository repository, NameOfThing container, TypeNameToken tnt) {
        this.errors = errors;
        this.repository = repository;
        this.container = container;
        this.tnt = tnt;
    }

    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
        if (kw == null) {
            throw new CantHappenException("null token in FLIM");
        }
        switch (kw.text) {
            case "kind": {
                KeywordToken kind = KeywordToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (kind == null) {
                    throw new CantHappenException("null token in FLIM");
                }
                this.kind = kind.text;
                return new NoNestingParser(this.errors);
            }
            case "bytype": {
                this.contains = null;
                return new NoNestingParser(this.errors);
            }
            case "type": {
                TypeNameToken tt = TypeNameToken.qualified((ErrorReporter)this.errors, (Tokenizable)toks);
                if (tt == null) {
                    throw new CantHappenException("not a qualified type");
                }
                this.contains = new TypeReference(tt.location, tt.text, new TypeReference[0]);
                return new NoNestingParser(this.errors);
            }
            case "field": {
                ValidIdentifierToken v = VarNameToken.from((ErrorReporter)this.errors, (Tokenizable)toks);
                if (v == null) {
                    throw new CantHappenException("not a var");
                }
                this.fields.add(new UnresolvedVar(v.location, v.text));
                return new NoNestingParser(this.errors);
            }
        }
        throw new CantHappenException("no such secondary field keyword: " + kw.text);
    }

    public void scopeComplete(InputPosition location) {
        SecondaryDefn sd = new SecondaryDefn(this.tnt.location, this.kind, new SolidName(this.container, this.tnt.text), this.contains);
        for (UnresolvedVar f : this.fields) {
            sd.addField(f);
        }
        sd.generate = false;
        this.repository.addEntry(this.errors, sd.name(), (RepositoryEntry)sd);
    }
}

