/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid.auth;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.Message;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.auth.CouchbaseServerAssociationStore;
import org.ziniki.openid.auth.fl.JVMAuthReq;
import org.ziniki.openid.auth.fl.JVMOpenidParams;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.GoingToBlock;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.IRandom;

public class Authenticator
implements RequestProcessor,
ProvideHostInfo,
RequestQueryAndPostParameters,
RelationHandler {
    private final Logger logger = LoggerFactory.getLogger((String)"Authenticator");
    private final TxManager txmanager;
    private final ZiIdFactory factory;
    private final IRandom random;
    private final String authurl;
    private final String challengeUrl;
    private final ServerManager provider;
    private String host;
    private String sequenceToken;
    private final Map<String, String[]> map = new HashMap<String, String[]>();

    public Authenticator(@Param(value="txmanager") TxManager txmanager, @Param(value="storage") TDAStorage storage, @Param(value="idfactory") ZiIdFactory factory, @Param(value="random") IRandom random, @Param(value="authurl") String authUrl, @Param(value="challengeUrl") String challengeUrl) {
        this.txmanager = txmanager;
        this.factory = factory;
        this.random = random;
        this.authurl = authUrl;
        this.challengeUrl = challengeUrl;
        this.provider = new ServerManager();
        this.provider.setSharedAssociations((ServerAssociationStore)new CouchbaseServerAssociationStore(txmanager, storage, factory, random, false));
        this.provider.setPrivateAssociations((ServerAssociationStore)new CouchbaseServerAssociationStore(txmanager, storage, factory, random, true));
        this.provider.setOPEndpointUrl(this.authurl);
    }

    public void provideHost(String name, int port) {
        this.host = name;
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("challengeid")) {
            this.sequenceToken = value;
        } else {
            this.map.put(name, new String[]{value});
        }
    }

    public void process(Responder resp) throws Exception {
        resp.setTimeout(1000, TimeUnit.SECONDS);
        UnitOfWork uow = this.txmanager.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        Relation r = uow.relation((RelationHandler)this);
        r.load((Object)resp);
        r.logic("doProcessing");
        if (this.sequenceToken == null) {
            r.load("params", (Object)new ParameterList(this.map));
        } else {
            this.logger.info("Getting parameters for " + this.sequenceToken);
            ZiId paramsId = this.factory.simple("openid", this.host, "params", this.sequenceToken);
            r.get("params", paramsId.toString(), jvm -> jvm == null ? null : jvm.asParameterList());
        }
        uow.enact();
    }

    @GoingToBlock
    public void doProcessing(UnitOfWork uow, Relation r, Responder resp, @Slot(value="params") ParameterList params) {
        String handle = "undefined";
        if (params != null) {
            handle = params.getParameterValue("openid.assoc_handle");
            this.logger.info("openid.assoc_handle = " + handle);
        }
        try {
            Object responseIs = null;
            if (params == null) {
                responseIs = this.sequenceToken == null ? "no parameters specified" : "invalid request token";
            } else if (params.hasParameter("openid.mode")) {
                String mode = params.getParameterValue("openid.mode");
                this.logger.info("auth mode = " + mode);
                if (mode.equals("associate")) {
                    this.logger.info("Associating response with " + handle);
                    responseIs = this.provider.associationResponse(params).keyValueFormEncoding();
                } else if (mode.equals("checkid_setup")) {
                    this.logger.info("Approving " + handle + " with " + this.sequenceToken);
                    r.logic("onApproved");
                    if (this.sequenceToken == null) {
                        r.load("approved", null);
                        return;
                    }
                    ZiId approvalId = this.factory.simple("openid", this.host, "approvals", this.sequenceToken);
                    r.get("approved", approvalId.toString(), rec -> rec.getClaimedId());
                } else if (mode.equals("check_authentication")) {
                    try {
                        this.logger.info("Check Authentication on " + handle);
                        this.sendResponse(resp, this.provider.verify(params).keyValueFormEncoding());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        responseIs = ex.toString();
                    }
                } else {
                    responseIs = "cannot handle openid mode " + mode;
                }
            } else {
                responseIs = "no openid.mode specified";
            }
            if (responseIs != null) {
                this.logger.info("responding with " + (String)responseIs);
                this.sendResponse(resp, (String)responseIs);
            }
        }
        catch (Exception ex) {
            this.sendError(resp, ex);
        }
    }

    @GoingToBlock
    public void onApproved(UnitOfWork uow, Relation r, Responder resp, @Slot(value="params") ParameterList params, @Slot(value="approved") String approved) {
        block6: {
            GLUnitOfWork zu = (GLUnitOfWork)uow;
            try {
                this.logger.info("onApproved, approved = " + approved);
                if (approved == null) {
                    String tok = "ar" + this.random.nextInt(Integer.MAX_VALUE);
                    ZiId id = this.factory.simple("openid", this.host, "authreq", tok);
                    r.logic("nextAuthReqToken");
                    r.create(id.toString(), (Object)new JVMAuthReq((FLEvalContext)zu));
                    r.load("tok", (Object)tok);
                    break block6;
                }
                String claimedId = approved;
                try {
                    Message msg = this.provider.authResponse(params, claimedId, claimedId, true);
                    this.logger.info("Returned msg was " + msg);
                    if (msg instanceof AuthSuccess) {
                        r.delete(this.factory.simple("openid", this.host, "authreq", this.sequenceToken).toString());
                        r.delete(this.factory.simple("openid", this.host, "approvals", this.sequenceToken).toString());
                        r.delete(this.factory.simple("openid", this.host, "params", this.sequenceToken).toString());
                        String sendTo = ((AuthSuccess)msg).getDestinationUrl(true);
                        this.logger.info("Success ... redirecting to " + sendTo);
                        resp.redirectTo(sendTo);
                        break block6;
                    }
                    this.logger.error("Failed to authenticate ... " + msg);
                    this.sendResponse(resp, "<pre>" + msg.keyValueFormEncoding() + "</pre>");
                }
                catch (Throwable ex) {
                    this.logger.error("error handling approval", ex);
                    this.sendError(resp, ex);
                }
            }
            catch (Exception ex) {
                this.logger.error("error during authentication", (Throwable)ex);
                throw WrappedException.wrap((Throwable)ex);
            }
        }
    }

    public void nextAuthReqToken(UnitOfWork uow, Relation r, Responder resp, @Slot(value="params") ParameterList params, @Slot(value="tok") String tokName) throws GLSException {
        this.logger.info("handle = " + tokName);
        if (tokName == null) {
            throw new RuntimeException("tok cannot be null");
        }
        ZiId paramsId = this.factory.simple("openid", this.host, "params", tokName);
        JVMOpenidParams saveAs = Authenticator.makeOIDP(uow, params);
        r.whenCommitted("sendToChallenge");
        r.upsert(paramsId.toString(), (Object)saveAs);
    }

    public static JVMOpenidParams makeOIDP(UnitOfWork uow, ParameterList params) {
        JVMOpenidParams saveAs = new JVMOpenidParams((FLEvalContext)uow);
        for (Object x : params.getParameters()) {
            Parameter p = (Parameter)x;
            saveAs.set(p.getKey(), p.getValue());
        }
        return saveAs;
    }

    public void sendToChallenge(Responder resp, @Slot(value="tok") String tokName) {
        String cp = this.challengeUrl + "?challengeid=" + tokName;
        this.logger.info("sending to challenge page: " + cp);
        try {
            resp.redirectTo(cp);
        }
        catch (IOException ex) {
            this.logger.error("Error sending challenge", (Throwable)ex);
        }
    }

    private void sendResponse(Responder r, String responseText) throws IOException, NotReadyException {
        r.write(responseText, null);
        r.done();
    }

    private void sendError(Responder r, Throwable ex) {
        try {
            ex.printStackTrace();
            r.setStatus(500);
            r.setContentType("text/plain");
            r.write(ex.toString(), null);
            r.done();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

