/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.grizzly.chrome;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.testrunner.JSJavaBridge;
import org.flasck.jvm.container.FLASBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.coreimpl.ServerEnvironment;
import org.ziniki.server.main.grizzly.chrome.ChromeZiwshGrizzlyListener;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.ziwsh.grizzly.GrizzlyConnectionStore;
import org.ziniki.ziwsh.intf.EvalContextFactory;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.reflection.Reflection;
import org.zinutils.sync.LockingCounter;

public class ChromeJSJavaBridge
implements JSJavaBridge,
WSReceiver {
    protected static Logger logger = LoggerFactory.getLogger((String)"TestRunner");
    protected static Logger debugLogger = LoggerFactory.getLogger((String)"DebugLog");
    protected final List<String> errors = new ArrayList<String>();
    final Map<Class<?>, Object> modules = new HashMap();
    final LockingCounter counter = new LockingCounter();
    private final ClassLoader classloader;
    private final File root;
    private Map<String, Object> conns = new TreeMap<String, Object>();
    private int next = 1;

    ChromeJSJavaBridge(ClassLoader classloader, File root) {
        this.classloader = classloader;
        this.root = root;
    }

    public void open(WSResponder responder) {
        logger.info("opened chrome ws");
    }

    public void onText(WSResponder responder, String text) {
        logger.info("received " + text);
        try {
            JSONObject jo = new JSONObject(text);
            String action = jo.getString("action");
            if (jo.has("conn")) {
                String c = jo.getString("conn");
                int reqId = jo.getInt("requestId");
                Object module = this.conns.get(c);
                JSONArray ja = jo.getJSONArray("args");
                Object[] args = new Object[ja.length()];
                for (int i = 0; i < ja.length(); ++i) {
                    args[i] = ja.get(i);
                }
                Object resp = Reflection.call((Object)module, (String)action, (Object[])args);
                if (resp == null || !(resp instanceof JSONObject)) {
                    resp = new JSONObject();
                }
                ((JSONObject)resp).put("action", (Object)"response").put("respondingTo", reqId);
                responder.send(resp.toString());
                return;
            }
            switch (action) {
                case "step": {
                    Thread.sleep(100L);
                    this.counter.waitForZero(2500);
                    responder.send(new JSONObject().put("action", (Object)"stepdone").toString());
                    break;
                }
                case "module": {
                    String name = jo.getString("name");
                    Object ret = this.module(null, name);
                    String conn = "conn" + this.next++;
                    this.conns.put(conn, ret);
                    responder.send(new JSONObject().put("action", (Object)"haveModule").put("name", (Object)name).put("clz", (Object)"ZinTestModule").put("conn", (Object)conn).toString());
                    break;
                }
                default: {
                    throw new InvalidUsageException("there is no action '" + action + "'");
                }
            }
        }
        catch (Throwable ex) {
            logger.error("error processing " + text, ex);
        }
    }

    public void error() {
        logger.error("error on chrome ws");
    }

    public void close(Object t) {
        logger.info("closed chrome ws");
    }

    public void error(String s) {
        this.errors.add(s);
    }

    public void log(String s) {
        logger.info(s);
    }

    public void debugmsg(String s) {
        debugLogger.info(s);
    }

    public Object module(Object runner, String s) {
        try {
            Class<?> clz = Class.forName(s);
            if (!this.modules.containsKey(clz)) {
                ServerEnvironment env = new ServerEnvironment();
                FLASBroker broker = new FLASBroker((EvalContextFactory)env);
                env.provideBroker((ZiwshBroker)broker);
                env.provideWebSocketFinder((WebSocketFinder)new GrizzlyConnectionStore((ZiwshBroker)broker));
                this.modules.put(clz, Reflection.callStatic(clz, (String)"createChrome", (Object[])new Object[]{this, this.classloader, this.root, env}));
            }
            return this.modules.get(clz);
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public void transport(JsonSender toZiniki) {
    }

    public void sendJson(String json) {
        throw new NotImplementedException();
    }

    public LockingCounter getTestCounter() {
        return this.counter;
    }

    public void ziwsh(ChromeZiwshGrizzlyListener ziwsh) {
    }
}

