/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.config;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.ErrorResult;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.Repository;
import org.flasck.flas.repository.flim.FlimReader;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.common.UOWHost;
import org.ziniki.core.concepts.Arena;
import org.ziniki.core.concepts.Domain;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.server.di.ConfigCascadeException;
import org.ziniki.server.di.ConfigException;
import org.ziniki.server.di.ConstantExtractor;
import org.ziniki.server.di.ConstantFormatter;
import org.ziniki.server.di.DehydratedHandler;
import org.ziniki.server.di.DirectSingleton;
import org.ziniki.server.di.GetFrom;
import org.ziniki.server.di.IgnoreException;
import org.ziniki.server.di.Instantiatable;
import org.ziniki.server.di.Instantiator;
import org.ziniki.server.di.OnWired;
import org.ziniki.server.di.ReferenceExtractor;
import org.ziniki.server.main.aws.CopyReader;
import org.ziniki.server.main.config.InitializationLogic;
import org.ziniki.server.main.config.ZinikiServerMappings;
import org.ziniki.server.main.config.ZinikiTDAServer;
import org.ziniki.server.path.PathTree;
import org.ziniki.servlet.CompleteDomain;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.storage.memory.IMContentStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.collections.CollectionUtils;
import org.zinutils.collections.ListMap;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.exceptions.UtilException;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.graphs.DependencyGraph;
import org.zinutils.graphs.DirectedAcyclicGraph;
import org.zinutils.graphs.Node;
import org.zinutils.utils.FileUtils;

public class ConfigurationOptions {
    public static final Logger logger = LoggerFactory.getLogger((String)"DI");
    private final Map<String, DehydratedHandler<?>> processors = new HashMap();
    DependencyGraph<Instantiatable> graph = new DependencyGraph();
    Map<String, Object> items = new TreeMap<String, Object>();
    private TreeSet<String> errors = new TreeSet();
    private List<ConfigCascadeException> cascades = new ArrayList<ConfigCascadeException>();
    private final List<ZinikiTDAServer> servers = new ArrayList<ZinikiTDAServer>();
    private final Map<String, ZinikiServerMappings> mappingList = new TreeMap<String, ZinikiServerMappings>();
    private final List<URI> users = new ArrayList<URI>();
    private final List<File> imports = new ArrayList<File>();
    private TreeMap<String, Arena> appArenas;

    public ConfigurationOptions(CopyReader s3, String[] args) throws Exception {
        Object root = JSONObject.EXPLICIT_NULL;
        ArrayList<ConfigSource> configs = new ArrayList<ConfigSource>();
        this.items.put("root", root);
        for (int i = 0; i < args.length; ++i) {
            String file;
            if (args[i].equals("--root")) {
                root = new File(args[++i]);
                this.items.put("root", root);
                continue;
            }
            if (args[i].equals("--configFile")) {
                file = args[++i];
                configs.add(new ConfigSource(this.relative(root, file), file));
                continue;
            }
            if (args[i].equals("--config")) {
                configs.add(new ConfigSource(args[++i]));
                continue;
            }
            if (s3 != null && args[i].equals("--s3Config")) {
                file = args[++i];
                configs.add(new ConfigSource(s3.resolve(file), file));
                continue;
            }
            if (args[i].equals("--user")) {
                this.users.add(URI.create(args[++i]));
                continue;
            }
            if (args[i].equals("--import-flim")) {
                this.imports.add(new File(args[++i]));
                continue;
            }
            throw new RuntimeException("Invalid argument: " + args[i]);
        }
        if (s3 != null) {
            s3.andWait();
        }
        for (ConfigSource cs : configs) {
            cs.parse();
        }
        if (this.users.isEmpty() && !this.imports.isEmpty()) {
            this.errors.add("cannot import without specifying a domain via --user");
        }
        for (int i = 0; i < this.imports.size(); ++i) {
            File impi = this.imports.get(i);
            if (impi.isDirectory() || !(root instanceof File)) continue;
            File tmp = new File((File)root, impi.getPath());
            if (!tmp.isDirectory()) {
                this.errors.add("there is no import directory " + impi);
                continue;
            }
            this.imports.set(i, tmp);
        }
        if (!this.errors.isEmpty()) {
            throw new RuntimeException("errors in parsing configuration:\n" + String.join((CharSequence)"\n", this.errors));
        }
    }

    private File relative(Object root, String file) {
        File curr = new File(file);
        if (curr.exists()) {
            return curr;
        }
        if (root == JSONObject.EXPLICIT_NULL || curr.isAbsolute()) {
            throw new RuntimeException("There is no file " + curr);
        }
        File tmp = new File((File)root, file);
        if (tmp.exists()) {
            return tmp;
        }
        throw new RuntimeException("There is no file " + curr + " or " + tmp);
    }

    public void bind(String name, Object actual) {
        DirectSingleton n = new DirectSingleton(name, actual);
        this.items.put(name, n);
        this.graph.ensure((Object)n);
    }

    public void doConfiguration() throws Exception {
        block4: {
            try {
                this.configure();
                this.createServers();
                this.createUsersAndDomains();
            }
            catch (Exception ex) {
                if (!this.errors.isEmpty()) break block4;
                logger.error("unprocessed error in configuration", (Throwable)ex);
                throw ex;
            }
        }
        if (!this.errors.isEmpty()) {
            throw new ConfigException("errors in configuration:\n" + String.join((CharSequence)"\n", this.errors));
        }
        if (!this.cascades.isEmpty()) {
            throw new CantHappenException("cascaded errors were detected, but no actual errors" + this.cascades.get(0));
        }
    }

    private void createUsersAndDomains() {
        this.appArenas = new TreeMap();
        if (this.users.isEmpty()) {
            return;
        }
        ListMap domains = new ListMap();
        CompleteDomain cd = (CompleteDomain)((Instantiator)this.items.get("completeDomain")).instantiateSeparate(this.items);
        for (URI u : this.users) {
            String zd = u.getHost();
            if (!zd.startsWith("ziniki.")) {
                throw new ConfigException("user domain hosts must start with ziniki. not " + zd);
            }
            domains.add((Object)zd.replaceFirst("ziniki\\.", ""), (Object)u);
        }
        TxManager mgr = cd.getTxManager();
        UnitOfWork uow = mgr.newUnit();
        Relation r = uow.relation(null);
        for (String dom : domains) {
            Iterator it = domains.get((Object)dom).iterator();
            uow.trait(UOWHost.class, (Object)new UOWHost(dom));
            Domain domain = cd.createDomainOnDemand(uow, r, dom, ((URI)it.next()).toString());
            while (it.hasNext()) {
                cd.createUserInDomain(uow, r, domain, ((URI)it.next()).toString());
            }
        }
        uow.block();
        for (String dom : domains) {
            this.appArenas.put(dom, (Arena)r.obtain(Arena.class, "apparena-" + dom));
        }
    }

    public void onceStarted() throws Exception {
        this.doImporting();
    }

    private void doImporting() throws Exception {
        if (this.appArenas.isEmpty()) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        String version = sdf.format(new Date());
        ZiIdFactory factory = (ZiIdFactory)((Instantiator)this.items.get("urlidfactory")).getInstance();
        TxManager mgr = (TxManager)((Instantiator)this.items.get("zinikiTxMgr")).getInstance();
        IMContentStorage cs = (IMContentStorage)((Instantiator)this.items.get("contentStorage")).getInstance();
        UnitOfWork uow = mgr.newUnit();
        DirectedAcyclicGraph<String> dag = this.readImports();
        File flascklib = this.relative(this.items.get("root"), "flascklib");
        File[] modules = this.relative(this.items.get("root"), "modules").listFiles();
        FLEvalContext cx = (FLEvalContext)uow;
        for (Map.Entry<String, Arena> dom : this.appArenas.entrySet()) {
            ZiId aid = dom.getValue().ziid();
            InitializationLogic il = new InitializationLogic(factory, cs, cx, dom.getKey(), aid);
            Relation r = uow.relation(null);
            uow.trait(UOWHost.class, (Object)new UOWHost(dom.getKey()));
            InitializationLogic.CPP flcpp = il.createPackageVersion(r, "flascklib", version, new ArrayList<Object>());
            il.attach("runtime", flcpp.cpv, flascklib);
            for (File m : modules) {
                InitializationLogic.CPP cpp = il.createPackageVersion(r, m.getName(), version, new ArrayList<Object>());
                il.attach("modules/" + m.getName(), cpp.cpv, m);
            }
            dag.postOrderTraverse(npkg -> {
                try {
                    String pkg = (String)npkg.getEntry();
                    InitializationLogic.CPP cpp = il.createPackageVersion(r, pkg, version, new ArrayList<Object>());
                    for (File f : this.imports) {
                        String flim = null;
                        String jar = null;
                        ArrayList<String> mainjs = new ArrayList<String>();
                        ArrayList<String> testjs = new ArrayList<String>();
                        boolean found = false;
                        for (String h : f.list()) {
                            if (h.equals(pkg + ".js")) {
                                mainjs.add(h);
                            } else if (h.startsWith(pkg + "._")) {
                                testjs.add(h);
                            } else if (h.equals(pkg + ".flim")) {
                                flim = h;
                            } else {
                                if (!h.equals(pkg + ".jar")) continue;
                                jar = h;
                            }
                            found = true;
                        }
                        if (!found) continue;
                        il.attachDirect(pkg, cpp.cpv, f, "main", mainjs);
                        il.attachDirect(pkg, cpp.cpv, f, "test", testjs);
                        if (flim != null) {
                            il.upload("flim", pkg, cpp.cpv, f, flim, (List)cpp.cpv._field_flim(cx, new Object[0]), "text/flim");
                        }
                        if (jar != null) {
                            il.upload("jar", pkg, cpp.cpv, f, jar, (List)cpp.cpv._field_livejar(cx, new Object[0]), "application/jar");
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    throw WrappedException.wrap((Throwable)ex);
                }
            });
        }
        uow.block();
    }

    private DirectedAcyclicGraph<String> readImports() {
        ErrorResult er = new ErrorResult();
        Repository repository = new Repository();
        LoadBuiltins.applyTo((ErrorReporter)er, (Repository)repository);
        FlimReader r = new FlimReader((ErrorReporter)er, repository);
        DirectedAcyclicGraph pkgs = new DirectedAcyclicGraph();
        ArrayList butnot = new ArrayList();
        for (File impdir : this.imports) {
            r.read(pkgs, impdir, butnot);
        }
        if (er.hasErrors()) {
            try {
                er.showTo((Writer)new PrintWriter(System.out), 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new CantHappenException("failed to load imports");
        }
        return pkgs;
    }

    private void createServers() throws Exception {
        for (ZinikiTDAServer s : this.servers) {
            s.configure(this.errors, this.processors);
        }
    }

    public List<ZinikiTDAServer> servers() {
        return this.servers;
    }

    public ZinikiTDAServer getUniqueServer() {
        if (this.servers.size() > 1) {
            throw new UtilException("Cannot ask for unique server from " + this.servers);
        }
        if (this.servers.isEmpty()) {
            return null;
        }
        return this.servers.get(0);
    }

    private void readConfig(String config, String file) throws Exception {
        logger.info("Reading configuration from " + file);
        JSONObject jo = new JSONObject(config);
        Iterator it = jo.keys();
        while (it.hasNext()) {
            String k;
            block21: {
                Object val;
                k = (String)it.next();
                if (this.items.containsKey(k)) {
                    this.error("Duplicate entry " + k);
                }
                if ((val = jo.get(k)) instanceof JSONObject) {
                    try {
                        Instantiator n;
                        JSONObject cn = (JSONObject)val;
                        if (cn.has("class")) {
                            n = new Instantiator(file, k, this.toMap(cn), this.items, e -> this.error(e));
                        } else if (cn.has("getfrom")) {
                            n = new GetFrom(k, new ReferenceExtractor(cn.getString("getfrom")), cn.getString("method"));
                        } else {
                            this.error("Cannot handle " + k);
                            continue;
                        }
                        this.items.put(k, n);
                        this.graph.ensure((Object)n);
                    }
                    catch (IgnoreException n) {
                    }
                    catch (Throwable t) {
                        if (t instanceof NoClassDefFoundError) {
                            this.error("Could not find class: " + t.getMessage() + " when instantiating " + k);
                            break block21;
                        }
                        if (t instanceof ClassNotFoundException) {
                            this.error("Could not find class: " + t.getMessage() + " when instantiating " + k);
                            break block21;
                        }
                        this.error(t.getMessage() + " when instantiating " + k);
                    }
                } else if (val instanceof JSONArray) {
                    this.error("Cannot handle jsonarray as a value");
                } else if (val instanceof String) {
                    logger.info("  setting property " + k + ": " + val + " [" + file + "]");
                    String s = (String)val;
                    if (s.startsWith("%%")) {
                        this.items.put(k, new ConstantFormatter(s));
                    } else if (s.startsWith("%")) {
                        this.items.put(k, new ConstantExtractor(s));
                    } else {
                        this.items.put(k, val);
                    }
                } else {
                    logger.info("  setting property " + k + ": " + val + " [" + file + "]");
                    this.items.put(k, val);
                }
            }
            logger.info("bound item " + k + ": now have " + this.items.size());
        }
    }

    private Map<String, Object> toMap(JSONObject cn) throws JSONException {
        TreeMap<String, Object> ret = new TreeMap<String, Object>();
        Iterator it = cn.keys();
        while (it.hasNext()) {
            String s = (String)it.next();
            ret.put(s, cn.get(s));
        }
        return ret;
    }

    private void error(String string) {
        this.errors.add(string);
    }

    private void cascade(ConfigCascadeException cce) {
        this.cascades.add(cce);
    }

    private void configure() throws Exception {
        AtomicBoolean err = new AtomicBoolean(false);
        for (Instantiatable n2 : this.graph.nodes()) {
            for (ReferenceExtractor r : n2.getReferences()) {
                Object ref = this.items.get(r.actualName());
                while (ref instanceof String) {
                    String rr = (String)ref;
                    if (rr.startsWith("_") && rr.endsWith("_")) {
                        ref = this.items.get(rr.substring(1, rr.length() - 1));
                        continue;
                    }
                    throw new ConfigException("Invalid reference string: " + rr);
                }
                if (ref == null) {
                    logger.error("There is no definition for " + r + " when defining " + n2.getName());
                    this.error("  undefined: '" + r + "'");
                    err.set(true);
                    continue;
                }
                if (ref == JSONObject.EXPLICIT_NULL) {
                    logger.info("Explicitly set definition for " + r + " to NULL");
                    continue;
                }
                if (ref instanceof File) continue;
                if (!(ref instanceof Instantiatable)) {
                    throw new ConfigException(ref + " was not an Instantiable");
                }
                Instantiatable rn = (Instantiatable)ref;
                this.graph.ensureLink((Object)n2, (Object)rn);
            }
            n2.assertValidity(this.items, e -> this.error(e));
        }
        if (err.get()) {
            throw new RuntimeException("errors in configuration");
        }
        ExecutorService exec = Executors.newFixedThreadPool(25);
        int timeout = 60000;
        this.graph.leafFirstParallelTraversal(exec, n -> {
            logger.info("Processing " + n + " => " + ((Instantiatable)n.getEntry()).getName() + " " + exec.isShutdown());
            if (this.instantiate((Instantiatable)n.getEntry(), this.items)) {
                err.set(true);
            }
        }, timeout);
        logger.info("shutting down and awaiting termination of config exec");
        exec.shutdown();
        exec.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        logger.info("config exec shut down");
        if (err.get()) {
            throw new RuntimeException("errors in configuration");
        }
        this.graph.postOrderTraverse(n -> {
            if (((Instantiatable)n.getEntry()).hasInstance()) {
                ((Instantiatable)n.getEntry()).provideMe(((Instantiatable)n.getEntry()).getInstance(), this.items);
            }
        });
        this.graph.postOrderTraverse(n -> {
            if (((Instantiatable)n.getEntry()).hasInstance() && ((Instantiatable)n.getEntry()).getInstance() instanceof OnWired) {
                ((OnWired)((Instantiatable)n.getEntry()).getInstance()).onWired();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean instantiate(Instantiatable instantiatable, Map<String, Object> items) {
        try {
            if (instantiatable.willBeA(RequestProcessor.class, items)) {
                Map<String, DehydratedHandler<?>> map = this.processors;
                synchronized (map) {
                    this.processors.put(instantiatable.getName(), new DehydratedHandler(instantiatable, items));
                    logger.info("Created HTTP processor " + instantiatable.getName() + " now have " + this.processors.size());
                }
            } else if (instantiatable.willBeA(WSProcessor.class, items)) {
                Map<String, DehydratedHandler<?>> map = this.processors;
                synchronized (map) {
                    this.processors.put(instantiatable.getName(), new DehydratedHandler(instantiatable, items));
                    logger.info("Created WS processor " + instantiatable.getName() + " now have " + this.processors.size());
                }
            } else {
                instantiatable.instantiateSingleton(items);
                logger.info("Handling " + instantiatable.getName() + " with instance " + instantiatable.getInstance());
                if (instantiatable.getInstance() instanceof ZinikiTDAServer) {
                    ZinikiTDAServer inst = (ZinikiTDAServer)instantiatable.getInstance();
                    logger.info("Creating TDA server " + inst);
                    this.servers.add(inst);
                } else if (instantiatable.getInstance() instanceof ZinikiServerMappings) {
                    ZinikiServerMappings inst = (ZinikiServerMappings)instantiatable.getInstance();
                    logger.info("Creating mappings object " + inst);
                    this.mappingList.put(instantiatable.getName(), inst);
                }
            }
            return false;
        }
        catch (ConfigCascadeException cce) {
            this.cascade(cce);
            logger.debug("Error creating " + instantiatable.getName(), (Throwable)cce);
            return false;
        }
        catch (Throwable ex) {
            this.error("Could not create " + instantiatable.getName() + ": " + ex.toString());
            logger.error("Error creating " + instantiatable.getName(), ex);
            return true;
        }
    }

    public void getMappings(String key, PathTree<RequestProcessor> http, PathTree<WSProcessor> ws) throws JSONException {
        ZinikiServerMappings mappings = this.mappingList.get(key);
        if (mappings == null) {
            throw new UtilException("There is no mapping definition for " + key);
        }
        mappings.processMappings(this.errors, this.processors, http, ws);
    }

    public Object getItem(String v) {
        return this.items.get(v);
    }

    public <T> Set<T> getItemsOfClass(Class<T> clz) {
        HashSet<T> ret = new HashSet<T>();
        for (Object x : this.items.values()) {
            if (!(x instanceof Instantiatable)) continue;
            Instantiatable ix = (Instantiatable)x;
            logger.info("Have " + ix.getName() + " " + ix.hasInstance() + ": " + clz.isInstance(x));
            if (!ix.hasInstance()) continue;
            Object inst = ix.getInstance();
            logger.info("  => " + inst.getClass() + ": " + clz.isInstance(inst));
            if (!clz.isInstance(inst)) continue;
            ret.add(clz.cast(inst));
        }
        return ret;
    }

    public Instantiatable get(String name) {
        Set set = this.graph.findAll(n -> n.getName().equals(name));
        if (set.size() != 1) {
            throw new InvalidUsageException("There was no instantiable called " + name);
        }
        return (Instantiatable)((Node)CollectionUtils.any((Iterable)set)).getEntry();
    }

    public class ConfigSource {
        public final String filename;
        public final String stringSource;
        public final File fileSource;

        public ConfigSource(String string) {
            this.filename = "<argument>";
            this.stringSource = string;
            this.fileSource = null;
        }

        public ConfigSource(File source, String name) {
            this.filename = name;
            this.stringSource = null;
            this.fileSource = source;
        }

        public void parse() throws Exception {
            if (this.stringSource != null) {
                ConfigurationOptions.this.readConfig(this.stringSource, this.filename);
            } else {
                ConfigurationOptions.this.readConfig(FileUtils.readFile((File)this.fileSource), this.filename);
            }
        }
    }
}

