/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.net.URI;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.openid.JVMSecurityToken;
import org.ziniki.server.main.aws.AWSResponder;
import org.ziniki.server.main.aws.AWSWSConn;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.WSReceiver;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.ProvideHeaders;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Beachhead;
import org.ziniki.ziwsh.intf.EntryId;
import org.ziniki.ziwsh.intf.EvalContext;
import org.ziniki.ziwsh.intf.JsonSender;
import org.ziniki.ziwsh.intf.Param;
import org.ziniki.ziwsh.intf.WSResponder;
import org.ziniki.ziwsh.intf.WebSocketFinder;
import org.ziniki.ziwsh.intf.ZiwshBroker;
import org.ziniki.ziwsh.intf.ZiwshListenerDelegate;
import org.ziniki.ziwsh.jvm.JsonBeachhead;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.UtilException;

public class ZiwshAWSListener
implements WSReceiver,
ProvideHostInfo,
RequestPathParameters,
RequestQueryAndPostParameters,
WebSocketFinder,
RelationHandler,
ProvideHeaders {
    private static final Logger logger = LoggerFactory.getLogger((String)"ZiwshAWSListener");
    private final ZiwshListenerDelegate delegate;
    private String token;
    private String secret;
    private final TxManager txmanager;
    private final ZiwshBroker zb;
    private final ClassLoader loader = ZiwshAWSListener.class.getClassLoader();
    private String host;

    public ZiwshAWSListener(@Param(value="txmanager") TxManager txmanager, @Param(value="delegate") ZiwshListenerDelegate delegate, @Param(value="broker") ZiwshBroker zb) {
        this.txmanager = txmanager;
        this.delegate = delegate;
        this.zb = zb;
        logger.info("Created a new ZiWSH AWS Listener");
    }

    public void provideHost(String name, int port) {
        this.host = name.replace("wsapi.", "ziniki.");
        logger.info("ZAWSL has host " + name + " and " + port + " => " + this.host);
    }

    public void header(String name, String value) {
        logger.info("have received header " + name + " with " + value);
        if ("X-ZINIKI-TOKEN".equalsIgnoreCase(name)) {
            this.token = value;
        } else if ("X-ZINIKI-SECRET".equalsIgnoreCase(name)) {
            this.secret = value;
        }
    }

    public void remember(EvalContext cx, String token, EntryId tok, String secret, WSResponder responder) {
        JVMSecurityToken st = (JVMSecurityToken)tok;
        st.set("connectionId", (Object)responder.connectionName().toString());
        GLUnitOfWork uow = (GLUnitOfWork)cx;
        AWSWSConn conn = new AWSWSConn((FLEvalContext)uow, responder.connectionName());
        conn.set("token", this.token);
        conn.set("secret", this.secret);
        Relation r = uow.relation(null);
        r.create(conn.id(), (Object)conn);
        r.update(st.id(), (Object)st);
        uow.makeReady(r);
    }

    public WebSocketFinder.Entry find(String connId, EntryId tok) {
        JVMSecurityToken st = (JVMSecurityToken)tok;
        logger.info("Have security token with connectionId = " + st.get("connectionId"));
        if (tok == null) {
            return new AWSConnectionEntry(connId);
        }
        return new AWSConnectionEntry((String)st.get("connectionId"));
    }

    public void stringValue(String name, String value, ParameterSource source) {
        logger.info("ZAWSL setting " + name + " to " + value);
        if ("token".equals(name)) {
            this.token = value;
        } else if ("secret".equals(name)) {
            this.secret = value;
        }
    }

    public void open(WSResponder responder) {
        logger.info("Received open request with " + responder + " and " + this.token + "/" + this.secret);
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.newUnit();
        uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
        this.delegate.open((WebSocketFinder)this, (EvalContext)uow, this.host, this.token, this.secret, responder);
        uow.enact();
        uow.waitForResult();
    }

    public void onText(WSResponder responder, String text) {
        logger.info("AWS received WS.onText:" + text);
        try {
            GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.newUnit();
            uow.trait(UOWHost.class, (Object)new UOWHost(this.host));
            AWSWSConn conn = new AWSWSConn((FLEvalContext)uow, responder.connectionName());
            Relation r = uow.relation((RelationHandler)this);
            r.load("responder", (Object)responder);
            r.load("message", (Object)text);
            r.logic("handleText");
            r.get("conn", conn.id());
            uow.enact();
            uow.waitForResult();
        }
        catch (GLSException ex) {
            logger.error("Error processing GLS", (Throwable)ex);
        }
    }

    public void handleText(UnitOfWork uow, Relation r, @Slot(value="responder") WSResponder responder, @Slot(value="conn") AWSWSConn conn, @Slot(value="message") String text) {
        if (conn == null || !conn.isInitialized()) {
            logger.error("Did not find an initialized connection record for " + responder.connectionName());
            return;
        }
        try {
            logger.info("Received text " + text + " from " + conn.id() + " for token " + conn.getToken());
            this.delegate.handle((WebSocketFinder)this, (EvalContext)uow, this.host, conn.getToken(), responder, text);
        }
        catch (Exception ex) {
            logger.error("Error handling text", (Throwable)ex);
        }
    }

    public void addConnectionIdToToken(Relation r, @Slot(value="security") JVMSecurityToken token, @Slot(value="responder") WSResponder responder, @Slot(value="conn") AWSWSConn conn) {
        try {
            token.set("connectionId", (Object)responder.connectionName().toString());
            r.update(token.id(), (Object)token);
        }
        catch (Exception ex) {
            logger.error("Error handling text", (Throwable)ex);
        }
    }

    public void error() {
    }

    public void close(Object responder) {
        logger.info("close(" + responder + ")");
    }

    public void hasSegment(String segment) {
    }

    public void integerValue(String name, int value, ParameterSource source) {
    }

    public void doubleValue(String name, double value, ParameterSource source) {
    }

    public class AWSConnectionEntry
    implements WebSocketFinder.Entry {
        private final URI uri;

        public AWSConnectionEntry(String connectionId) {
            this.uri = URI.create(connectionId);
            if (!this.uri.getScheme().equals("wsconn") || this.uri.getPath().split("/").length != 4) {
                throw new UtilException("invalid connectionId, should be wsconn://host/connId/domain/stage");
            }
        }

        public Beachhead beachhead() {
            throw new NotImplementedException();
        }

        public WSResponder responder() {
            throw new NotImplementedException();
        }

        public void dispatch(EvalContext cx, String text) {
            AWSResponder responder = new AWSResponder(this.uri);
            JsonBeachhead srvBeach = new JsonBeachhead((WebSocketFinder)ZiwshAWSListener.this, ZiwshAWSListener.this.zb.creator(), "srv", (JsonSender)responder, ZiwshAWSListener.this.zb, null, ZiwshAWSListener.this.loader);
            srvBeach.dispatch(cx, text, (WSResponder)responder);
        }
    }
}

