/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.main.config.S3Reader;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.S3Object;

public class CopyReader
implements S3Reader {
    private final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private final S3AsyncClient s3;
    private final String bucket;
    private final File cacheConfigs;
    private final TreeMap<String, S3Object> s3info;
    private final List<CompletableFuture<GetObjectResponse>> all = new ArrayList<CompletableFuture<GetObjectResponse>>();

    public CopyReader(S3AsyncClient s3, String bucket, File cacheConfigs) throws InterruptedException, ExecutionException {
        this.s3 = s3;
        this.bucket = bucket;
        this.cacheConfigs = cacheConfigs;
        this.s3info = new TreeMap();
        ListObjectsResponse lor = (ListObjectsResponse)s3.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(bucket).build()).get();
        for (S3Object f : lor.contents()) {
            this.s3info.put(f.key(), f);
        }
    }

    @Override
    public String read(String key) throws IOException {
        File ret = this.resolve(key);
        if (ret == null) {
            return "";
        }
        this.andWait();
        return FileUtils.readFile((File)ret);
    }

    public File resolve(String key) {
        boolean docopy;
        S3Object info = this.s3info.get(key);
        if (info == null) {
            return null;
        }
        File cto = new File(this.cacheConfigs, key);
        if (cto.exists()) {
            if (info.lastModified().toEpochMilli() > cto.lastModified()) {
                cto.delete();
                docopy = true;
            } else {
                docopy = false;
            }
        } else {
            docopy = true;
        }
        if (docopy) {
            try {
                this.logger.info("Copying " + this.bucket + ":" + key + " to " + cto);
                this.all.add(this.s3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(this.bucket).key(key).build(), Path.of(cto.toURI())));
                return cto;
            }
            catch (NoSuchKeyException ex) {
                this.logger.error("cannot read " + key);
                return null;
            }
        }
        this.logger.info("Reading " + cto);
        return cto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void andWait() {
        try {
            List<CompletableFuture<GetObjectResponse>> list = this.all;
            synchronized (list) {
                CompletableFuture.allOf(this.all.toArray(new CompletableFuture[this.all.size()])).get(5L, TimeUnit.SECONDS);
                this.all.clear();
            }
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }
}

