/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.crac.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.main.aws.AWSLambdaProxyRequest;
import org.ziniki.server.main.aws.AWSLambdaProxyResponse;
import org.ziniki.server.main.aws.AWSTDAServer;
import org.ziniki.server.main.aws.Environment;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AWSTestableHandler
implements RequestHandler<AWSLambdaProxyRequest, AWSLambdaProxyResponse> {
    private static Logger logger;
    private final AwsCredentialsProvider creds;
    private AWSTDAServer server;

    public AWSTestableHandler(AwsCredentialsProvider creds, Environment env, File cacheConfigs) {
        this.creds = creds;
        this.server = new AWSTDAServer(creds, env, cacheConfigs);
        logger = LoggerFactory.getLogger((String)"tdaserver");
        FileUtils.assertDirectory((File)cacheConfigs);
    }

    public void initialize(String bucket, File solibs, File javafx) {
        List errs = Collections.synchronizedList(new ArrayList());
        Thread t1 = new Thread(() -> {
            try {
                this.start();
            }
            catch (Throwable t) {
                errs.add(t);
            }
        });
        t1.start();
        Thread t2 = new Thread(() -> {
            try {
                this.installSOs(bucket, solibs, javafx);
            }
            catch (Throwable t) {
                errs.add(t);
            }
        });
        t2.start();
        try {
            t1.join();
            t2.join();
            if (!errs.isEmpty()) {
                throw (Throwable)errs.get(0);
            }
        }
        catch (Throwable t) {
            throw WrappedException.wrap((Throwable)t);
        }
    }

    public void start() {
        this.server.begin();
        if (this.server.initializationException() != null) {
            throw WrappedException.wrap((Throwable)this.server.initializationException());
        }
    }

    public int installSOs(String bucket, File todir, File jfxdir) throws InterruptedException, ExecutionException, TimeoutException {
        FileUtils.assertDirectory((File)todir);
        FileUtils.assertDirectory((File)jfxdir);
        Logger logger = LoggerFactory.getLogger((String)"AWSHandler");
        S3AsyncClient s3 = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(this.creds)).region(Region.US_EAST_1)).build();
        int cnt = 0;
        if (todir.isDirectory()) {
            ListObjectsResponse lor = (ListObjectsResponse)s3.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(bucket).build()).get();
            logger.info("copying " + lor.contents().size() + " items from " + bucket + " to " + todir);
            ArrayList<CompletableFuture> all = new ArrayList<CompletableFuture>();
            for (S3Object f : lor.contents()) {
                boolean docopy;
                if (!f.key().endsWith(".so") && !f.key().endsWith(".jar")) continue;
                logger.info("s3 has " + f.key() + " which was updated at " + f.lastModified().toEpochMilli());
                File cto = f.key().endsWith(".so") ? new File(todir, f.key()) : new File(jfxdir, f.key());
                if (!cto.exists()) {
                    docopy = true;
                } else {
                    logger.info("already have " + cto + " updated at " + cto.lastModified());
                    if (f.lastModified().toEpochMilli() > cto.lastModified()) {
                        docopy = true;
                        logger.info("replacing because s3 version is newer");
                    } else {
                        docopy = false;
                    }
                }
                if (!docopy) continue;
                logger.info("copying file " + f.key() + " to " + cto);
                cto.delete();
                CompletableFuture copy = s3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucket).key(f.key()).build(), Path.of(cto.toURI()));
                copy.thenAccept(r -> logger.info("done copying " + cto));
                all.add(copy);
                ++cnt;
            }
            CompletableFuture.allOf(all.toArray(new CompletableFuture[all.size()])).get(60L, TimeUnit.SECONDS);
            logger.info("copied " + cnt + " files to " + todir);
        } else {
            logger.error("there is no directory " + todir + " to copy from " + bucket);
        }
        return cnt;
    }

    public AWSLambdaProxyResponse handleRequest(AWSLambdaProxyRequest request, Context cx) {
        try {
            if (this.server.initializationException() != null) {
                logger.error("Error initializing server", this.server.initializationException());
                return AWSLambdaProxyResponse.internalError(this.server.initializationException());
            }
            this.server.lambdaId(cx.getAwsRequestId());
            AWSLambdaProxyResponse ret = new AWSLambdaProxyResponse();
            request.processTo(this.server, ret);
            logger.info("waiting for completion");
            ret.waitForCompletion();
            logger.info("Response: status = " + ret.getStatusCode() + " " + ret.responseLength());
            if (logger.isDebugEnabled()) {
                logger.debug("Response text is " + ret.getBody());
            }
            return ret;
        }
        catch (Throwable t) {
            logger.error("Error processing request", t);
            return AWSLambdaProxyResponse.internalError(t);
        }
    }

    public Throwable initializationException() {
        return this.server.initializationException();
    }

    public boolean failed() {
        return this.server.initializationException() != null;
    }

    public void close() {
        this.server.destroy();
    }

    public void beforeCheckpoint(org.crac.Context<? extends Resource> arg0) {
        logger.info("before checkpoint");
    }

    public void afterRestore(org.crac.Context<? extends Resource> arg0) {
        logger.info("after restore");
    }
}

