/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.codehaus.jettison.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.awstxstore.AWSTxManager;
import org.ziniki.coreimpl.ZinikiServer;
import org.ziniki.server.main.ZinikiStreams;
import org.ziniki.server.main.aws.AWSLiveEnvironment;
import org.ziniki.server.main.aws.CopyReader;
import org.ziniki.server.main.aws.Environment;
import org.ziniki.server.main.aws.TDAServerIntf;
import org.ziniki.server.main.config.ConfigurationOptions;
import org.ziniki.server.path.NoHandlerException;
import org.ziniki.server.path.PathTree;
import org.ziniki.server.path.SimplePathTree;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.TDAConfiguration;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.zinutils.streamedlogger.StreamedLoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3AsyncClientBuilder;

public class AWSTDAServer
implements TDAConfiguration,
TDAServerIntf {
    private static ZinikiStreams streamer;
    protected final Logger logger;
    private final Environment env;
    private final AwsCredentialsProvider creds;
    private Throwable captureEx;
    private PathTree<RequestProcessor> httpMappingTree;
    private PathTree<WSProcessor> webSocketMappingTree;
    private S3AsyncClient s3;
    private String bucket;
    private Set<AWSTxManager> mgrs;
    private File cacheConfigs;

    public static void main(String[] args) throws Throwable {
        AWSTDAServer.startLogging();
        ProfileCredentialsProvider provider = ProfileCredentialsProvider.builder().profileName(System.getenv("AWS_PROFILE")).build();
        AWSTDAServer server = new AWSTDAServer((AwsCredentialsProvider)provider, new AWSLiveEnvironment(), new File("/tmp/configs"));
        if (server.captureEx != null) {
            throw server.captureEx;
        }
    }

    public AWSTDAServer(AwsCredentialsProvider creds, Environment env, File cacheConfigs) {
        this.creds = creds;
        this.env = env;
        this.cacheConfigs = cacheConfigs;
        AWSTDAServer.startLogging();
        this.logger = LoggerFactory.getLogger((String)"tdaserver");
    }

    public void begin() {
        this.logger.info("In config");
        try {
            this.bucket = this.env.getenv("CONFIG_BUCKET");
            if (this.bucket == null) {
                throw new RuntimeException("Must specify CONFIG_BUCKET");
            }
            String args = this.env.getenv("CONFIG_ARGS_KEY");
            if (args == null) {
                throw new RuntimeException("Must specify CONFIG_ARGS_KEY");
            }
            String stage = this.env.getenv("CONFIG_STAGE");
            if (stage == null) {
                throw new RuntimeException("Must specify CONFIG_STAGE");
            }
            String useMappings = this.env.getenv("CONFIG_USE_MAPPINGS");
            if (useMappings == null) {
                throw new RuntimeException("Must specify CONFIG_USE_MAPPINGS");
            }
            this.logger.info("Bucket = " + this.bucket + " key = " + args + " stage = " + stage + " mappings = " + useMappings);
            this.s3 = (S3AsyncClient)((S3AsyncClientBuilder)((S3AsyncClientBuilder)S3AsyncClient.builder().credentialsProvider(this.creds)).region(Region.US_EAST_1)).build();
            CopyReader r = new CopyReader(this.s3, this.bucket, this.cacheConfigs);
            String str = r.read(args);
            JSONArray ja = new JSONArray(str);
            String[] arr = new String[ja.length() + 4];
            arr[0] = "--s3Config";
            arr[1] = stage + ".json";
            arr[2] = "--s3Config";
            arr[3] = "aws-" + stage + ".json";
            for (int i = 0; i < ja.length(); ++i) {
                arr[i + 4] = ja.getString(i);
            }
            this.httpMappingTree = new SimplePathTree();
            this.webSocketMappingTree = new SimplePathTree();
            ConfigurationOptions config = new ConfigurationOptions(r, arr);
            config.bind("streamer", streamer);
            config.bind("appLoader", this.getClass().getClassLoader());
            config.doConfiguration();
            String[] mappings = useMappings.split(":");
            for (int i = 0; i < mappings.length; ++i) {
                config.getMappings(mappings[i], this.httpMappingTree, this.webSocketMappingTree);
            }
            this.mgrs = config.getItemsOfClass(AWSTxManager.class);
            this.logger.info("bound txmgr to " + this.mgrs);
        }
        catch (Throwable t) {
            this.captureEx = t;
        }
    }

    public static void startLogging() {
        streamer = new ZinikiStreams();
        Properties sys = System.getProperties();
        Properties props = new Properties();
        props.putAll((Map<?, ?>)sys);
        if (!props.containsKey("streamlogger.levelOf.DI")) {
            props.setProperty("streamlogger.levelOf.DI", "WARN");
        }
        if (!props.containsKey("streamlogger.defaultLevel")) {
            props.setProperty("streamlogger.defaultLevel", "INFO");
        }
        if (!StreamedLoggerFactory.isInit()) {
            StreamedLoggerFactory.init((Properties)props, (Callable)streamer);
        }
    }

    public Throwable initializationException() {
        return this.captureEx;
    }

    @Override
    public RequestProcessor makeHTTPHandler(String path) throws Exception {
        return (RequestProcessor)this.httpMappingTree.makeHandler((TDAConfiguration)this, path);
    }

    @Override
    public void populateParameters(RequestProcessor instance, String path) {
        this.httpMappingTree.populate((RequestPathParameters)instance, path);
    }

    public WSProcessor makeWSHandler() throws Exception {
        try {
            return (WSProcessor)this.webSocketMappingTree.makeUniqueHandler((TDAConfiguration)this);
        }
        catch (NoHandlerException ex) {
            this.logger.error("could not create the unique handler for / in makeWSHandler");
            throw ex;
        }
    }

    public void lambdaId(String awsRequestId) {
        if (this.mgrs != null) {
            for (AWSTxManager mgr : this.mgrs) {
                mgr.lambdaId(awsRequestId);
            }
        }
    }

    public void destroy() {
        ZinikiServer.destroy();
    }
}

