/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.ziwsh.intf.WSResponder;
import org.zinutils.exceptions.WrappedException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiClient;
import software.amazon.awssdk.services.apigatewaymanagementapi.ApiGatewayManagementApiClientBuilder;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.DeleteConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.GoneException;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionRequest;
import software.amazon.awssdk.services.apigatewaymanagementapi.model.PostToConnectionResponse;

public class AWSResponder
implements WSResponder {
    private static final Logger logger = LoggerFactory.getLogger((String)"AWSResponder");
    private final String host;
    private final String connectionId;
    private final String domainName;
    private final String stage;
    private String dessication;

    public AWSResponder(String server, Map<String, Object> context) {
        this.host = server;
        this.connectionId = (String)context.get("connectionId");
        this.domainName = (String)context.get("domainName");
        this.stage = (String)context.get("stage");
        logger.info("host = " + this.host + "; connectionId = " + this.connectionId + " / " + this.domainName + " / " + this.stage);
    }

    public AWSResponder(URI uri) {
        String path = uri.getPath();
        String[] parts = path.split("/");
        if (parts.length != 4 || parts[0].length() != 0) {
            throw new RuntimeException(path + " was not correctly formatted");
        }
        this.host = uri.getHost();
        this.connectionId = parts[1];
        this.domainName = parts[2];
        this.stage = parts[3];
    }

    public void setDessication(String token) {
        logger.info("Setting dessication of " + this + " to be " + token);
        this.dessication = token;
    }

    public String dessicated() {
        return this.dessication;
    }

    public void send(String json) {
        logger.info("Want to respond to " + this.connectionName() + " with " + json);
        this.sendMessageTo(json);
    }

    private boolean sendMessageTo(String text) {
        try {
            URI endpoint = URI.create("https://" + this.domainName);
            logger.info("Trying to send to endpoint " + endpoint + " for connectionId " + this.connectionId);
            ApiGatewayManagementApiClient wsapi = (ApiGatewayManagementApiClient)((ApiGatewayManagementApiClientBuilder)ApiGatewayManagementApiClient.builder().endpointOverride(endpoint)).build();
            PostToConnectionRequest msg = (PostToConnectionRequest)PostToConnectionRequest.builder().connectionId(this.connectionId).data(SdkBytes.fromString((String)text, (Charset)Charset.forName("UTF-8"))).build();
            PostToConnectionResponse response = wsapi.postToConnection(msg);
            logger.info("sent message to " + this.connectionId + " with result " + response);
            return true;
        }
        catch (GoneException ex) {
            logger.error("gone when sending message to " + this.connectionId);
            return false;
        }
        catch (Throwable t) {
            logger.error("error sending message", t);
            return true;
        }
    }

    public URI connectionName() {
        try {
            return new URI("wsconn", null, this.domainName, -1, "/" + this.connectionId + "/" + this.domainName + "/" + this.stage, null, null);
        }
        catch (URISyntaxException e) {
            throw WrappedException.wrap((Throwable)e);
        }
    }

    public void close(String reason) {
        URI endpoint = URI.create("https://" + this.domainName);
        logger.info("Trying to close " + endpoint + " for connectionId " + this.connectionId);
        ApiGatewayManagementApiClient wsapi = (ApiGatewayManagementApiClient)((ApiGatewayManagementApiClientBuilder)ApiGatewayManagementApiClient.builder().endpointOverride(endpoint)).build();
        DeleteConnectionRequest msg = (DeleteConnectionRequest)DeleteConnectionRequest.builder().connectionId(this.connectionId).build();
        wsapi.deleteConnection(msg);
    }
}

