/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.grizzly.NettyCookieSetter;
import org.ziniki.servlet.tda.CookieSetter;
import org.ziniki.servlet.tda.NotReadyException;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;

public class AWSLambdaProxyResponse
implements Responder {
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private int status = 200;
    private StringWriter sw = new StringWriter();
    private Throwable showErr;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>();
    private final Map<String, CookieSetter> cookies = new TreeMap<String, CookieSetter>();
    private int waitFor;
    private TimeUnit waitForUnit;
    private CompletableFuture<Void> completeMe;
    private ByteArrayOutputStream baos = null;

    public int getStatusCode() {
        if (this.showErr != null) {
            return 500;
        }
        return this.status;
    }

    public int status() {
        return this.getStatusCode();
    }

    public Map<String, List<String>> getMultiValueHeaders() {
        TreeMap<String, List<String>> ret = new TreeMap<String, List<String>>(this.headers);
        if (!this.cookies.isEmpty()) {
            ArrayList<String> cookieHeaders = new ArrayList<String>();
            for (CookieSetter gcs : this.cookies.values()) {
                cookieHeaders.add(gcs.toString());
            }
            ret.put("Set-Cookie", cookieHeaders);
        }
        return ret;
    }

    public String getBody() {
        if (this.showErr != null) {
            this.sw = new StringWriter();
            PrintWriter pw = new PrintWriter(this.sw);
            this.showErr.printStackTrace(pw);
            pw.flush();
            return this.sw.toString();
        }
        if (this.baos != null) {
            return Base64.getEncoder().encodeToString(this.baos.toByteArray());
        }
        return this.sw.toString();
    }

    public Boolean isBase64Encoded() {
        return this.baos != null;
    }

    public Boolean getIsBase64Encoded() {
        return this.baos != null;
    }

    public static AWSLambdaProxyResponse internalError(Throwable t) {
        AWSLambdaProxyResponse err = new AWSLambdaProxyResponse();
        err.handleError(t);
        return err;
    }

    public void setTimeout(int time, TimeUnit unit) {
        this.setTimeout(null, time, unit);
    }

    public void setTimeout(String message, int time, TimeUnit unit) {
        this.waitFor = time;
        this.waitForUnit = unit;
        this.completeMe = new CompletableFuture();
    }

    public void setStatus(int stat) {
        this.status = stat;
    }

    public void setHeader(String name, String value) {
        if (!this.headers.containsKey(name)) {
            this.headers.put(name, new ArrayList());
        }
        this.headers.get(name).add(value);
    }

    public CookieSetter setCookie(String name, String value) {
        DefaultCookie c = new DefaultCookie(name, value);
        logger.info("Setting cookie " + c.toString());
        NettyCookieSetter cookieSetter = new NettyCookieSetter((Cookie)c);
        this.cookies.put(name, (CookieSetter)cookieSetter);
        return cookieSetter;
    }

    public void clearCookie(String named) {
        DefaultCookie c = new DefaultCookie(named, "");
        c.setMaxAge(0L);
        c.setPath("/");
        logger.info("Setting cookie " + c.toString());
        NettyCookieSetter cookieSetter = new NettyCookieSetter((Cookie)c);
        this.cookies.put(named, (CookieSetter)cookieSetter);
    }

    public void setContentType(String contentType) {
        this.headers.put("Content-Type", Arrays.asList(contentType));
    }

    public void setContentLength(long length) {
        this.headers.put("Content-Length", Arrays.asList(Long.toString(length)));
    }

    public void redirectTo(String location) throws IOException {
        this.status = 302;
        this.headers.put("Location", Arrays.asList(location));
        this.setContentType("text/html");
        this.sw.write("<html><head><title>Document Moved</title></head><body>The document has moved to <a href='" + StringEscapeUtils.escapeHtml4((String)location) + "'></body></html>");
        this.done();
    }

    public boolean canWrite() {
        return true;
    }

    public boolean write(String string, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        this.sw.append(string);
        return true;
    }

    public boolean write(char[] cbuf, int offset, int cnt, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        this.sw.write(cbuf, offset, cnt);
        return true;
    }

    public boolean write(byte[] buf, int offset, int cnt, ResponseReadyContinuation rr) throws IOException, NotReadyException {
        if (this.baos == null) {
            this.baos = new ByteArrayOutputStream();
            this.baos.write(this.sw.toString().getBytes(Charset.forName("UTF-8")));
        }
        this.baos.write(buf, offset, cnt);
        return true;
    }

    public void done() {
        if (this.completeMe != null) {
            logger.info("completing " + this.completeMe + " where waitFor = " + this.waitFor);
            this.completeMe.complete(null);
        }
    }

    public void handleError(Throwable err) {
        this.showErr = err;
    }

    public void waitForCompletion() throws Exception {
        logger.info("completeMe = " + this.completeMe + " and waitFor = " + this.waitFor);
        if (this.completeMe != null) {
            this.completeMe.get(this.waitFor, this.waitForUnit);
        }
    }

    public long responseLength() {
        if (this.baos != null) {
            return this.baos.size();
        }
        return this.sw.toString().length();
    }
}

