/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main.aws;

import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.main.aws.AWSLambdaProxyResponse;
import org.ziniki.server.main.aws.AWSResponder;
import org.ziniki.server.main.aws.AWSTDAServer;
import org.ziniki.server.main.aws.TDAServerIntf;
import org.ziniki.server.tda.ProvideHostInfo;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.BodyChunkHandler;
import org.ziniki.servlet.tda.BodyFlowControl;
import org.ziniki.servlet.tda.CookieAware;
import org.ziniki.servlet.tda.NeedBaseURI;
import org.ziniki.servlet.tda.NeedFullURLWithQuery;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.ProvideHeaders;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.RequestQueryAndPostParameters;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.servlet.tda.ResponseReadyContinuation;
import org.ziniki.ziwsh.intf.WSProcessor;
import org.ziniki.ziwsh.intf.WSResponder;

public class AWSLambdaProxyRequest {
    private static final Logger logger = LoggerFactory.getLogger((String)"tdaserver");
    private String method;
    private String path;
    private String body;
    private Map<String, List<String>> queryParameters = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, Object> context = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
    private String contentType;
    private String serverAddr;
    private String hostHdr;
    private String hostCxt;
    private String hostStage;
    private String host;

    public void setHttpMethod(String method) {
        this.method = method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setMultiValueHeaders(Map<String, List<String>> headers) {
        if (headers != null) {
            this.headers.putAll(headers);
        }
        for (Map.Entry<String, List<String>> e : this.headers.entrySet()) {
            logger.debug(e.getKey() + " => " + e.getValue());
        }
        if (this.headers.containsKey("content-type")) {
            this.contentType = this.headers.get("content-type").get(0).trim();
            int idx = this.contentType.indexOf(";");
            if (idx != -1) {
                String s = this.contentType.substring(idx + 1).trim();
                this.contentType = this.contentType.substring(0, idx);
                if (s.startsWith("charset=")) {
                    // empty if block
                }
            }
        }
        if (this.headers.containsKey("host")) {
            this.hostHdr = this.headers.get("host").get(0);
            logger.debug("headers have set host to " + this.hostHdr);
        }
    }

    public void setMultiValueQueryStringParameters(Map<String, List<String>> params) {
        if (params != null) {
            this.queryParameters.putAll(params);
            logger.debug("query params = " + params);
        }
    }

    public void setStageVariables(Map<String, Object> sv) {
        logger.debug("stage variables set to " + sv);
        if (sv != null) {
            this.hostStage = (String)sv.get("ziniki");
            logger.debug("stage variable has overridden host to " + this.hostStage);
        }
    }

    public void setRequestContext(Map<String, Object> context) {
        if (context != null) {
            this.context.putAll(context);
            logger.debug("request context has keys " + context.keySet());
            this.hostCxt = (String)context.get("domainName");
            logger.debug("domainName has set host to " + this.hostCxt);
        }
    }

    private void finishParameterConfiguration() {
        this.host = this.hostStage != null ? this.hostStage : (this.hostCxt != null ? this.hostCxt : this.hostHdr);
        this.serverAddr = "https://" + this.host;
    }

    public void processTo(AWSTDAServer server, AWSLambdaProxyResponse responder) throws Exception {
        this.finishParameterConfiguration();
        if (this.context.containsKey("httpMethod")) {
            this.processHttp(server, responder);
        } else if (this.context.containsKey("routeKey")) {
            this.processWS(server);
        } else {
            responder.setStatus(400);
            ResponseReadyContinuation rr = null;
            responder.write("no httpMethod or routeKey", rr);
        }
    }

    public void processHttp(TDAServerIntf server, AWSLambdaProxyResponse responder) throws Exception {
        logger.info("HTTP handling " + this.method + " " + this.path);
        RequestProcessor instance = server.makeHTTPHandler(this.path);
        if (instance instanceof ProvideHostInfo) {
            ((ProvideHostInfo)instance).provideHost(this.host, 443);
        }
        if (instance instanceof RequestMethod) {
            ((RequestMethod)instance).requestMethod(this.method);
        }
        if (instance instanceof NeedFullURLWithQuery) {
            String q = "?";
            Iterator<Map.Entry<String, List<String>>> queryParameterString = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : this.queryParameters.entrySet()) {
                for (String v : entry.getValue()) {
                    ((StringBuilder)((Object)queryParameterString)).append(q);
                    q = "&";
                    ((StringBuilder)((Object)queryParameterString)).append(entry.getKey());
                    ((StringBuilder)((Object)queryParameterString)).append("=");
                    ((StringBuilder)((Object)queryParameterString)).append(URLEncoder.encode(v, "UTF-8"));
                }
            }
            String string = this.serverAddr + this.path + (StringBuilder)((Object)queryParameterString);
            logger.debug("Passing full URL: " + string);
            ((NeedFullURLWithQuery)instance).fullURLWithQuery(string);
        }
        if (instance instanceof NeedBaseURI) {
            String baseUri = this.serverAddr;
            ((NeedBaseURI)instance).baseUri(baseUri);
        }
        if (instance instanceof ProvideHeaders) {
            ProvideHeaders h = (ProvideHeaders)instance;
            for (Map.Entry entry : this.headers.entrySet()) {
                for (String s : (List)entry.getValue()) {
                    h.header((String)entry.getKey(), s);
                }
            }
        }
        if (instance instanceof RequestPathParameters) {
            server.populateParameters(instance, this.path);
        }
        if (instance instanceof RequestQueryAndPostParameters) {
            List vars;
            RequestQueryAndPostParameters qpp = (RequestQueryAndPostParameters)instance;
            logger.debug("query = " + this.queryParameters);
            for (Map.Entry<String, List<String>> entry : this.queryParameters.entrySet()) {
                for (String v : entry.getValue()) {
                    qpp.stringValue(entry.getKey(), v, ParameterSource.QUERYPOST);
                }
            }
            logger.debug("contenttype = " + this.contentType);
            logger.debug("body = " + this.body);
            if ("application/x-www-form-urlencoded".equals(this.contentType) && (vars = URLEncodedUtils.parse((String)this.body, (Charset)Charset.defaultCharset())) != null) {
                for (NameValuePair nameValuePair : vars) {
                    logger.debug("offering body parameter " + nameValuePair.getValue() + " for " + nameValuePair.getName());
                    qpp.stringValue(nameValuePair.getName(), nameValuePair.getValue(), ParameterSource.QUERYPOST);
                }
            }
        }
        logger.info("is cookie aware: " + (instance instanceof CookieAware));
        if (instance instanceof CookieAware) {
            CookieAware ca = (CookieAware)instance;
            String[] wanted = ca.cookiesWanted();
            logger.info("wants cookies " + Arrays.asList(wanted));
            if (wanted != null) {
                List<String> list = this.headers.get("Cookie");
                logger.info("have cookie headers " + Arrays.asList(list));
                if (list != null && !list.isEmpty()) {
                    for (String h : list) {
                        logger.info("considering cookie header " + h);
                        Set cookies = ServerCookieDecoder.LAX.decode(h);
                        logger.info("considering cookies " + cookies);
                        block8: for (String s : wanted) {
                            logger.info("Searching for cookie " + s);
                            for (Cookie c : cookies) {
                                if (!c.name().equals(s)) continue;
                                logger.info("Provided cookie " + s + " = " + c.value());
                                ca.cookie(s, c.value());
                                continue block8;
                            }
                        }
                    }
                }
            }
        }
        instance.process((Responder)responder);
        if (instance instanceof BodyChunkHandler) {
            BodyChunkHandler bch = (BodyChunkHandler)instance;
            byte[] bs = this.body.getBytes();
            BodyFlowControl bodyFlowControl = new BodyFlowControl(){

                public void pause() {
                }

                public void resume() throws Exception {
                }
            };
            bch.chunk(bs, 0, bs.length, bodyFlowControl);
        }
    }

    private void processWS(AWSTDAServer server) throws Exception {
        WSProcessor handler = server.makeWSHandler();
        if (handler instanceof ProvideHostInfo) {
            ((ProvideHostInfo)handler).provideHost(this.host, 443);
        }
        if (handler instanceof ProvideHeaders) {
            ProvideHeaders h = (ProvideHeaders)handler;
            for (Map.Entry<String, List<String>> he : this.headers.entrySet()) {
                for (String s : he.getValue()) {
                    h.header(he.getKey(), s);
                }
            }
        }
        if (handler instanceof RequestQueryAndPostParameters) {
            RequestQueryAndPostParameters q = (RequestQueryAndPostParameters)handler;
            for (Map.Entry<String, List<String>> e : this.queryParameters.entrySet()) {
                for (String s : e.getValue()) {
                    q.stringValue(e.getKey(), s, ParameterSource.QUERYPOST);
                }
            }
        }
        AWSResponder responder = new AWSResponder(this.host, this.context);
        if ("$connect".equals(this.context.get("routeKey"))) {
            handler.open((WSResponder)responder);
        } else if ("$default".equals(this.context.get("routeKey"))) {
            handler.onText((WSResponder)responder, this.body);
        } else if ("$disconnect".equals(this.context.get("routeKey"))) {
            handler.close((Object)responder);
        }
    }
}

