/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.server.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;
import org.ziniki.server.main.ThrowingRunnable;
import org.ziniki.server.main.ZinikiStreams;
import org.ziniki.server.main.config.ConfigurationOptions;
import org.ziniki.server.main.config.ZinikiTDAServer;
import org.ziniki.server.main.grizzly.ZinikiGrizzlyServer;
import org.ziniki.tdastore.support.ThreadAwareTxManager;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.streamedlogger.StreamedLoggerFactory;
import org.zinutils.streamedlogger.api.LabelBinder;
import org.zinutils.streamedlogger.impl.ConsoleStreamedLoggerConfig;

public class ZinikiMain {
    protected static Logger logger;
    private ConfigurationOptions opts;
    private final ZinikiStreams streamer;

    public static void main(String ... args) {
        ZinikiStreams zs = new ZinikiStreams();
        ZinikiMain.startLogging(zs);
        logger = LoggerFactory.getLogger((String)"tdaserver");
        ZinikiMain.doMain(() -> Thread.sleep(Long.MAX_VALUE), null, zs, args);
        System.exit(0);
    }

    public static void runUntil(Future<Void> f, Consumer<ZinikiMain> consumer, String ... args) {
        logger = LoggerFactory.getLogger((String)"tdaserver");
        ZinikiMain.doMain(() -> f.get(), consumer, new ZinikiStreams(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doMain(ThrowingRunnable r, Consumer<ZinikiMain> consumer, ZinikiStreams zs, String ... args) {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        Security.addProvider((Provider)new BouncyCastleProvider());
        ZinikiMain main = new ZinikiMain(zs);
        if (consumer != null) {
            consumer.accept(main);
        }
        try {
            main.configure(args);
        }
        catch (Throwable t) {
            t = WrappedException.unwrapThrowable((Throwable)t);
            if (t instanceof FileNotFoundException) {
                logger.error("Could not find file " + ((FileNotFoundException)t).getMessage());
            } else {
                logger.error("configuration error", t);
            }
            return;
        }
        try {
            main.start();
            main.opts.onceStarted();
            r.run();
        }
        catch (Throwable t) {
            t = WrappedException.unwrapThrowable((Throwable)t);
            logger.error("exception not caught", t);
        }
        finally {
            main.stop();
        }
    }

    public static void startLogging(ZinikiStreams zs) {
        Properties props = null;
        String file = System.getProperty("streamlogger.read.file");
        if (file != null) {
            try {
                FileReader fr = new FileReader(new File(file));
                props = new Properties();
                props.load(fr);
            }
            catch (Exception ex) {
                props = null;
            }
        }
        if (props == null) {
            props = System.getProperties();
            props.put("streamlogger.config", ConsoleStreamedLoggerConfig.class.getName());
            props.put("streamlogger.usestreams", "false");
        }
        StreamedLoggerFactory.init((Properties)props, (Callable)zs);
    }

    public ZinikiMain(ZinikiStreams zs) {
        this.streamer = zs;
        this.streamer.bindLabelToThread("Ziniki");
    }

    public void configure(String[] args) throws Exception {
        this.opts = new ConfigurationOptions(null, args);
        this.opts.bind("streamer", this.streamer);
        this.opts.bind("appLoader", this.getClass().getClassLoader());
        this.opts.doConfiguration();
        ((ThreadAwareTxManager)this.opts.get("zinikiTxMgr").getInstance()).labeller((LabelBinder)this.streamer);
        ((ThreadAwareTxManager)this.opts.get("authTxMgr").getInstance()).labeller((LabelBinder)this.streamer);
    }

    public ZinikiStreams streamer() {
        return this.streamer;
    }

    public void start() throws IOException {
        if (this.opts == null) {
            return;
        }
        for (ZinikiTDAServer s : this.opts.servers()) {
            ((ZinikiGrizzlyServer)s).start();
        }
    }

    public void stop() {
        if (this.opts == null) {
            return;
        }
        for (ZinikiTDAServer s : this.opts.servers()) {
            ((ZinikiGrizzlyServer)s).stop();
        }
    }
}

