/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cloudwatchreader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cloudwatchreader.CWPrintAllFrom;
import org.ziniki.cloudwatchreader.CWStream;
import org.ziniki.cloudwatchreader.CWStreamReader;
import org.ziniki.cloudwatchreader.CWZipCreator;
import org.zinutils.exceptions.CantHappenException;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogGroupsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.DescribeLogStreamsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogGroup;
import software.amazon.awssdk.services.cloudwatchlogs.model.LogStream;
import software.amazon.awssdk.services.cloudwatchlogs.model.OrderBy;
import software.amazon.awssdk.utils.StringUtils;

public class Main {
    static final Logger logger = LoggerFactory.getLogger((String)"CWReader");
    private CloudWatchLogsClient client = (CloudWatchLogsClient)CloudWatchLogsClient.builder().build();

    public static void main(String[] args) {
        Main main = new Main();
        if (args.length == 0) {
            main.showGroups();
        } else {
            switch (args[0]) {
                case "--group": {
                    main.handleGroupCases(args);
                    break;
                }
                case "--zip": {
                    main.handleZipCase(args);
                    break;
                }
                default: {
                    Main.usage();
                }
            }
        }
    }

    public void handleGroupCases(String[] args) {
        if (args.length < 2) {
            Main.usage();
            return;
        }
        String filter = args[1];
        Pattern patt = Pattern.compile(filter);
        if (args.length > 2) {
            if (!args[2].equals("--stream") || args.length < 4) {
                Main.usage();
                return;
            }
            this.showStream(patt, Integer.parseInt(args[3]), this.matchSince(args, 4));
        } else {
            this.showMatchesFor(patt);
        }
    }

    private Date matchSince(String[] args, int i) {
        if (args.length > i && args[i].equals("--last")) {
            if (args.length < i + 2) {
                Main.usage();
                throw new CantHappenException("usage");
            }
            return new Date(new Date().getTime() - (long)Integer.parseInt(args[i + 1]) * 1000L);
        }
        if (args.length > i && args[i].equals("--since")) {
            if (args.length < i + 2) {
                Main.usage();
                throw new CantHappenException("usage");
            }
            try {
                String h24 = args[i + 1];
                if (h24.length() != 4) {
                    throw new NumberFormatException();
                }
                int hr = Integer.parseInt(h24.substring(0, 2));
                int min = Integer.parseInt(h24.substring(2, 4));
                if (hr > 23 || min > 59) {
                    throw new NumberFormatException();
                }
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date());
                cal.set(11, hr);
                cal.set(12, min);
                cal.set(13, 0);
                cal.set(14, 0);
                Date ret = cal.getTime();
                if (ret.after(new Date())) {
                    return new Date(ret.getTime() - 86400000L);
                }
                return ret;
            }
            catch (NumberFormatException ex) {
                System.out.println("--since must be a 4-digit time in 24h clock");
                Main.usage();
                throw new CantHappenException("usage");
            }
        }
        Main.usage();
        throw new CantHappenException("usage");
    }

    public void showGroups() {
        List<LogGroup> grps = this.getGroups(null);
        for (LogGroup g : grps) {
            System.out.println("  " + g.logGroupName());
        }
    }

    private void showMatchesFor(Pattern patt) {
        block4: {
            List<LogGroup> grps = this.getGroups(patt);
            if (grps.isEmpty()) break block4;
            if (grps.size() > 1) {
                int idx = 0;
                for (LogGroup lg : grps) {
                    System.out.println(idx + ": " + lg.logGroupName());
                    ++idx;
                }
            } else {
                List<CWStream> streams = this.getMatchingStreams(patt, null);
                int idx = 0;
                for (CWStream ls : streams) {
                    System.out.println(idx + ": " + ls.logStreamName() + " " + ls.firstEventTimestamp() + "-" + ls.lastEventTimestamp());
                    ++idx;
                }
            }
        }
    }

    void showStream(Pattern patt, int which, Date from) {
        List<CWStream> logStreams = this.getMatchingStreams(patt, from);
        if (logStreams.isEmpty()) {
            System.out.println("Nothing matched " + patt);
            return;
        }
        if (this.hasMultipleGroups(logStreams)) {
            System.out.println("Filter matches multiple groups: " + this.groupNames(logStreams));
            return;
        }
        if (which < 0 || which > logStreams.size()) {
            System.out.println("There is no stream " + which + " for group " + patt);
            return;
        }
        int idx = 0;
        for (CWStream ls : logStreams) {
            System.out.println(idx + ": " + ls.logStreamName() + " " + ls.firstEventTimestamp() + "-" + ls.lastEventTimestamp());
            ++idx;
        }
        CWStream want = logStreams.get(which);
        logStreams.clear();
        logStreams.add(want);
        try {
            new CWStreamReader(this.client, logStreams, from).process(new CWPrintAllFrom());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Set<String> groupNames(List<CWStream> logStreams) {
        TreeSet<String> ret = new TreeSet<String>();
        for (CWStream s : logStreams) {
            ret.add(s.logGroupName());
        }
        return ret;
    }

    private boolean hasMultipleGroups(List<CWStream> logStreams) {
        return this.groupNames(logStreams).size() > 1;
    }

    private List<CWStream> getMatchingStreams(Pattern patt, Date from) {
        List<LogGroup> grps = this.getGroups(patt);
        ArrayList<CWStream> logStreams = new ArrayList<CWStream>();
        String token = null;
        block0: for (LogGroup want : grps) {
            DescribeLogStreamsResponse streams;
            do {
                DescribeLogStreamsRequest sr = (DescribeLogStreamsRequest)DescribeLogStreamsRequest.builder().logGroupName(want.logGroupName()).orderBy(OrderBy.LAST_EVENT_TIME).descending(Boolean.valueOf(true)).nextToken(token).build();
                streams = this.client.describeLogStreams(sr);
                logger.debug("Considering group " + want.logGroupName() + " with " + streams.logStreams().size() + (token == null ? " initial" : " more") + " streams");
                int cnt = 3;
                for (LogStream i : streams.logStreams()) {
                    if (from.after(new Date(i.lastEventTimestamp())) && cnt-- <= 0) continue block0;
                    logger.debug("  Adding stream " + i.logStreamName() + " from " + new Date(i.firstEventTimestamp()) + " to " + new Date(i.lastEventTimestamp()));
                    logStreams.add(0, new CWStream(want, i));
                }
            } while ((token = streams.nextToken()) != null);
        }
        return logStreams;
    }

    private void handleZipCase(String[] args) {
        Date from;
        if (args.length < 4) {
            Main.usage();
            return;
        }
        File outTo = new File(args[1]);
        Date now = new Date();
        Date since = new Date(now.getTime() - 86400000L);
        if (!"--env".equals(args[2])) {
            Main.usage();
            return;
        }
        String env = args[3];
        if (args.length > 4 && (from = this.matchSince(args, 4)) != null) {
            since = from;
        }
        this.doSince(outTo, since, env);
    }

    private void doSince(File outTo, Date from, String env) {
        System.out.println("Events after " + from);
        List<CWStream> streams = this.getLogGroups(from, env);
        try (FileOutputStream fos = new FileOutputStream(outTo);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            new CWStreamReader(this.client, streams, from).process(new CWZipCreator(zos, from));
        }
        catch (FileNotFoundException ex) {
            System.out.println("could not create " + outTo);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.out);
        }
    }

    public List<CWStream> getLogGroups(Date from, String env) {
        List<CWStream> streams = this.getMatchingStreams(Pattern.compile("/aws/lambda/" + StringUtils.capitalize((String)env) + ".*Lambda"), from);
        DescribeLogGroupsResponse response = this.client.describeLogGroups();
        ArrayList<LogGroup> grps = new ArrayList<LogGroup>();
        for (LogGroup lg : response.logGroups()) {
            Matcher m = Pattern.compile("aws-ziniki-" + env).matcher(lg.logGroupName());
            if (!m.find()) continue;
            grps.add(lg);
        }
        return streams;
    }

    public List<LogGroup> getGroups(Pattern patt) {
        DescribeLogGroupsResponse response = this.client.describeLogGroups();
        ArrayList<LogGroup> grps = new ArrayList<LogGroup>();
        for (LogGroup lg : response.logGroups()) {
            Matcher m;
            if (patt != null && !(m = patt.matcher(lg.logGroupName())).find()) continue;
            grps.add(lg);
        }
        return grps;
    }

    public static void usage() {
        System.out.println("Usage:");
        System.out.println("  read                                   - show all groups");
        System.out.println("  read --group <patt>                    - show streams for log group");
        System.out.println("  read --group <patt> --stream <index>   - contents of log stream");
        System.out.println("  read --zip <file> [--last <#sec> | --since 2400]");
        System.out.println("                                         - create zip of logs by lambda in last day, last number of seconds or since local 24h time");
    }
}

