/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cloudwatchreader;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cloudwatchreader.CWProcessor;
import org.ziniki.cloudwatchreader.CWStream;
import org.zinutils.utils.FileUtils;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;

public class CWZipCreator
implements CWProcessor {
    static final Logger logger = LoggerFactory.getLogger((String)"CWReader");
    private static final Pattern uowre = Pattern.compile(".*Created UOW (.*)");
    private static final Pattern httpre = Pattern.compile(".*HTTP handling ([A-Z]*) (.*)");
    private static final Pattern useridre = Pattern.compile(".*userid = (.*)");
    private final ZipOutputStream zos;
    private final Date from;
    String nextToken = null;
    String currtxid = null;
    String token = null;
    String userid = null;
    String verb = null;
    String url = null;
    StringBuilder sb = null;
    Date ts = null;
    boolean justid = false;
    private ArrayList<String> saveForReplay = null;
    private SimpleDateFormat sdf = new SimpleDateFormat("HHmmss.SSS");

    public CWZipCreator(ZipOutputStream zos, Date from) {
        this.zos = zos;
        this.from = from;
    }

    @Override
    public void startStream(CWStream cws) {
        this.reset();
        Date first = new Date(cws.logStream().firstEventTimestamp());
        if (this.from == null || first.after(this.from)) {
            logger.debug("Processing contents of " + cws.logGroupName() + ":" + cws.logStreamName() + " from " + first);
        } else {
            logger.debug("Processing contents of " + cws.logGroupName() + ":" + cws.logStreamName() + " from " + this.from);
        }
    }

    private void reset() {
        this.nextToken = null;
        this.currtxid = null;
        this.token = null;
        this.userid = null;
        this.verb = null;
        this.url = null;
        this.sb = null;
        this.justid = false;
    }

    @Override
    public void process(OutputLogEvent ole) throws IOException {
        String msg = ole.message();
        if (msg == null || msg.length() == 0) {
            return;
        }
        if (msg.startsWith("START")) {
            this.reset();
            this.sb = new StringBuilder();
            this.ts = new Date(ole.timestamp());
            if (this.saveForReplay != null) {
                for (String s : this.saveForReplay) {
                    this.process(s);
                }
                this.saveForReplay = null;
            }
            return;
        }
        if (msg.startsWith("END")) {
            if (!this.justid && this.sb != null && this.sb.length() > 0) {
                if (this.currtxid == null) {
                    System.out.println("Didn't handle me!");
                    System.out.print(this.sb);
                } else if (this.verb != null) {
                    this.zos.putNextEntry(new ZipEntry(this.sdf.format(this.ts) + "-" + this.currtxid + "-" + this.verb + "-" + this.url.replaceAll("/", "-")));
                    FileUtils.writeToStream((String)this.sb.toString(), (OutputStream)this.zos);
                }
            }
            this.reset();
            return;
        }
        if (msg.startsWith("REPORT")) {
            this.reset();
            return;
        }
        if (this.saveForReplay != null) {
            this.saveForReplay.add(msg);
            return;
        }
        if (this.sb == null) {
            return;
        }
        this.process(msg);
    }

    private void process(String msg) {
        this.sb.append(msg);
        if (msg.contains("HTTP handling ")) {
            Matcher m = httpre.matcher(msg.trim());
            if (m.matches()) {
                if (this.verb != null) {
                    this.saveForReplay = new ArrayList();
                    this.saveForReplay.add(msg);
                }
                this.verb = m.group(1);
                this.url = m.group(2);
                if ("/domain/create".equals(this.url)) {
                    this.currtxid = "domain-create";
                }
            } else {
                System.out.println("pattern did not match " + msg.trim());
            }
        } else if (msg.contains("new ZiWSH AWS Listener")) {
            this.verb = "wsapi";
            this.url = "/";
        } else if ("wsapi".equals(this.verb) && msg.contains("Received open request with")) {
            this.url = "open";
        } else if ("wsapi".equals(this.verb) && msg.contains("received WS.onText:")) {
            this.url = "text";
        } else if (msg.contains("userid = ")) {
            Matcher m = useridre.matcher(msg.trim());
            if (m.matches()) {
                this.userid = m.group(1);
            } else {
                System.out.println("pattern did not match " + msg.trim());
            }
        } else if (msg.contains("found with Token[")) {
            this.token = msg.trim();
        } else if (msg.contains("Created UOW")) {
            Matcher m = uowre.matcher(msg.trim());
            if (m.matches()) {
                this.currtxid = m.group(1);
            } else {
                System.out.println("pattern did not match " + msg.trim());
            }
        } else if (msg.contains("Index Servlet handling ")) {
            this.justid = true;
        } else if (msg.contains("providing id url for") || msg.contains("providing generic id url")) {
            this.justid = true;
        } else if (msg.contains("Sending login template")) {
            this.justid = true;
        } else if (msg.contains("close(org.ziniki.server.main.aws.AWSResponder")) {
            this.justid = true;
        }
    }
}

