/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.cloudwatchreader;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.ziniki.cloudwatchreader.CWProcessor;
import org.ziniki.cloudwatchreader.CWStream;
import software.amazon.awssdk.services.cloudwatchlogs.CloudWatchLogsClient;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.GetLogEventsResponse;
import software.amazon.awssdk.services.cloudwatchlogs.model.OutputLogEvent;

public class CWStreamReader {
    private final CloudWatchLogsClient client;
    private final List<CWStream> logStreams;
    private final Date from;

    public CWStreamReader(CloudWatchLogsClient client, List<CWStream> logStreams, Date from) {
        this.client = client;
        this.logStreams = logStreams;
        this.from = from;
    }

    public void process(CWProcessor proc) throws IOException {
        block0: for (CWStream cws : this.logStreams) {
            proc.startStream(cws);
            GetLogEventsRequest.Builder req = GetLogEventsRequest.builder().logGroupName(cws.logGroupName()).logStreamName(cws.logStreamName());
            String nextToken = null;
            while (true) {
                GetLogEventsRequest.Builder glereq = req.nextToken(nextToken).startFromHead(Boolean.valueOf(true));
                if (this.from != null) {
                    glereq.startTime(Long.valueOf(this.from.getTime()));
                }
                GetLogEventsResponse logEvents = this.client.getLogEvents((GetLogEventsRequest)glereq.build());
                for (OutputLogEvent i : logEvents.events()) {
                    proc.process(i);
                }
                if (logEvents.nextForwardToken().equals(nextToken)) continue block0;
                nextToken = logEvents.nextForwardToken();
            }
        }
    }
}

