/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tools.dynamoreader;

import org.ziniki.tools.dynamoreader.DynamoDBReader;
import org.ziniki.tools.dynamoreader.FailedException;
import org.zinutils.exceptions.InvalidUsageException;

public class Main {
    public static void main(String[] args) {
        Action a = Action.NONE;
        String profile = null;
        String indomain = null;
        String identity = null;
        String cred = null;
        String appname = null;
        String showid = null;
        try {
            block51: for (int i = 0; i < args.length; ++i) {
                switch (args[i]) {
                    case "--profile": {
                        if (profile != null) {
                            throw new InvalidUsageException("cannot specify profile more than once");
                        }
                        if (++i < args.length) {
                            profile = args[i];
                        } else {
                            throw new InvalidUsageException("--profile <profile>");
                        }
                    }
                    case "--all": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.ALL;
                        continue block51;
                    }
                    case "--apps": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.APPS;
                        continue block51;
                    }
                    case "--app": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.APP;
                        if (++i < args.length) {
                            appname = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--app <app>");
                    }
                    case "--assemblies": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.ASSEMBLIES;
                        continue block51;
                    }
                    case "--assembly": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.ASSEMBLY;
                        if (++i < args.length) {
                            appname = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--assembly <assembly>");
                    }
                    case "--domains": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.DOMAINS;
                        continue block51;
                    }
                    case "--identities": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.IDENTITIES;
                        continue block51;
                    }
                    case "--show": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.SHOW;
                        if (++i < args.length) {
                            showid = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--show <id>");
                    }
                    case "--tokens": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.TOKENS;
                        continue block51;
                    }
                    case "--users": {
                        if (a != Action.NONE) {
                            throw new InvalidUsageException("can only specify one action");
                        }
                        a = Action.USERS;
                        continue block51;
                    }
                    case "--indomain": {
                        if (indomain != null) {
                            throw new InvalidUsageException("can only specify one domain");
                        }
                        if (++i < args.length) {
                            indomain = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--indomain <domain>");
                    }
                    case "--identity": {
                        if (identity != null) {
                            throw new InvalidUsageException("can only specify one identity");
                        }
                        if (++i < args.length) {
                            identity = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--identity <identity>");
                    }
                    case "--cred": {
                        if (cred != null) {
                            throw new InvalidUsageException("can only specify one cred");
                        }
                        if (++i < args.length) {
                            cred = args[i];
                            continue block51;
                        }
                        throw new InvalidUsageException("--cred <cred>");
                    }
                    case "": {
                        continue block51;
                    }
                    default: {
                        throw new InvalidUsageException("invalid option: " + args[i]);
                    }
                }
            }
            if (profile == null && (profile = System.getenv("AWS_PROFILE")) == null) {
                throw new InvalidUsageException("Must specify --profile or env var AWS_PROFILE");
            }
            DynamoDBReader reader = new DynamoDBReader(profile);
            switch (a) {
                case NONE: {
                    throw new InvalidUsageException("must specify one of --all, --apps, --app, --assemblies, --domains, --identities, --tokens, --users");
                }
                case ALL: {
                    reader.allKeys();
                    break;
                }
                case APP: {
                    if (indomain == null || appname == null) {
                        throw new InvalidUsageException("--app <name> --indomain <domain>");
                    }
                    reader.app(appname, indomain);
                    break;
                }
                case APPS: {
                    reader.apps(indomain);
                    break;
                }
                case ASSEMBLIES: {
                    reader.assemblies(indomain);
                    break;
                }
                case ASSEMBLY: {
                    if (indomain == null || appname == null) {
                        throw new InvalidUsageException("--assembly <name> --indomain <domain>");
                    }
                    reader.assembly(appname, indomain);
                    break;
                }
                case DOMAINS: {
                    reader.domains();
                    break;
                }
                case IDENTITIES: {
                    if (cred == null) {
                        reader.identities(indomain);
                        break;
                    }
                    reader.identityForCred(cred);
                    break;
                }
                case SHOW: {
                    reader.showitem(showid);
                    break;
                }
                case TOKENS: {
                    reader.tokens(identity);
                    break;
                }
                case USERS: {
                    reader.users(indomain);
                }
            }
        }
        catch (InvalidUsageException e) {
            System.err.println("Usage: (--all|--apps|--app|--assemblies|--assembly|--domains|--show|--tokens|--users)");
            System.err.println("  " + e.getMessage());
            System.exit(2);
        }
        catch (FailedException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    static enum Action {
        NONE,
        ALL,
        APPS,
        APP,
        ASSEMBLIES,
        ASSEMBLY,
        DOMAINS,
        IDENTITIES,
        SHOW,
        TOKENS,
        USERS;

    }
}

