/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.tools.dynamoreader;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ziniki.tools.dynamoreader.FailedException;
import org.ziniki.tools.dynamoreader.ShowToken;
import org.ziniki.tools.dynamoreader.ShowTokenComparator;
import org.zinutils.collections.SetMap;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.InvalidUsageException;
import org.zinutils.utils.StringComparator;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClientBuilder;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;

public class DynamoDBReader {
    private DynamoDbAsyncClient db;
    private final Map<String, String> ean = new TreeMap<String, String>();
    private final Map<String, AttributeValue> eav = new TreeMap<String, AttributeValue>();
    private final Pattern matchAppsArena = Pattern.compile("seckey://([^/]*)/arena/apps/org.ziniki.secondaries.PackageByName/([^/]*)");
    private final Pattern matchAssembly = Pattern.compile("assembler://([^/]*)/assembly/([^/]*)");
    private final Pattern matchDomain = Pattern.compile("ziniki://([^/]*)/domain");
    private final Pattern matchToken = Pattern.compile("security://([^/]*)/token/([^/]*)");
    private final String table;

    public DynamoDBReader(String profile) {
        DefaultCredentialsProvider credentialsProvider = DefaultCredentialsProvider.builder().profileName(profile).build();
        this.db = (DynamoDbAsyncClient)((DynamoDbAsyncClientBuilder)((DynamoDbAsyncClientBuilder)DynamoDbAsyncClient.builder().credentialsProvider((AwsCredentialsProvider)credentialsProvider)).region(Region.US_EAST_1)).build();
        this.ean.put("#key", "_key");
        if (profile.endsWith("-live")) {
            this.table = "ZinikiLiveEntities";
        } else if (profile.endsWith("-staging")) {
            this.table = "ZinikiStagingEntities";
        } else if (profile.endsWith("-dev")) {
            this.table = "ZinikiDevGarethEntities";
        } else {
            throw new HaventConsideredThisException("cannot handle profile " + profile);
        }
    }

    public void allKeys() throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        Map lev = null;
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, false).build()).get();
            for (Map i : scanner.items()) {
                System.out.println(((AttributeValue)i.get("_key")).s());
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
    }

    public void apps(String indomain) throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        indomain = indomain == null ? "" : (String)indomain + "/";
        Map lev = null;
        this.eav.put(":pbn", (AttributeValue)AttributeValue.builder().s("/arena/apps/org.ziniki.secondaries.PackageByName/").build());
        this.eav.put(":seckey", (AttributeValue)AttributeValue.builder().s("seckey://" + (String)indomain).build());
        SetMap result = new SetMap((Comparator)new StringComparator(), (Comparator)new StringComparator());
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :seckey) AND contains(#key, :pbn)").build()).get();
            for (Map i : scanner.items()) {
                String key = ((AttributeValue)i.get("_key")).s();
                Matcher m = this.matchAppsArena.matcher(key);
                if (!m.matches()) continue;
                result.add((Object)m.group(1), (Object)m.group(2));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        if (((String)indomain).equals("")) {
            System.out.println("Found " + result.totalSize() + " apps");
        }
        for (String d : result.keySet()) {
            Set apps = result.get((Object)d);
            System.out.println("  domain " + d + " (" + apps.size() + " apps)");
            for (String a : apps) {
                System.out.println("    app " + a);
            }
        }
    }

    public void app(String appname, String indomain) throws Exception {
        TreeMap<String, AttributeValue> skm = new TreeMap<String, AttributeValue>();
        skm.put("_key", (AttributeValue)AttributeValue.builder().s("seckey://" + indomain + "/arena/apps/org.ziniki.secondaries.PackageByName/" + appname).build());
        GetItemResponse sk = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skm).build()).get();
        if (!sk.hasItem()) {
            System.out.println("there is no app " + appname + " in " + indomain);
            return;
        }
        AttributeValue arenaKey = (AttributeValue)sk.item().get("pointsTo");
        System.out.println("app " + appname + " for " + indomain + " is stored in " + arenaKey.s());
        TreeMap<String, AttributeValue> akm = new TreeMap<String, AttributeValue>();
        akm.put("_key", arenaKey);
        GetItemResponse arena = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(akm).build()).get();
        if (!arena.hasItem()) {
            System.out.println("the arena for app " + appname + " in " + indomain + " could not be loaded");
            return;
        }
        String latestVersion = ((AttributeValue)arena.item().get("latestVersion")).s();
        System.out.println("the latest version is " + latestVersion);
        TreeMap<String, AttributeValue> skvkm = new TreeMap<String, AttributeValue>();
        skvkm.put("_key", (AttributeValue)AttributeValue.builder().s("seckey://" + indomain + "/arena/apps/org.ziniki.secondaries.PackageByNameVersion/" + appname + "/" + latestVersion).build());
        GetItemResponse skv = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skvkm).build()).get();
        if (!skv.hasItem()) {
            System.out.println("there is no app " + appname + " in " + indomain);
            return;
        }
        AttributeValue arenaNameVersion = (AttributeValue)skv.item().get("pointsTo");
        System.out.println("version " + latestVersion + " of app " + appname + " for " + indomain + " is stored in " + arenaNameVersion.s());
        TreeMap<String, AttributeValue> nvekm = new TreeMap<String, AttributeValue>();
        nvekm.put("_key", arenaNameVersion);
        GetItemResponse nve = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(nvekm).build()).get();
        if (!nve.hasItem()) {
            System.out.println("the arena for app " + appname + " in " + indomain + " could not be loaded");
            return;
        }
        Map entity = nve.item();
        System.out.println(((AttributeValue)entity.get("packageName")).s() + ":" + ((AttributeValue)entity.get("version")).s());
        System.out.println("  deployed: " + ((AttributeValue)entity.get("deployed")).bool());
        if (entity.containsKey("assemblies")) {
            System.out.println("  assemblies:");
            for (AttributeValue a : ((AttributeValue)entity.get("assemblies")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("webzips")) {
            System.out.println("  webzips:");
            for (AttributeValue a : ((AttributeValue)entity.get("webzips")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("sources")) {
            System.out.println("  sources:");
            for (AttributeValue a : ((AttributeValue)entity.get("sources")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("unitTests")) {
            System.out.println("  unitTests:");
            for (AttributeValue a : ((AttributeValue)entity.get("unitTests")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("systemTests")) {
            System.out.println("  systemTests:");
            for (AttributeValue a : ((AttributeValue)entity.get("systemTests")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("flascklib")) {
            System.out.println("  flascklib:");
            System.out.println("    " + ((AttributeValue)((AttributeValue)entity.get("flascklib")).m().get("refersTo")).s());
        }
        if (entity.containsKey("modules")) {
            System.out.println("  modules:");
            for (AttributeValue a : ((AttributeValue)entity.get("modules")).l()) {
                System.out.println("    " + ((AttributeValue)a.m().get("refersTo")).s());
            }
        }
        if (entity.containsKey("dependencies")) {
            System.out.println("  dependencies:");
            for (AttributeValue a : ((AttributeValue)entity.get("dependencies")).l()) {
                System.out.println("    " + ((AttributeValue)a.m().get("refersTo")).s());
            }
        }
        if (entity.containsKey("flim")) {
            System.out.println("  flim:");
            for (AttributeValue a : ((AttributeValue)entity.get("flim")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("livejs")) {
            System.out.println("  livejs:");
            for (AttributeValue a : ((AttributeValue)entity.get("livejs")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("testjs")) {
            System.out.println("  testjs:");
            for (AttributeValue a : ((AttributeValue)entity.get("testjs")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("livejar")) {
            System.out.println("  livejar:");
            for (AttributeValue a : ((AttributeValue)entity.get("livejar")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
        if (entity.containsKey("testjar")) {
            System.out.println("  testjar:");
            for (AttributeValue a : ((AttributeValue)entity.get("testjar")).l()) {
                System.out.println("    cs://" + ((AttributeValue)a.m().get("key")).s());
            }
        }
    }

    public void assemblies(String indomain) throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        indomain = indomain == null ? "" : (String)indomain + "/";
        Map lev = null;
        this.eav.put(":ass", (AttributeValue)AttributeValue.builder().s("/assembly/").build());
        this.eav.put(":key", (AttributeValue)AttributeValue.builder().s("assembler://" + (String)indomain).build());
        SetMap result = new SetMap((Comparator)new StringComparator(), (Comparator)new StringComparator());
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :key) AND contains(#key, :ass)").build()).get();
            for (Map i : scanner.items()) {
                String key = ((AttributeValue)i.get("_key")).s();
                Matcher m = this.matchAssembly.matcher(key);
                if (!m.matches()) continue;
                result.add((Object)m.group(1), (Object)m.group(2));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        if (((String)indomain).equals("")) {
            System.out.println("Found " + result.totalSize() + " assemblies");
        }
        for (String d : result.keySet()) {
            Set apps = result.get((Object)d);
            System.out.println("  domain " + d + " (" + apps.size() + " assemblies)");
            for (String a : apps) {
                System.out.println("    assembly " + a);
            }
        }
    }

    public void assembly(String appname, String indomain) throws InterruptedException, ExecutionException {
        TreeMap<String, AttributeValue> skm = new TreeMap<String, AttributeValue>();
        skm.put("_key", (AttributeValue)AttributeValue.builder().s("assembler://" + indomain + "/assembly/" + appname).build());
        GetItemResponse sk = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skm).build()).get();
        if (!sk.hasItem()) {
            System.out.println("there is no app " + appname + " in " + indomain);
            return;
        }
        Map entity = sk.item();
        System.out.println("assembly " + appname + " in " + indomain);
        System.out.println("  title: \"" + ((AttributeValue)entity.get("title")).s() + "\"");
        if (entity.containsKey("templates")) {
            System.out.println("  templates: cs://" + ((AttributeValue)((AttributeValue)entity.get("templates")).m().get("key")).s());
        }
        if (entity.containsKey("packages")) {
            int pkg = 0;
            for (AttributeValue u : ((AttributeValue)entity.get("packages")).l()) {
                System.out.println("  package " + pkg++ + ":");
                this.assemblyPackage(u.m());
            }
        }
    }

    private void assemblyPackage(Map<String, AttributeValue> m) {
        if (m.containsKey("css")) {
            int k = 0;
            for (AttributeValue c : m.get("css").l()) {
                System.out.println("    css   " + k++ + " => cs://" + ((AttributeValue)c.m().get("key")).s());
            }
            k = 0;
            for (AttributeValue c : m.get("javascript").l()) {
                System.out.println("    js    " + k++ + " => cs://" + ((AttributeValue)c.m().get("key")).s());
            }
            k = 0;
            for (AttributeValue c : m.get("assets").l()) {
                System.out.println("    asset " + k++ + " => cs://" + ((AttributeValue)c.m().get("key")).s());
            }
            k = 0;
            for (AttributeValue c : m.get("inits").l()) {
                Map m1 = c.m();
                System.out.println("    init  " + k++ + " for \"" + ((AttributeValue)m1.get("packageName")).s() + "\"");
                for (AttributeValue p : ((AttributeValue)m1.get("packages")).l()) {
                    System.out.println("      references package \"" + p.s() + "\"");
                }
            }
        }
    }

    public void domains() throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        Map lev = null;
        this.eav.put(":domain", (AttributeValue)AttributeValue.builder().s("/domain").build());
        this.eav.put(":ziniki", (AttributeValue)AttributeValue.builder().s("ziniki://").build());
        TreeSet<String> result = new TreeSet<String>();
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :ziniki) AND contains(#key, :domain)").build()).get();
            for (Map i : scanner.items()) {
                String domain = ((AttributeValue)i.get("_key")).s();
                Matcher m = this.matchDomain.matcher(domain);
                if (!m.matches()) continue;
                result.add(m.group(1));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        System.out.println("Found " + result.size() + " domains");
        for (String d : result) {
            System.out.println("  domain " + d);
        }
    }

    public void identities(String indomain) throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        if (indomain == null) {
            indomain = "";
        }
        Map lev = null;
        this.eav.clear();
        this.eav.put(":domain", (AttributeValue)AttributeValue.builder().s(indomain + "/domain").build());
        this.eav.put(":ziniki", (AttributeValue)AttributeValue.builder().s("ziniki://").build());
        TreeSet<String> result = new TreeSet<String>();
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :ziniki) AND contains(#key, :domain)").build()).get();
            for (Map i : scanner.items()) {
                String domain = ((AttributeValue)i.get("_key")).s();
                Matcher m = this.matchDomain.matcher(domain);
                if (!m.matches()) continue;
                result.add(m.group(1));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        if (indomain.equals("")) {
            System.out.println("Found " + result.size() + " domains");
        }
        for (String d : result) {
            ScanResponse scanner2;
            this.eav.clear();
            Object prefix = indomain.length() == 0 ? "ziniki://[^/]*/identity/" : "ziniki://" + d + "/identity/";
            this.eav.put(":identity", (AttributeValue)AttributeValue.builder().s("ziniki").build());
            this.eav.put(":domainIdentity", (AttributeValue)AttributeValue.builder().s(d + "/identity/").build());
            TreeMap<String, String> users = new TreeMap<String, String>();
            lev = null;
            do {
                scanner2 = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :identity) AND contains(#key, :domainIdentity)").build()).get();
                for (Map i : scanner2.items()) {
                    String userid = ((AttributeValue)i.get("_key")).s();
                    String user = userid.replaceAll((String)prefix, "");
                    users.put(user, userid);
                }
            } while (!(lev = scanner2.lastEvaluatedKey()).isEmpty());
            System.out.println("  domain " + d + " (" + users.size() + " users)");
            for (Map.Entry u : users.entrySet()) {
                System.out.println("    identity " + (String)u.getKey());
                this.showCredentials((String)u.getValue());
            }
        }
    }

    public void identityForCred(String cred) throws InterruptedException, ExecutionException, FailedException {
        TreeMap<String, AttributeValue> skm = new TreeMap<String, AttributeValue>();
        skm.put("_key", (AttributeValue)AttributeValue.builder().s("security://cross.domain/credential/" + cred).build());
        GetItemResponse gir = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skm).build()).get();
        if (!gir.hasItem()) {
            throw new FailedException("there is no credential for " + cred);
        }
        Map item = gir.item();
        System.out.println(((AttributeValue)((AttributeValue)item.get("identity")).m().get("uri")).s());
    }

    private void showCredentials(String user) throws InterruptedException, ExecutionException {
        TreeMap<String, AttributeValue> skm = new TreeMap<String, AttributeValue>();
        skm.put("_key", (AttributeValue)AttributeValue.builder().s(user).build());
        GetItemResponse gir = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skm).build()).get();
        List creds = ((AttributeValue)gir.item().get("credentials")).l();
        for (AttributeValue c : creds) {
            System.out.println("      cred " + ((AttributeValue)c.m().get("refersTo")).s().replaceFirst("security://cross.domain/credential/", ""));
        }
    }

    public void showitem(String showid) throws InterruptedException, ExecutionException {
        TreeMap<String, AttributeValue> skm = new TreeMap<String, AttributeValue>();
        skm.put("_key", (AttributeValue)AttributeValue.builder().s(showid).build());
        GetItemResponse gir = (GetItemResponse)this.db.getItem((GetItemRequest)GetItemRequest.builder().tableName(this.table).key(skm).build()).get();
        if (!gir.hasItem()) {
            throw new InvalidUsageException("there is no object " + showid);
        }
        System.out.println("Item " + showid + ":");
        this.showItem("  ", new TreeMap<String, AttributeValue>(gir.item()));
    }

    private void showItem(String prefix, Map<String, AttributeValue> item) {
        for (Map.Entry<String, AttributeValue> e : item.entrySet()) {
            System.out.print(prefix + e.getKey() + ": ");
            this.showAV(prefix, e.getValue());
        }
    }

    private void showAV(String prefix, AttributeValue value) {
        if (value.s() != null) {
            System.out.println("\"" + value.s() + "\"");
        } else if (value.n() != null) {
            System.out.println(value.n());
        } else if (value.hasL()) {
            System.out.println("list");
            this.showList(prefix + "  ", value);
        } else if (value.hasM()) {
            System.out.println("map");
            this.showItem(prefix + "  ", value.m());
        } else {
            System.out.println("uh " + value);
        }
    }

    private void showList(String prefix, AttributeValue value) {
        int k = 0;
        for (AttributeValue i : value.l()) {
            System.out.print(prefix + "[" + k++ + "]: ");
            this.showAV(prefix + "  ", i);
        }
    }

    public void users(String indomain) throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        if (indomain == null) {
            indomain = "";
        }
        this.eav.clear();
        this.eav.put(":challenger", (AttributeValue)AttributeValue.builder().s("challenger").build());
        ScanResponse scanner2 = (ScanResponse)this.db.scan((ScanRequest)this.scanner(null, true).filterExpression("begins_with(#key, :challenger)").build()).get();
        if (scanner2.count() == 0) {
            System.out.println("There are no challenger records in the database - did you mean --identities?");
            return;
        }
        Map lev = null;
        this.eav.clear();
        this.eav.put(":domain", (AttributeValue)AttributeValue.builder().s(indomain + "/domain").build());
        this.eav.put(":ziniki", (AttributeValue)AttributeValue.builder().s("ziniki://").build());
        TreeSet<String> result = new TreeSet<String>();
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :ziniki) AND contains(#key, :domain)").build()).get();
            for (Map i : scanner.items()) {
                String domain = ((AttributeValue)i.get("_key")).s();
                Matcher m = this.matchDomain.matcher(domain);
                if (!m.matches()) continue;
                result.add(m.group(1));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        if (indomain.equals("")) {
            System.out.println("Found " + result.size() + " domains");
        }
        for (String d : result) {
            ScanResponse scanner3;
            this.eav.clear();
            String prefix = "challenger://[^/]*" + d + "/login/";
            this.eav.put(":challenger", (AttributeValue)AttributeValue.builder().s("challenger").build());
            this.eav.put(":domainLogin", (AttributeValue)AttributeValue.builder().s(d + "/login/").build());
            TreeSet<String> users = new TreeSet<String>();
            lev = null;
            do {
                scanner3 = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :challenger) AND contains(#key, :domainLogin)").build()).get();
                for (Map i : scanner3.items()) {
                    String user = ((AttributeValue)i.get("_key")).s().replaceAll(prefix, "");
                    users.add(user);
                }
            } while (!(lev = scanner3.lastEvaluatedKey()).isEmpty());
            System.out.println("  domain " + d + " (" + users.size() + " users)");
            for (String u : users) {
                System.out.println("    user " + u);
            }
        }
    }

    public void tokens(String forIdentity) throws InterruptedException, ExecutionException {
        ScanResponse scanner;
        Map lev = null;
        this.ean.put("#ttl", "_ttl");
        this.ean.put("#identity", "identity");
        this.eav.put(":security", (AttributeValue)AttributeValue.builder().s("security://").build());
        this.eav.put(":token", (AttributeValue)AttributeValue.builder().s("/token/").build());
        SetMap result = new SetMap((Comparator)new StringComparator(), (Comparator)new ShowTokenComparator());
        do {
            scanner = (ScanResponse)this.db.scan((ScanRequest)this.scanner(lev, true).filterExpression("begins_with(#key, :security) AND contains(#key, :token)").projectionExpression("#key, #ttl, #identity.uri, secret").build()).get();
            for (Map i : scanner.items()) {
                Matcher m;
                String tok = ((AttributeValue)i.get("_key")).s();
                Date ttl = new Date(Long.parseLong(((AttributeValue)i.get("_ttl")).n()) * 1000L);
                String secret = ((AttributeValue)i.get("secret")).s();
                String identity = null;
                if (i.containsKey("identity")) {
                    Map id = ((AttributeValue)i.get("identity")).m();
                    identity = ((AttributeValue)id.get("uri")).s();
                }
                if (!(m = this.matchToken.matcher(tok)).matches() || identity == null || forIdentity != null && !forIdentity.equals(identity)) continue;
                result.add((Object)m.group(1), (Object)new ShowToken(m.group(1), m.group(2), identity, secret, ttl));
            }
        } while (!(lev = scanner.lastEvaluatedKey()).isEmpty());
        if (forIdentity == null) {
            System.out.println("Found " + result.totalSize() + " validated tokens in " + result.keySet().size() + " domains");
            for (String d : result) {
                System.out.println("  domain " + d);
                for (ShowToken k : result.get((Object)d)) {
                    System.out.println("    token " + k);
                }
            }
        } else {
            for (ShowToken t : result.values()) {
                System.out.println(t.readable());
            }
        }
    }

    private ScanRequest.Builder scanner(Map<String, AttributeValue> lev, boolean withValues) {
        ScanRequest.Builder ret = ScanRequest.builder().tableName(this.table).expressionAttributeNames(this.ean);
        if (withValues) {
            ret = ret.expressionAttributeValues(this.eav);
        }
        ret = ret.projectionExpression("#key").exclusiveStartKey(lev);
        return ret;
    }
}

