/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.diagnostics.DiagnosticsResult;
import com.couchbase.client.core.diagnostics.PingResult;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.env.PasswordAuthenticator;
import com.couchbase.client.core.env.SeedNode;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncCluster;
import com.couchbase.client.java.AsyncUtils;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.ClusterOptions;
import com.couchbase.client.java.ReactiveCluster;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsResult;
import com.couchbase.client.java.diagnostics.DiagnosticsOptions;
import com.couchbase.client.java.diagnostics.PingOptions;
import com.couchbase.client.java.diagnostics.WaitUntilReadyOptions;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.manager.analytics.AnalyticsIndexManager;
import com.couchbase.client.java.manager.bucket.BucketManager;
import com.couchbase.client.java.manager.query.QueryIndexManager;
import com.couchbase.client.java.manager.search.SearchIndexManager;
import com.couchbase.client.java.manager.user.UserManager;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.search.SearchOptions;
import com.couchbase.client.java.search.SearchQuery;
import com.couchbase.client.java.search.result.SearchResult;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class Cluster {
    private final AsyncCluster asyncCluster;
    private final ReactiveCluster reactiveCluster;
    private final SearchIndexManager searchIndexManager;
    private final UserManager userManager;
    private final BucketManager bucketManager;
    private final QueryIndexManager queryIndexManager;
    private final AnalyticsIndexManager analyticsIndexManager;
    private final Map<String, Bucket> bucketCache = new ConcurrentHashMap<String, Bucket>();

    public static Cluster connect(String connectionString, String username, String password) {
        return Cluster.connect(connectionString, ClusterOptions.clusterOptions((Authenticator)PasswordAuthenticator.create((String)username, (String)password)));
    }

    public static Cluster connect(String connectionString, ClusterOptions options) {
        Validators.notNullOrEmpty((String)connectionString, (String)"ConnectionString");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        Supplier<ClusterEnvironment> environmentSupplier = AsyncCluster.extractClusterEnvironment(connectionString, opts);
        return new Cluster(environmentSupplier, opts.authenticator(), AsyncCluster.seedNodesFromConnectionString(connectionString, environmentSupplier.get()));
    }

    public static Cluster connect(Set<SeedNode> seedNodes, ClusterOptions options) {
        Validators.notNullOrEmpty(seedNodes, (String)"SeedNodes");
        Validators.notNull((Object)options, (String)"ClusterOptions");
        ClusterOptions.Built opts = options.build();
        return new Cluster(AsyncCluster.extractClusterEnvironment(null, opts), opts.authenticator(), seedNodes);
    }

    private Cluster(Supplier<ClusterEnvironment> environment, Authenticator authenticator, Set<SeedNode> seedNodes) {
        this.asyncCluster = new AsyncCluster(environment, authenticator, seedNodes);
        this.reactiveCluster = new ReactiveCluster(this.asyncCluster);
        this.searchIndexManager = new SearchIndexManager(this.asyncCluster.searchIndexes());
        this.userManager = new UserManager(this.asyncCluster.users());
        this.bucketManager = new BucketManager(this.asyncCluster.buckets());
        this.queryIndexManager = new QueryIndexManager(this.asyncCluster.queryIndexes());
        this.analyticsIndexManager = new AnalyticsIndexManager(this);
    }

    public AsyncCluster async() {
        return this.asyncCluster;
    }

    public ReactiveCluster reactive() {
        return this.reactiveCluster;
    }

    @Stability.Volatile
    public Core core() {
        return this.asyncCluster.core();
    }

    public UserManager users() {
        return this.userManager;
    }

    public BucketManager buckets() {
        return this.bucketManager;
    }

    public AnalyticsIndexManager analyticsIndexes() {
        return this.analyticsIndexManager;
    }

    public QueryIndexManager queryIndexes() {
        return this.queryIndexManager;
    }

    public SearchIndexManager searchIndexes() {
        return this.searchIndexManager;
    }

    public ClusterEnvironment environment() {
        return this.asyncCluster.environment();
    }

    public QueryResult query(String statement) {
        return this.query(statement, ReactiveCluster.DEFAULT_QUERY_OPTIONS);
    }

    public QueryResult query(String statement, QueryOptions options) {
        return AsyncUtils.block(this.async().query(statement, options));
    }

    public AnalyticsResult analyticsQuery(String statement) {
        return this.analyticsQuery(statement, ReactiveCluster.DEFAULT_ANALYTICS_OPTIONS);
    }

    public AnalyticsResult analyticsQuery(String statement, AnalyticsOptions options) {
        return AsyncUtils.block(this.async().analyticsQuery(statement, options));
    }

    public SearchResult searchQuery(String indexName, SearchQuery query) {
        return this.searchQuery(indexName, query, ReactiveCluster.DEFAULT_SEARCH_OPTIONS);
    }

    public SearchResult searchQuery(String indexName, SearchQuery query, SearchOptions options) {
        return AsyncUtils.block(this.asyncCluster.searchQuery(indexName, query, options));
    }

    public Bucket bucket(String bucketName) {
        return this.bucketCache.computeIfAbsent(bucketName, n -> new Bucket(this.asyncCluster.bucket((String)n)));
    }

    public void disconnect() {
        AsyncUtils.block(this.asyncCluster.disconnect());
    }

    public void disconnect(Duration timeout) {
        AsyncUtils.block(this.asyncCluster.disconnect(timeout));
    }

    public DiagnosticsResult diagnostics() {
        return AsyncUtils.block(this.asyncCluster.diagnostics(ReactiveCluster.DEFAULT_DIAGNOSTICS_OPTIONS));
    }

    public DiagnosticsResult diagnostics(DiagnosticsOptions options) {
        return AsyncUtils.block(this.asyncCluster.diagnostics(options));
    }

    public PingResult ping() {
        return AsyncUtils.block(this.asyncCluster.ping());
    }

    public PingResult ping(PingOptions options) {
        return AsyncUtils.block(this.asyncCluster.ping(options));
    }

    public void waitUntilReady(Duration timeout) {
        AsyncUtils.block(this.asyncCluster.waitUntilReady(timeout));
    }

    public void waitUntilReady(Duration timeout, WaitUntilReadyOptions options) {
        AsyncUtils.block(this.asyncCluster.waitUntilReady(timeout, options));
    }
}

