/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.flasck.jvm.FLEvalContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.core.concepts.Credential;
import org.ziniki.core.concepts.Identity;
import org.ziniki.interfaces.SecurityStore;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.JVMSecurityToken;
import org.ziniki.openid.fl.ZinikiSecurityToken;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.gls.GLSException;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.RelationHandler;
import org.ziniki.tdastore.gls.Slot;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.utils.IRandom;
import org.zinutils.utils.StringUtil;

public class GLSSecurityStore
implements SecurityStore,
RelationHandler {
    private final Logger logger = LoggerFactory.getLogger((String)"SecurityStore");
    private static final int TokenTTL = 3600;
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final IRandom random;

    public GLSSecurityStore(@Param(value="storage") TDAStorage storage, @Param(value="idfactory") ZiIdFactory factory, @Param(value="random") IRandom random) {
        this.storage = storage;
        this.factory = factory;
        this.random = random;
    }

    public void newSessionToken(UnitOfWork uow, Relation r) {
        try {
            r.logic((RelationHandler)this, "generateNewToken");
        }
        catch (GLSException ex) {
            this.logger.error("GLS Issues", (Throwable)ex);
        }
    }

    public void generateNewToken(UnitOfWork uow, Relation r) {
        GLUnitOfWork zu = (GLUnitOfWork)uow;
        String token = StringUtil.hex((long)this.random.nextLong(Long.MAX_VALUE), (int)16);
        String secret = StringUtil.hex((long)this.random.nextLong(Long.MAX_VALUE), (int)16);
        this.logger.info("Creating session token " + token);
        ZiId id = this.factory.simple("security", ((UOWHost)uow.trait(UOWHost.class)).host, "token", token);
        JVMSecurityToken obj = new JVMSecurityToken((FLEvalContext)zu, token, secret);
        r.load("new_userid", (Object)token);
        r.load("as_token", (Object)obj);
        r.create(id.toString(), (Object)obj, this.storage.expireAfter(3600, (TemporalUnit)ChronoUnit.SECONDS));
    }

    public void touchToken(Relation r, String token) {
        this.logger.info("Touching session token " + token);
        r.touch(this.factory.simple("security", ((UOWHost)r.uow().trait(UOWHost.class)).host, "token", token).toString(), this.storage.expireAfter(3600, (TemporalUnit)ChronoUnit.SECONDS));
    }

    public void bindSessionToCredential(UnitOfWork uow, String token, String cred) {
        if (token == null) {
            throw new RuntimeException("No token set");
        }
        try {
            ZiId tokid = this.parseToken(token);
            ZiId credid = this.factory.simple("security", "cross.domain", "credential", URLEncoder.encode(cred, "UTF-8"));
            Relation r = uow.relation((RelationHandler)this);
            r.load("tokid", (Object)tokid.toString());
            r.load("credName", (Object)cred);
            r.get("currentSession", tokid.toString());
            r.get("cred", credid.toString());
            r.logic("doBindingOfCred");
            uow.makeReady(r);
        }
        catch (GLSException ex) {
            this.logger.error("GLS Issues", (Throwable)ex);
            uow.fatalError((Throwable)ex);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Encoding URL " + cred, (Throwable)e);
            uow.fatalError((Throwable)e);
        }
    }

    private ZiId parseToken(String token) {
        int first = token.indexOf(".");
        if (first == -1) {
            throw new RuntimeException("invalid token - no domain: " + token);
        }
        String domain = token.substring(first + 1);
        token = token.substring(0, first);
        return this.factory.simple("security", domain, "token", token);
    }

    public void doBindingOfCred(UnitOfWork uow, Relation r, @Slot(value="tokid") String tokid, @Slot(value="currentSession") ZinikiSecurityToken obj, @Slot(value="credName") String credName, @Slot(value="cred") Credential cred) {
        if (obj == null) {
            this.logger.error("no valid session in doBindingOfCred");
            uow.fatalError((Throwable)new CantHappenException("no valid session in doBindingOfCred for token " + tokid));
            return;
        }
        if (cred == null) {
            this.logger.info("Marking " + obj + " as registering " + credName);
            obj.setRegistering(credName);
        } else {
            this.logger.info("Binding identity for " + obj + " to " + cred);
            ZiId identity = cred.identity();
            obj.setIdentity(identity);
        }
        r.update(tokid, (Object)obj);
    }

    public void bindSessionToIdentity(UnitOfWork uow, String token, Identity id) {
        try {
            ZiId tokid = this.parseToken(token);
            Relation r = uow.relation((RelationHandler)this);
            r.load("tokid", (Object)tokid);
            r.load("desiredIdentity", (Object)id);
            r.get("currentSession", tokid.toString());
            r.logic((RelationHandler)this, "doSessionBinding");
            uow.makeReady(r);
        }
        catch (GLSException e) {
            this.logger.error("GLS issues", (Throwable)e);
        }
    }

    public void doSessionBinding(Relation r, @Slot(value="tokid") ZiId tokid, @Slot(value="currentSession") ZinikiSecurityToken st, @Slot(value="desiredIdentity") Identity id) {
        st.clearRegistering();
        st.setIdentity(id.ziid());
        r.update(tokid.toString(), (Object)st);
    }

    public void getIdentityFor(Relation r, String slot, String token) {
        ZiId tokid = this.parseToken(token);
        r.get(slot, tokid.toString(), st -> st != null ? st.getIdentity() : null);
    }

    public void getIdentity(Relation r, String slot, ZiId identityId) {
        r.get(slot, identityId.toString());
    }

    public void getTokenState(Relation r, String slot, String token) {
        ZiId tokid = this.parseToken(token);
        r.get(slot, tokid.toString(), st -> st != null ? st.state() : null);
    }

    public void getTokenSecret(Relation r, String slot, String token) {
        ZiId tokid = this.parseToken(token);
        r.get(slot, tokid.toString(), st -> st != null ? st.getSecret() : null);
    }

    public void getCredentialFor(Relation r, String slot, String token) {
        ZiId tokid = this.parseToken(token);
        r.get(slot, tokid.toString(), st -> st != null ? st.getRegistering() : null);
    }

    public void deleteToken(Relation r, String token) {
        ZiId tokid = this.parseToken(token);
        r.delete(tokid.toString());
    }
}

