/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid;

import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.consumer.AbstractNonceVerifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.interfaces.RelationProvider;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.fl.JVMNonce;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;

public class GLSNonceVerifier
extends AbstractNonceVerifier {
    private final Logger logger = LoggerFactory.getLogger((String)"SecurityStore");
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final TxManager txmanager;
    private final RelationProvider relationProvider;

    public GLSNonceVerifier(@Param(value="txmanager") TxManager txmanager, @Param(value="storage") TDAStorage storage, @Param(value="idfactory") ZiIdFactory factory, @Param(value="relationProvider") RelationProvider relationProvider) {
        super(60);
        this.txmanager = txmanager;
        this.storage = storage;
        this.factory = factory;
        this.relationProvider = relationProvider;
    }

    protected int seen(Date whenSeen, String opUrl, String nonce) {
        GLUnitOfWork zu = (GLUnitOfWork)this.txmanager.currentUOW();
        Relation r = this.relationProvider.getRelation();
        String userid = (String)zu.read(r, "userid");
        this.logger.info("have userid = " + userid);
        try {
            ZiId uniqueId = this.factory.simple("openidconsumer", ((UOWHost)zu.trait(UOWHost.class)).host, "nonces", userid + "/" + URLEncoder.encode(opUrl, "UTF-8") + "/" + URLEncoder.encode(nonce, "UTF-8"));
            final CompletableFuture ret = new CompletableFuture();
            this.storage.create((UnitOfWork)zu, uniqueId.toString(), (Object)new JVMNonce((FLEvalContext)zu).setNonce(new Date(new Date().getTime() + 60000L)), new TDACreateHandler(){

                public void success() {
                    GLSNonceVerifier.this.logger.info("Created new nonce");
                    ret.complete(0);
                }

                public void error(Throwable ex) {
                    GLSNonceVerifier.this.logger.error("Error saving nonce", ex);
                    ret.complete(0);
                }

                public void alreadyExists() {
                    ret.complete(1);
                }
            });
            return (Integer)ret.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw WrappedException.wrap((Throwable)e);
        }
    }
}

