/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.flasck.jvm.FLEvalContext;
import org.openid4java.association.Association;
import org.openid4java.consumer.ConsumerAssociationStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.cbtxstore.gls.GLUnitOfWork;
import org.ziniki.common.UOWHost;
import org.ziniki.interfaces.RelationProvider;
import org.ziniki.intf.ZiId;
import org.ziniki.intf.ZiIdFactory;
import org.ziniki.openid.fl.ConsumerAssociation;
import org.ziniki.openid.fl.JVMConsumerAssociation;
import org.ziniki.tdastore.TDAStorage;
import org.ziniki.tdastore.TxManager;
import org.ziniki.tdastore.gls.Relation;
import org.ziniki.tdastore.gls.UnitOfWork;
import org.ziniki.tdastore.lowlevel.RetrievedObject;
import org.ziniki.tdastore.lowlevel.TDACreateHandler;
import org.ziniki.tdastore.lowlevel.TDADeleteHandler;
import org.ziniki.tdastore.lowlevel.TDARetrieveHandler;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.WrappedException;
import org.zinutils.utils.StringUtil;

public class GLSAssociationStore
implements ConsumerAssociationStore {
    private final Logger logger = LoggerFactory.getLogger((String)"GLSAssociationStore");
    private final TDAStorage storage;
    private final ZiIdFactory factory;
    private final TxManager txmanager;
    private final RelationProvider relationProvider;

    public GLSAssociationStore(@Param(value="storage") TDAStorage storage, @Param(value="idfactory") ZiIdFactory factory, @Param(value="txmanager") TxManager txmanager, @Param(value="relationProvider") RelationProvider relationProvider) {
        this.storage = storage;
        this.factory = factory;
        this.txmanager = txmanager;
        this.relationProvider = relationProvider;
    }

    public void save(String opUrl, Association assoc) {
        GLUnitOfWork uow = (GLUnitOfWork)this.txmanager.currentUOW();
        Relation r = this.relationProvider.getRelation();
        String userid = (String)uow.read(r, "userid");
        this.logger.info("have userid = " + userid);
        String handle = assoc.getHandle();
        try {
            String eou = URLEncoder.encode(opUrl, "UTF-8");
            ZiId uniqueId = this.factory.simple("openidconsumer", ((UOWHost)uow.trait(UOWHost.class)).host, "unique", userid + "/" + eou + "/" + URLEncoder.encode(handle, "UTF-8"));
            ZiId commonId = this.factory.simple("openidconsumer", ((UOWHost)uow.trait(UOWHost.class)).host, "op", userid + "/" + eou);
            this.logger.info("Saving association for " + opUrl + " and " + handle + " in " + uniqueId);
            final ArrayList errs = new ArrayList();
            final CountDownLatch cdl = new CountDownLatch(2);
            TDACreateHandler handler = new TDACreateHandler(){

                public void success() {
                    cdl.countDown();
                }

                public void error(Throwable ex) {
                    errs.add(ex);
                    cdl.countDown();
                }

                public void alreadyExists() {
                    errs.add(new RuntimeException("already exists"));
                    cdl.countDown();
                }
            };
            this.storage.create((UnitOfWork)uow, uniqueId.toString(), (Object)this.makeCA((FLEvalContext)uow, opUrl, assoc, handle, eou), this.storage.expireAt(assoc.getExpiry()), handler);
            this.storage.create((UnitOfWork)uow, commonId.toString(), (Object)this.makeCA((FLEvalContext)uow, opUrl, assoc, handle, eou), this.storage.expireAt(assoc.getExpiry()), handler);
            try {
                if (!cdl.await(5L, TimeUnit.SECONDS)) {
                    throw new TimeoutException();
                }
            }
            catch (Exception ex) {
                this.logger.error("timed out waiting to create an association");
                throw WrappedException.wrap((Throwable)ex);
            }
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("error", (Throwable)e);
        }
    }

    private ConsumerAssociation makeCA(FLEvalContext cx, String opUrl, Association assoc, String handle, String eou) {
        JVMConsumerAssociation ca = new JVMConsumerAssociation(cx);
        ca.setOpUrl(eou);
        ca.setHandle(handle);
        if (assoc.getType() != null) {
            ca.setType(assoc.getType());
        }
        ca.setExpiry(assoc.getExpiry());
        if (handle.equals(" ")) {
            this.logger.warn("Association failed for " + opUrl + " and " + eou + " with " + handle);
            ca.setMacKey("<none>");
        } else {
            ca.setMacKey(StringUtil.hex((byte[])assoc.getMacKey().getEncoded()));
        }
        return ca;
    }

    public Association load(String opUrl) {
        return this.load(opUrl, null);
    }

    public synchronized Association load(String opUrl, String handle) {
        try {
            UnitOfWork cx = this.txmanager.currentUOW();
            Relation r = this.relationProvider.getRelation();
            String userid = (String)cx.read(r, "userid");
            this.logger.info("have userid = " + userid);
            String eou = URLEncoder.encode(opUrl, "UTF-8");
            final ZiId id = handle == null ? this.factory.simple("openidconsumer", ((UOWHost)cx.trait(UOWHost.class)).host, "op", userid + "/" + eou) : this.factory.simple("openidconsumer", ((UOWHost)cx.trait(UOWHost.class)).host, "unique", userid + "/" + eou + "/" + URLEncoder.encode(handle, "UTF-8"));
            this.logger.info("Attempting to load " + id + " for " + opUrl + " and " + handle);
            final CompletableFuture ret = new CompletableFuture();
            this.storage.retrieve(cx, id.toString(), new TDARetrieveHandler(){

                public void notfound() {
                    GLSAssociationStore.this.logger.info("did not find " + id);
                    ret.complete(null);
                }

                public <T> void found(RetrievedObject<T> retrieved) {
                    GLSAssociationStore.this.logger.info("found " + id + " completing " + ret);
                    ret.complete(GLSAssociationStore.this.makeAssociation((ConsumerAssociation)retrieved.object()));
                }

                public void error(Throwable ex) {
                    GLSAssociationStore.this.logger.error("error retrieving association", ex);
                    ret.completeExceptionally(ex);
                }
            });
            this.logger.info("Blocking on " + ret + " to allow storage to be async but openid not");
            Association assoc = (Association)ret.get(5L, TimeUnit.SECONDS);
            if (assoc == null) {
                this.logger.info("No association found for " + opUrl + " and " + handle);
            } else {
                this.logger.info("Returning Association[" + assoc.getHandle() + "] for " + opUrl + " and " + handle);
            }
            return assoc;
        }
        catch (UnsupportedEncodingException | InterruptedException | ExecutionException | TimeoutException e) {
            this.logger.error("error", (Throwable)e);
            return null;
        }
    }

    private Association makeAssociation(ConsumerAssociation ca) {
        if (ca == null) {
            return null;
        }
        String type = ca.getType();
        this.logger.info("make association called with " + ca + "; type = " + type);
        if (type.equals("HMAC-SHA256")) {
            return Association.createHmacSha256((String)ca.getHandle(), (byte[])StringUtil.fromHex((String)ca.getMacKey()), (int)((int)(ca.getExpiry().getTime() - new Date().getTime())));
        }
        this.logger.info("Cannot reconstitute association of type " + type);
        return null;
    }

    public void remove(String opUrl, String handle) {
        try {
            UnitOfWork uow = this.txmanager.currentUOW();
            Relation r = this.relationProvider.getRelation();
            String userid = (String)uow.read(r, "userid");
            this.logger.info("have userid = " + userid);
            String eou = URLEncoder.encode(opUrl, "UTF-8");
            final ZiId id = handle == null ? this.factory.simple("openidconsumer", ((UOWHost)uow.trait(UOWHost.class)).host, "op", userid + "/" + eou) : this.factory.simple("openidconsumer", ((UOWHost)uow.trait(UOWHost.class)).host, "unique", userid + "/" + eou + "/" + URLEncoder.encode(handle, "UTF-8"));
            this.logger.info("Removing association for " + opUrl + " and " + handle);
            final CountDownLatch cdl = new CountDownLatch(1);
            this.storage.delete(uow, id.toString(), new TDADeleteHandler(){

                public void success() {
                    cdl.countDown();
                }

                public void error(Throwable ex) {
                    GLSAssociationStore.this.logger.error("error deleting " + id);
                    cdl.countDown();
                }
            });
            cdl.await(5L, TimeUnit.SECONDS);
        }
        catch (UnsupportedEncodingException | InterruptedException e) {
            this.logger.error("error", (Throwable)e);
        }
    }
}

