/*
 * Decompiled with CFR 0.152.
 */
package org.ziniki.openid.id;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.server.tda.RequestMethod;
import org.ziniki.servlet.tda.ParameterSource;
import org.ziniki.servlet.tda.RequestPathParameters;
import org.ziniki.servlet.tda.RequestProcessor;
import org.ziniki.servlet.tda.Responder;
import org.ziniki.ziwsh.intf.Param;
import org.zinutils.exceptions.NotImplementedException;

public class IDProvider
implements RequestProcessor,
RequestMethod,
RequestPathParameters {
    private final Logger logger = LoggerFactory.getLogger((String)"IDProvider");
    private String authurl;
    private boolean validMethod;
    private String userName;
    private boolean isGet;

    public IDProvider(@Param(value="authURL") String authUrl) {
        this.authurl = authUrl;
    }

    public void requestMethod(String methodName) {
        this.isGet = "GET".equals(methodName);
        this.validMethod = this.isGet || "HEAD".equals(methodName);
    }

    public void stringValue(String name, String value, ParameterSource source) {
        if (name.equals("user")) {
            this.userName = value;
        }
    }

    public void process(Responder r) throws Exception {
        if (!this.validMethod) {
            r.setStatus(405);
            return;
        }
        if (this.userName != null) {
            this.logger.info("providing id url for " + this.userName + ": " + this.authurl);
        } else {
            this.logger.info("providing generic id url: " + this.authurl);
        }
        r.setContentType("text/html");
        if (this.isGet) {
            r.write("<html><head><link rel='openid2.provider' href='" + this.authurl + "'></head></html>", null);
        }
    }

    public void hasSegment(String segment) {
        throw new NotImplementedException();
    }

    public void integerValue(String name, int value, ParameterSource source) {
        throw new NotImplementedException();
    }

    public void doubleValue(String name, double value, ParameterSource source) {
        throw new NotImplementedException();
    }
}

