/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.support;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.transactions.TransactionDurabilityLevel;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.support.SpanWrapper;
import java.util.HashMap;
import java.util.Map;

public class OptionsWrapperUtil {
    private OptionsWrapperUtil() {
    }

    public static RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn) {
        opts.timeout(config.keyValueTimeout());
        if (perTxn.durabilityLevel().isPresent()) {
            DurabilityLevel dl = OptionsWrapperUtil.convert(perTxn.durabilityLevel().get());
            opts.durability(dl);
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static RemoveOptions wrap(RemoveOptions opts, SpanWrapper pspan, TransactionConfig config) {
        opts.timeout(config.keyValueTimeout());
        if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn) {
        opts.timeout(config.keyValueTimeout());
        if (perTxn.durabilityLevel().isPresent()) {
            DurabilityLevel dl = OptionsWrapperUtil.convert(perTxn.durabilityLevel().get());
            opts.durability(dl);
        } else if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    public static MutateInOptions wrap(MutateInOptions opts, SpanWrapper pspan, TransactionConfig config) {
        opts.timeout(config.keyValueTimeout());
        if (config.transactionDurabilityLevel() != TransactionDurabilityLevel.NONE) {
            opts.durability(config.durabilityLevel());
        }
        return opts;
    }

    private static DurabilityLevel convert(TransactionDurabilityLevel dl) {
        switch (dl) {
            case MAJORITY: {
                return DurabilityLevel.MAJORITY;
            }
            case PERSIST_TO_MAJORITY: {
                return DurabilityLevel.PERSIST_TO_MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
        }
        return DurabilityLevel.NONE;
    }

    public static MutateInOptions wrap(SpanWrapper pspan, TransactionConfig config, PerTransactionConfig perTxn) {
        return OptionsWrapperUtil.wrap(MutateInOptions.mutateInOptions(), pspan, config, perTxn);
    }

    public static Map<String, Object> createClientContext(String op) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("txn.op", op);
        return map;
    }
}

