/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.transactions.cleanup.ClientRecordDetails;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.log.TransactionEvent;
import java.time.Duration;

@Stability.Volatile
public class TransactionCleanupStartRunEvent
extends TransactionEvent {
    private final String bucketName;
    private final String collectionName;
    private final String clientId;
    private final ClientRecordDetails clientDetails;
    private final Duration cleanupWindow;
    private final int atrsToCheckInNextWindow;
    private final int totalAtrs;
    private final Duration checkAtrEvery;

    @Stability.Volatile
    public TransactionCleanupStartRunEvent(String bucketName, String collectionName, String clientUuid, ClientRecordDetails clientDetails, Duration cleanupWindow, int atrsToCheckInNextWindow, int totalAtrs, Duration checkAtrEvery) {
        super(Event.Severity.DEBUG, TransactionsCleanup.CATEGORY_STATS);
        this.bucketName = bucketName;
        this.collectionName = collectionName;
        this.clientId = clientUuid;
        this.clientDetails = clientDetails;
        this.cleanupWindow = cleanupWindow;
        this.atrsToCheckInNextWindow = atrsToCheckInNextWindow;
        this.totalAtrs = totalAtrs;
        this.checkAtrEvery = checkAtrEvery;
    }

    @Stability.Volatile
    public int clientIndex() {
        return this.clientDetails.indexOfThisClient();
    }

    @Stability.Volatile
    public int totalActiveClients() {
        return this.clientDetails.numActiveClients();
    }

    @Stability.Volatile
    public Duration cleanupWindow() {
        return this.cleanupWindow;
    }

    @Stability.Volatile
    public int atrsToCheckInNextWindow() {
        return this.atrsToCheckInNextWindow;
    }

    @Stability.Volatile
    public int totalAtrs() {
        return this.totalAtrs;
    }

    @Stability.Volatile
    public Duration checkAtrEvery() {
        return this.checkAtrEvery;
    }

    @Stability.Volatile
    public String bucketName() {
        return this.bucketName;
    }

    @Stability.Volatile
    public String collectionName() {
        return this.collectionName;
    }

    @Stability.Volatile
    public String clientUuid() {
        return this.clientId;
    }

    public String description() {
        StringBuilder sb = new StringBuilder(200);
        sb.append(this.bucketName);
        sb.append('/');
        sb.append(this.collectionName);
        sb.append("/clientId=");
        sb.append(this.clientId.substring(0, 5));
        sb.append(",index=");
        sb.append(this.clientDetails.indexOfThisClient());
        sb.append(",numClients=");
        sb.append(this.clientDetails.numActiveClients());
        sb.append(",ATRs={checking=");
        sb.append(this.atrsToCheckInNextWindow);
        sb.append(",total=");
        sb.append(this.totalAtrs);
        sb.append("},runLength=");
        sb.append(this.cleanupWindow.toMillis());
        sb.append("millis");
        return sb.toString();
    }

    @Override
    public boolean success() {
        return true;
    }
}

