/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.log;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.log.PersistedLogWriter;
import com.couchbase.transactions.log.SimpleEventBusLogger;
import com.couchbase.transactions.log.TransactionEvent;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;

@Stability.Internal
public class EventBusPersistedLogger
implements Consumer<Event>,
Runnable {
    private final PersistedLogWriter log;
    private final TransactionConfig config;
    private final Thread thread;
    private final ArrayBlockingQueue<TransactionEvent> queue = new ArrayBlockingQueue(2048);
    private final SimpleEventBusLogger eventBusLogger;

    public EventBusPersistedLogger(EventBus eventBus, PersistedLogWriter log, TransactionConfig config) {
        this.log = log;
        this.config = config;
        this.eventBusLogger = new SimpleEventBusLogger(eventBus);
        eventBus.subscribe((Consumer)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void accept(Event event) {
        try {
            if (event instanceof TransactionEvent) {
                this.queue.add((TransactionEvent)event);
            }
        }
        catch (RuntimeException err) {
            this.eventBusLogger.debug("Failed to add event bus log event: " + err.toString());
        }
    }

    @Override
    public void run() {
        Long last = System.currentTimeMillis();
        int statsEventsWritten = 0;
        long statsTotalTimeMillis = 0L;
        long statsMaxTimeMillis = 0L;
        while (true) {
            try {
                while (true) {
                    TransactionEvent event = this.queue.take();
                    Long now = System.currentTimeMillis();
                    if (!event.success()) {
                        String uuid = "[" + UUID.randomUUID().toString().substring(0, 5) + "] ";
                        this.log.write("", uuid + event.description()).block();
                        event.logs().forEach(l -> this.log.write("", uuid + l.toString()));
                    } else {
                        this.log.write("", event.description()).block();
                    }
                    long timeToLog = System.currentTimeMillis() - now;
                    statsTotalTimeMillis += timeToLog;
                    ++statsEventsWritten;
                    if (timeToLog > statsMaxTimeMillis) {
                        statsMaxTimeMillis = timeToLog;
                    }
                    if (now - last <= 60000L) continue;
                    long timePerEvent = statsEventsWritten > 0 ? statsTotalTimeMillis / (long)statsEventsWritten : 0L;
                    this.log.write("", String.format("Event bus logger stats for last 60 seconds: events=%d, avg time to log event=%d millis, max time for event=%d millis", statsEventsWritten, timePerEvent, statsMaxTimeMillis));
                    statsEventsWritten = 0;
                    statsTotalTimeMillis = 0L;
                    statsMaxTimeMillis = 0L;
                }
            }
            catch (InterruptedException e) {
                this.eventBusLogger.debug("Failed to read event bus queue: " + e.toString());
                continue;
            }
            break;
        }
    }
}

