/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.error.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DurabilityAmbiguousException;
import com.couchbase.client.core.error.DurableWriteInProgressException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.TemporaryFailureException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.TransactionResult;
import com.couchbase.transactions.error.attempts.AttemptException;
import com.couchbase.transactions.error.attempts.AttemptExceptionNeedsRetry;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollback;
import com.couchbase.transactions.error.internal.AbortedAsRequestedNoRollbackNoCleanup;
import com.couchbase.transactions.error.internal.AttemptWrappedExceptionNoRetry;

@Stability.Internal
public class AttemptWrappedExceptionNeedsRetry
extends AttemptExceptionNeedsRetry {
    private final Throwable wrapped;

    public AttemptWrappedExceptionNeedsRetry(AttemptContextReactive ctx, Throwable wrapped) {
        super(ctx);
        this.wrapped = wrapped;
    }

    public AttemptWrappedExceptionNeedsRetry(AttemptContextReactive ctx, String err, Throwable wrapped) {
        super(ctx, err);
        this.wrapped = wrapped;
    }

    public Throwable wrapped() {
        return this.wrapped;
    }

    @Override
    public String toString() {
        return "TransactionWrappedExceptionNeedsRetry(" + this.wrapped + ")";
    }

    public static RuntimeException wrapIfNeeded(Throwable e, AttemptContextReactive ctx, TransactionResult result) {
        if (!(e instanceof AttemptException)) {
            if (!(e instanceof DurabilityAmbiguousException || e instanceof CasMismatchException || e instanceof TimeoutException || e instanceof RequestCanceledException || e instanceof TemporaryFailureException || e instanceof DurableWriteInProgressException)) {
                AttemptWrappedExceptionNoRetry out = new AttemptWrappedExceptionNoRetry(ctx, e);
                if (e instanceof AbortedAsRequestedNoRollback || e instanceof AbortedAsRequestedNoRollbackNoCleanup || e instanceof AssertionError) {
                    out.shouldRollback(false);
                }
                if (e instanceof AbortedAsRequestedNoRollbackNoCleanup) {
                    out.shouldAddCleanupRequest(false);
                }
                ctx.logger().info(ctx.attemptId(), "exception %s should not be retried, wrapping in AttemptWrappedExceptionNoRetry, rollback=%s", e.getClass().getSimpleName(), out.shouldRollback());
                return out;
            }
            AttemptWrappedExceptionNeedsRetry out = new AttemptWrappedExceptionNeedsRetry(ctx, e);
            ctx.logger().info(ctx.attemptId(), "exception %s needs to be wrapped as AttemptWrappedExceptionNeedsRetry", e.getClass().getSimpleName());
            return out;
        }
        return (AttemptException)e;
    }
}

