/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.components;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.TransactionJsonDocumentStatus;
import com.couchbase.transactions.components.ATR;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.Mono;

@Stability.Internal
public class DocumentGetter {
    private DocumentGetter() {
    }

    public static Mono<Optional<TransactionGetResult>> getAsync(ReactiveCollection collection, TransactionConfig config, String docId, String byAttemptId, SpanWrapper span, Transcoder transcoder) {
        return DocumentGetter.getAsync(collection, config, docId, byAttemptId, false, span, transcoder);
    }

    public static Mono<Optional<TransactionGetResult>> getAsync(ReactiveCollection collection, TransactionConfig config, String docId, String byAttemptId, boolean justReturn, SpanWrapper span, Transcoder transcoder) {
        return DocumentGetter.justGetDoc(collection, config, docId, span, transcoder).flatMap(origTrans -> {
            if (justReturn) {
                return Mono.just((Object)origTrans);
            }
            if (origTrans.isPresent()) {
                if (!((TransactionGetResult)origTrans.get()).links().isDocumentInTransaction()) {
                    return Mono.just((Object)origTrans);
                }
                return DocumentGetter.lookupStatusFromATR(collection, (TransactionGetResult)origTrans.get(), byAttemptId, config.keyValueTimeout(), config, span);
            }
            return Mono.just((Object)origTrans);
        });
    }

    public static Mono<Optional<TransactionGetResult>> justGetDoc(ReactiveCollection collection, TransactionConfig config, String docId, SpanWrapper span, Transcoder transcoder) {
        return collection.lookupIn(docId, Arrays.asList(LookupInSpec.get((String)"txn.atr.id").xattr(), LookupInSpec.get((String)"txn.id.txn").xattr(), LookupInSpec.get((String)"txn.id.atmpt").xattr(), LookupInSpec.get((String)"txn.op.stgd").xattr(), LookupInSpec.get((String)"txn.atr.bkt").xattr(), LookupInSpec.get((String)"txn.atr.coll").xattr(), LookupInSpec.get((String)"txn.restore").xattr(), LookupInSpec.get((String)"txn.op.type").xattr(), LookupInSpec.get((String)"$document").xattr(), LookupInSpec.get((String)"")), (LookupInOptions)((LookupInOptions)LookupInOptions.lookupInOptions().clientContext(OptionsWrapperUtil.createClientContext("DocumentGetter::justGetDoc"))).timeout(config.keyValueTimeout())).map(fragment -> Optional.of(TransactionGetResult.createFrom(collection, docId, fragment, TransactionJsonDocumentStatus.NORMAL, transcoder))).onErrorResume(err -> {
            if (err instanceof DocumentNotFoundException) {
                return Mono.just(Optional.empty());
            }
            return Mono.error((Throwable)err);
        });
    }

    private static Mono<Optional<TransactionGetResult>> lookupStatusFromATR(ReactiveCollection collection, TransactionGetResult doc, String byAttemptId, Duration timeout, TransactionConfig config, SpanWrapper span) {
        return ActiveTransactionRecord.getAtr(collection, doc.links().atrId().get(), timeout, config, span).flatMap(atrDocOpt -> {
            if (!atrDocOpt.isPresent()) {
                return DocumentGetter.atrNotFound(doc);
            }
            return DocumentGetter.atrFound(doc, byAttemptId, atrDocOpt);
        });
    }

    private static Mono<Optional<TransactionGetResult>> atrFound(TransactionGetResult doc, String byAttemptId, Optional<ATR> atrDocOpt) {
        ATR atrDoc = atrDocOpt.get();
        Optional<ATREntry> entryOpt = atrDoc.entries().stream().filter(v -> v.attemptId().equals(doc.links().stagedAttemptId().get())).findFirst();
        AtomicReference<Boolean> ignoreDoc = new AtomicReference<Boolean>(false);
        byte[] data = doc.contentAsObject().toString().getBytes(StandardCharsets.UTF_8);
        AtomicReference<byte[]> content = new AtomicReference<byte[]>(data);
        AtomicReference<TransactionJsonDocumentStatus> status = new AtomicReference<TransactionJsonDocumentStatus>(doc.status());
        entryOpt.ifPresent(entry -> {
            if (doc.links().stagedAttemptId().isPresent() && entry.attemptId().equals(byAttemptId)) {
                content.set(doc.links().stagedContent().get().getBytes(StandardCharsets.UTF_8));
                status.set(TransactionJsonDocumentStatus.OWN_WRITE);
            } else {
                switch (entry.state()) {
                    case COMMITTED: {
                        if (doc.links().isDocumentBeingRemoved()) {
                            ignoreDoc.set(true);
                            break;
                        }
                        content.set(doc.links().stagedContent().get().getBytes(StandardCharsets.UTF_8));
                        status.set(TransactionJsonDocumentStatus.IN_TXN_COMMITTED);
                        break;
                    }
                    default: {
                        status.set(TransactionJsonDocumentStatus.IN_TXN_OTHER);
                        if (!doc.contentAs(JsonObject.class).isEmpty()) break;
                        ignoreDoc.set(true);
                    }
                }
            }
        });
        if (!entryOpt.isPresent()) {
            status.set(TransactionJsonDocumentStatus.AMBIGUOUS);
            if (doc.contentAs(JsonObject.class).isEmpty()) {
                ignoreDoc.set(true);
            }
        }
        if (ignoreDoc.get().booleanValue()) {
            return Mono.just(Optional.empty());
        }
        return Mono.just(Optional.of(TransactionGetResult.createFrom(doc, content.get(), status.get())));
    }

    private static Mono<Optional<TransactionGetResult>> atrNotFound(TransactionGetResult doc) {
        if (doc.contentAs(JsonObject.class).isEmpty()) {
            return Mono.just(Optional.empty());
        }
        doc.status(TransactionJsonDocumentStatus.AMBIGUOUS);
        return Mono.just(Optional.of(doc));
    }

    public static Optional<TransactionGetResult> get(Collection collection, String docId, TransactionConfig config, SpanWrapper span, Transcoder transcoder) {
        return (Optional)DocumentGetter.getAsync(collection.reactive(), config, docId, null, span, transcoder).block();
    }
}

