/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.java.ReactiveCollection;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

@Stability.Internal
public class CleanupRequest
implements Delayed {
    private final String attemptId;
    private final String atrId;
    private final ReactiveCollection atrCollection;
    private final Duration startTime;
    private final boolean checkIfExpired;

    public CleanupRequest(String attemptId, String atrId, ReactiveCollection atrCollection, Duration delay, boolean checkIfExpired) {
        Objects.requireNonNull(attemptId);
        Objects.requireNonNull(atrId);
        Objects.requireNonNull(atrCollection);
        this.attemptId = attemptId;
        this.atrId = atrId;
        this.atrCollection = atrCollection;
        this.startTime = Duration.of(System.nanoTime(), ChronoUnit.NANOS).plus(delay);
        this.checkIfExpired = checkIfExpired;
    }

    public String attemptId() {
        return this.attemptId;
    }

    public String atrId() {
        return this.atrId;
    }

    public ReactiveCollection atrCollection() {
        return this.atrCollection;
    }

    public boolean checkIfExpired() {
        return this.checkIfExpired;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        Duration diff = this.startTime.minus(Duration.of(System.nanoTime(), ChronoUnit.NANOS));
        return diff.toNanos();
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof CleanupRequest) {
            return Long.compare(this.startTime.toNanos(), ((CleanupRequest)o).startTime.toNanos());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CleanupRequest(");
        sb.append("atrId=");
        sb.append(this.atrId);
        sb.append(",attemptId=");
        sb.append(this.attemptId);
        sb.append(",checkIfExpired=");
        sb.append(this.checkIfExpired);
        sb.append(")");
        return sb.toString();
    }
}

