/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.transactions.TransactionGetResult;
import com.couchbase.transactions.cleanup.CleanupRequest;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.components.ATR;
import com.couchbase.transactions.components.ATREntry;
import com.couchbase.transactions.components.ATRUtil;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.components.DocRecord;
import com.couchbase.transactions.components.DocumentGetter;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.log.SimpleEventBusLogger;
import com.couchbase.transactions.log.TransactionCleanupAttempt;
import com.couchbase.transactions.log.TransactionLogger;
import com.couchbase.transactions.support.OptionsWrapperUtil;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public class Cleaner {
    private final TransactionConfig config;
    private final ClusterData clusterData;
    private final SimpleEventBusLogger LOGGER;
    private final EventBus eventBus;
    private static final Duration TIME_BEFORE_REHANDLING_FAILED_CLEANUP_DEFAULT = Duration.ofSeconds(10L);
    protected Optional<Duration> timeBeforeRehandlingFailedCleanupDefault = Optional.empty();

    public Cleaner(TransactionConfig config, ClusterData clusterData) {
        this.eventBus = clusterData.cluster().environment().eventBus();
        this.LOGGER = new SimpleEventBusLogger(this.eventBus, TransactionsCleanup.CATEGORY + ".cleaner");
        this.config = config;
        this.clusterData = clusterData;
    }

    private Transcoder getTranscoder() {
        return this.clusterData.cluster().environment().transcoder();
    }

    public Duration timeBeforeRehandlingFailedCleanup() {
        return this.timeBeforeRehandlingFailedCleanupDefault.orElse(TIME_BEFORE_REHANDLING_FAILED_CLEANUP_DEFAULT);
    }

    Mono<Void> cleanupDocs(TransactionLogger perEntryLog, ATREntry atrEntry, SpanWrapper pspan) {
        String attemptId = atrEntry.attemptId();
        switch (atrEntry.state()) {
            case COMMITTED: {
                Mono<Void> inserts = this.commitDocs(perEntryLog, attemptId, atrEntry.insertedIds(), pspan);
                Mono<Void> replaces = this.commitDocs(perEntryLog, attemptId, atrEntry.replacedIds(), pspan);
                Mono<Void> removes = this.removeDocsStagedForRemoval(perEntryLog, attemptId, atrEntry.removedIds(), pspan);
                return inserts.then(replaces).then(removes);
            }
            case ABORTED: {
                Mono<Void> inserts = this.removeDocs(perEntryLog, attemptId, atrEntry.insertedIds(), pspan);
                Mono<Void> replaces = this.removeTxnLinks(perEntryLog, attemptId, atrEntry.replacedIds(), pspan);
                Mono<Void> removes = this.removeTxnLinks(perEntryLog, attemptId, atrEntry.removedIds(), pspan);
                return inserts.then(replaces).then(removes);
            }
            case PENDING: {
                perEntryLog.logDefer(atrEntry.attemptId(), "No docs cleanup possible as txn in state %s, just removing", Event.Severity.DEBUG, new Object[]{atrEntry.state()});
                return Mono.empty();
            }
        }
        perEntryLog.logDefer(atrEntry.attemptId(), "No docs cleanup to do as txn in state %s, just removing", Event.Severity.DEBUG, new Object[]{atrEntry.state()});
        return Mono.empty();
    }

    private Mono<Void> commitDocs(TransactionLogger perEntryLog, String attemptId, Optional<List<DocRecord>> docs, SpanWrapper pspan) {
        return this.doPerDoc(perEntryLog, attemptId, docs, pspan, (bucket, doc) -> {
            if (doc.links().stagedContent().isPresent()) {
                JsonObject content = JsonObject.fromJson((String)doc.links().stagedContent().get());
                return this.beforeCommitDoc(doc.id()).then(bucket.mutateIn(doc.id(), Arrays.asList(MutateInSpec.upsert((String)"txn", null).xattr(), MutateInSpec.remove((String)"txn").xattr(), MutateInSpec.replace((String)"", (Object)content)), OptionsWrapperUtil.wrap(((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("Cleaner::commitDocs"))).cas(doc.cas()), pspan, this.config))).doOnSubscribe(v -> perEntryLog.logDefer(attemptId, "removing txn links and writing content to doc %s", Event.Severity.DEBUG, RedactableArgument.redactUser((Object)doc.id()))).then();
            }
            return Mono.create(v -> {
                perEntryLog.debug(attemptId, "doc %s does not have expected staged data, assuming it was committed and skipping", RedactableArgument.redactUser((Object)doc.id()));
                v.success();
            });
        });
    }

    private Mono<Void> removeTxnLinks(TransactionLogger perEntryLog, String attemptId, Optional<List<DocRecord>> docs, SpanWrapper pspan) {
        return this.doPerDoc(perEntryLog, attemptId, docs, pspan, (bucket, doc) -> this.beforeRemoveLinks(doc.id()).then(bucket.mutateIn(doc.id(), Arrays.asList(MutateInSpec.upsert((String)"txn", null).xattr(), MutateInSpec.remove((String)"txn").xattr()), (MutateInOptions)((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("Cleaner::removeTxnLinks"))).cas(doc.cas()).timeout(this.config.keyValueTimeout()))).doOnSubscribe(v -> perEntryLog.logDefer(attemptId, "removing txn links from doc %s", Event.Severity.DEBUG, RedactableArgument.redactUser((Object)doc.id()))).then());
    }

    private Mono<Void> removeDocsStagedForRemoval(TransactionLogger perEntryLog, String attemptId, Optional<List<DocRecord>> docs, SpanWrapper pspan) {
        return this.doPerDoc(perEntryLog, attemptId, docs, pspan, (collection, doc) -> {
            if (doc.links().stagedContent().isPresent() && doc.links().stagedContent().get().equals("<<REMOVE>>")) {
                return this.beforeRemoveDocStagedForRemoval(doc.id()).then(collection.remove(doc.id(), (RemoveOptions)RemoveOptions.removeOptions().timeout(this.config.keyValueTimeout()))).doOnSubscribe(v -> perEntryLog.debug(attemptId, "removing doc %s", doc.id())).then();
            }
            return Mono.create(v -> {
                perEntryLog.debug(attemptId, "doc %s does not have expected remove indication, skipping", RedactableArgument.redactUser((Object)doc.id()));
                v.success();
            });
        });
    }

    private Mono<Void> removeDocs(TransactionLogger perEntryLog, String attemptId, Optional<List<DocRecord>> docs, SpanWrapper pspan) {
        return this.doPerDoc(perEntryLog, attemptId, docs, pspan, (collection, doc) -> this.beforeRemoveDoc(doc.id()).then(collection.remove(doc.id(), OptionsWrapperUtil.wrap(RemoveOptions.removeOptions(), pspan, this.config)).doOnSubscribe(v -> perEntryLog.debug(attemptId, "removing doc %s", RedactableArgument.redactUser((Object)doc.id()))).then()));
    }

    private Mono<Void> doPerDoc(TransactionLogger perEntryLog, String attemptId, Optional<List<DocRecord>> docs, SpanWrapper pspan, BiFunction<ReactiveCollection, TransactionGetResult, Mono<Void>> perDoc) {
        return Flux.fromIterable((Iterable)docs.orElse(new ArrayList())).concatMap(docRecord -> this.clusterData.getBucketDefaultCollection(docRecord.bucketName()).flatMap(collection -> this.beforeDocGet(docRecord.id()).thenReturn(collection)).flatMap(collection -> DocumentGetter.justGetDoc(collection, this.config, docRecord.id(), pspan, this.getTranscoder()).flatMap(docOpt -> {
            if (docOpt.isPresent()) {
                TransactionGetResult doc = (TransactionGetResult)docOpt.get();
                perEntryLog.debug(attemptId, "handling doc %s on collection %s with cas %d and links %s", RedactableArgument.redactUser((Object)doc.id()), collection.name(), doc.cas(), doc.links());
                if (!doc.links().stagedContent().isPresent() || !doc.links().stagedAttemptId().isPresent()) {
                    perEntryLog.debug(attemptId, "no staged content for doc %s, assuming it was committed and skipping", RedactableArgument.redactUser((Object)doc.id()));
                    return Mono.empty();
                }
                if (!doc.links().stagedAttemptId().get().equals(attemptId)) {
                    perEntryLog.debug(attemptId, "for doc %s, staged version is for a different attempt %s, skipping", RedactableArgument.redactUser((Object)doc.id()), doc.links().stagedAttemptId().get());
                    return Mono.empty();
                }
                return (Mono)perDoc.apply((ReactiveCollection)collection, doc);
            }
            perEntryLog.debug(attemptId, "could not get doc %s, skipping", RedactableArgument.redactUser((Object)docRecord.id()));
            return Mono.empty();
        }).onErrorResume(err -> {
            if (err instanceof CasMismatchException) {
                perEntryLog.debug(attemptId, "got CAS mismatch while cleaning up doc %s, skipping to avoid potential data loss", RedactableArgument.redactUser((Object)docRecord.id()));
                return Mono.empty();
            }
            if (err instanceof DocumentNotFoundException) {
                perEntryLog.debug(attemptId, "got DocumentNotFoundException while cleaning up doc %s, ignoring", RedactableArgument.redactUser((Object)docRecord.id()));
                return Mono.empty();
            }
            perEntryLog.debug(attemptId, "got exception %s while handling doc %s", err.getClass().getSimpleName(), RedactableArgument.redactUser((Object)docRecord.id()));
            return Mono.error((Throwable)err);
        }))).then();
    }

    public Mono<TransactionCleanupAttempt> cleanupATREntry(ReactiveCollection atrCollection, String atrId, String attemptId, ATREntry atrEntry, boolean isRegularCleanup) {
        SpanWrapper span = SpanWrapper.create(this.config, "transaction_atr_cleanup");
        return Mono.defer(() -> {
            TransactionLogger perEntryLog = new TransactionLogger(this.clusterData.cluster().environment().eventBus(), ATRUtil.getAtrDebug(atrCollection, atrId), false, Event.Severity.INFO);
            Event.Severity logLevel = Event.Severity.DEBUG;
            perEntryLog.logDefer(attemptId, "Cleaning up ATR entry (isRegular=%s) %s", logLevel, isRegularCleanup, atrEntry);
            Mono<Void> cleanupDocs = this.cleanupDocs(perEntryLog, atrEntry, span);
            Mono<Object> cleanupEntry = this.removeATREntry(atrCollection, atrId, attemptId, perEntryLog, span);
            return cleanupDocs.doOnSuccess(v -> this.onCleanupDocsCompleted()).then(cleanupEntry).map(v -> {
                this.onCleanupCompleted();
                TransactionCleanupAttempt event = new TransactionCleanupAttempt(Event.Severity.DEBUG, true, isRegularCleanup, perEntryLog.logs(), attemptId, atrId, atrCollection.bucketName(), atrEntry);
                this.eventBus.publish((Event)event);
                return event;
            }).onErrorResume(err -> {
                perEntryLog.logDefer(attemptId, "error while attempting to cleanup ATR entry %s, aborting, lost txn cleanup process will retry later: '%s'", Event.Severity.WARN, ATRUtil.getAtrDebug(atrCollection, atrId), err);
                TransactionCleanupAttempt event = new TransactionCleanupAttempt(Event.Severity.DEBUG, false, isRegularCleanup, perEntryLog.logs(), attemptId, atrId, atrCollection.bucketName(), atrEntry);
                this.eventBus.publish((Event)event);
                return Mono.just((Object)((Object)event));
            }).doOnSubscribe(v -> span.start()).doFinally(v -> span.finish());
        });
    }

    Mono<Object> removeATREntry(ReactiveCollection atrCollection, String atrId, String attemptId, TransactionLogger perEntryLog, SpanWrapper pspan) {
        return this.beforeAtrRemove().then(atrCollection.mutateIn(atrId, Arrays.asList(MutateInSpec.remove((String)("attempts." + attemptId)).xattr()), OptionsWrapperUtil.wrap((MutateInOptions)MutateInOptions.mutateInOptions().clientContext(OptionsWrapperUtil.createClientContext("Cleaner::removeATREntry")), pspan, this.config))).doOnNext(v -> perEntryLog.debug(attemptId, "successfully removed ATR entry")).onErrorResume(err -> {
            if (err instanceof PathNotFoundException) {
                perEntryLog.logDefer(attemptId, "failed to remove %s as entry isn't there, ignoring as likely due to concurrent cleanup", Event.Severity.DEBUG, ATRUtil.getAtrDebug(atrCollection, atrId));
                return Mono.empty();
            }
            return Mono.error((Throwable)err);
        }).map(v -> v);
    }

    public Mono<TransactionCleanupAttempt> handleCleanupRequest(CleanupRequest request, SpanWrapper pspan) {
        return Mono.defer(() -> {
            ReactiveCollection collection = request.atrCollection();
            String bp = ATRUtil.getAtrDebug(collection, request.atrId());
            Mono<Optional<ATR>> first = request.checkIfExpired() ? ActiveTransactionRecord.getAndTouchAtr(collection, request.atrId(), this.config.keyValueTimeout(), pspan, this.config) : ActiveTransactionRecord.getAtr(collection, request.atrId(), this.config.keyValueTimeout(), this.config, pspan);
            return this.beforeAtrGet(request.atrId()).then(first.onErrorResume(err -> {
                this.LOGGER.debug(String.format("Got error '%s' while doing explicit cleanup request for ATR %s", err, bp));
                return Mono.error((Throwable)err);
            }).flatMap(v -> {
                if (v.isPresent()) {
                    return Mono.just(v.get());
                }
                this.LOGGER.debug(String.format("Did not find ATR while doing explicit cleanup request for ATR %s", bp));
                return Mono.error((Throwable)new DocumentNotFoundException((ErrorContext)ReducedKeyValueErrorContext.create((String)request.atrId())));
            })).flatMapMany(v -> Flux.fromIterable(v.entries())).filter(atrEntry -> {
                boolean out = atrEntry.attemptId().equals(request.attemptId());
                if (out && request.checkIfExpired()) {
                    int expiresAfterMsecs = atrEntry.expiresAfterMsecs().orElse((int)this.config.transactionExpirationTime().toMillis());
                    boolean hasExpired = atrEntry.hasExpired(atrEntry.cas(), expiresAfterMsecs);
                    this.LOGGER.debug(String.format("Found ATR %s, attempt %s, isExpired = %s", bp, request.attemptId(), hasExpired));
                    out = hasExpired;
                }
                return out;
            }).single().flatMap(atrEntry -> this.cleanupATREntry(collection, request.atrId(), request.attemptId(), (ATREntry)atrEntry, true));
        });
    }

    protected Mono<Integer> beforeCommitDoc(String id) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeDocGet(String id) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeRemoveDocStagedForRemoval(String id) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeRemoveDoc(String id) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeAtrGet(String id) {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeAtrRemove() {
        return Mono.just((Object)1);
    }

    protected Mono<Integer> beforeRemoveLinks(String id) {
        return Mono.just((Object)1);
    }

    void onCleanupDocsCompleted() {
    }

    void onCleanupCompleted() {
    }
}

