/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.cleanup;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.transactions.components.ATREntry;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

@Stability.Internal
public class ATRStats {
    public int numEntries;
    public boolean exists;
    public Optional<Throwable> errored = Optional.empty();
    public Collection<ATREntry> expired = Collections.EMPTY_LIST;
    public AtomicInteger expiredEntryCleanupTotalAttempts = new AtomicInteger(0);
    public AtomicInteger expiredEntryCleanupFailedAttempts = new AtomicInteger(0);

    public Optional<ATREntry> oldest() {
        return this.expired.stream().sorted((f1, f2) -> Long.compare(f2.ageMsecs(), f1.ageMsecs())).findFirst();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.exists) {
            sb.append("stats={entries=");
            sb.append(this.numEntries);
            this.errored.ifPresent(v -> {
                sb.append("error=");
                sb.append(v.getMessage());
            });
            sb.append(",expired=");
            sb.append(this.expired.size());
            sb.append('}');
        } else {
            sb.append("exists=false");
        }
        return sb.toString();
    }
}

