/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions.atr;

import com.couchbase.client.core.annotation.Stability;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.zip.CRC32;

@Stability.Internal
public class ATRIds {
    public static final int NUM_VBUCKETS = 1024;
    public static final int NUM_ATRS_DEFAULT = 1024;
    public static final int MAX_ATR_BLOCKS = 20;
    public static final int MAX_ATRS = 20480;
    private static List<String> ATR_IDS;

    private ATRIds() {
    }

    public static List<String> allAtrs(int numAtrs) {
        return ATR_IDS.stream().limit(numAtrs).collect(Collectors.toList());
    }

    public static List<String> atrIdsForVbucket(int vbucketId, int numAtrs) {
        if (vbucketId < 0) {
            throw new IllegalArgumentException();
        }
        if (vbucketId >= 1024) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> out = new ArrayList<String>();
        for (int i = vbucketId; i < numAtrs; i += 1024) {
            out.add(ATR_IDS.get(i));
        }
        return out;
    }

    public static String randomAtrIdForVbucket(int vbucketId, int numAtrs) {
        List<String> possibilities = ATRIds.atrIdsForVbucket(vbucketId, numAtrs);
        int index = ThreadLocalRandom.current().nextInt(possibilities.size());
        return possibilities.get(index);
    }

    public static int vbucketForKey(String id) {
        return ATRIds.vbucketForKey(id, 1024);
    }

    public static int vbucketForKey(String id, int numPartitions) {
        CRC32 crc32 = new CRC32();
        crc32.update(id.getBytes(StandardCharsets.UTF_8));
        long rv = crc32.getValue() >> 16 & 0x7FFFL;
        return (int)rv & numPartitions - 1;
    }

    static {
        try {
            ArrayList<String> atrIds = new ArrayList<String>();
            try (BufferedReader stream = new BufferedReader(new InputStreamReader(ATRIds.class.getClassLoader().getResourceAsStream("ATRids.txt")));){
                String in;
                while ((in = stream.readLine()) != null) {
                    if (in.startsWith("//")) continue;
                    atrIds.add(in);
                }
            }
            ATR_IDS = Collections.unmodifiableList(atrIds);
        }
        catch (Exception err) {
            System.out.println("Fatal error loading ATR ids, transactions will not operate: " + err);
            err.printStackTrace();
        }
    }
}

