/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.transactions;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.EventBus;
import com.couchbase.client.core.retry.reactor.Jitter;
import com.couchbase.client.core.retry.reactor.Retry;
import com.couchbase.client.java.Cluster;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.transactions.AttemptContext;
import com.couchbase.transactions.AttemptContextReactive;
import com.couchbase.transactions.TransactionAttempt;
import com.couchbase.transactions.TransactionContext;
import com.couchbase.transactions.TransactionResult;
import com.couchbase.transactions.cleanup.CleanupRequest;
import com.couchbase.transactions.cleanup.ClusterData;
import com.couchbase.transactions.cleanup.TransactionsCleanup;
import com.couchbase.transactions.components.ATR;
import com.couchbase.transactions.components.ActiveTransactionRecord;
import com.couchbase.transactions.config.PerTransactionConfig;
import com.couchbase.transactions.config.PerTransactionConfigBuilder;
import com.couchbase.transactions.config.TransactionConfig;
import com.couchbase.transactions.deferred.TransactionSerializedContext;
import com.couchbase.transactions.error.TransactionExpired;
import com.couchbase.transactions.error.TransactionFailed;
import com.couchbase.transactions.error.attempts.AttemptException;
import com.couchbase.transactions.error.attempts.AttemptExceptionNeedsRetry;
import com.couchbase.transactions.error.internal.AttemptExpired;
import com.couchbase.transactions.error.internal.AttemptWrappedExceptionNeedsRetry;
import com.couchbase.transactions.error.internal.AttemptWrappedExceptionNoRetry;
import com.couchbase.transactions.log.EventBusPersistedLogger;
import com.couchbase.transactions.log.PersistedLogWriter;
import com.couchbase.transactions.log.TransactionLogEvent;
import com.couchbase.transactions.support.AttemptContextFactory;
import com.couchbase.transactions.support.SpanWrapper;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class TransactionsReactive {
    static final int MAX_ATTEMPTS = 1000;
    private final TransactionsCleanup cleanup;
    private final TransactionConfig config;
    private AttemptContextFactory attemptContextFactory;
    private EventBusPersistedLogger persistedLogger;

    static TransactionsReactive create(Cluster cluster, TransactionConfig config) {
        return new TransactionsReactive(cluster, config);
    }

    private TransactionsReactive(Cluster cluster, TransactionConfig config) {
        Objects.requireNonNull(cluster);
        Objects.requireNonNull(config);
        ClusterData clusterData = new ClusterData(cluster);
        this.config = config;
        this.attemptContextFactory = config.attemptContextFactory();
        this.cleanup = new TransactionsCleanup(this.config, clusterData);
        config.persistentLoggingCollection().ifPresent(collection -> {
            PersistedLogWriter persistedLogWriter = new PersistedLogWriter((Collection)collection, 100000);
            this.persistedLogger = new EventBusPersistedLogger(cluster.environment().eventBus(), persistedLogWriter, config);
        });
    }

    private Mono<TransactionResult> executeTransaction(TransactionConfig config, TransactionContext overall, Mono<AttemptContextReactive> transactionLogic) {
        AtomicReference<Long> startTime = new AtomicReference<Long>(0L);
        return Mono.just((Object)overall).subscribeOn(Schedulers.elastic()).doOnSubscribe(v -> startTime.set(System.nanoTime())).then(transactionLogic).flatMap(this::executeImplicitCommit).doOnNext(ctx -> this.executeAddAttemptAndCleanupRequest(config, overall, (AttemptContextReactive)ctx)).onErrorResume(err -> this.executeHandleErrorsPreRetry(config, overall, (Throwable)err)).retryWhen(this.executeCreateRetryWhen(overall)).onErrorResume(err -> this.executeHandleErrorsPostRetry(overall, (Throwable)err)).doOnError(err -> {
            if (config.logOnFailure() && !config.logDirectly()) {
                EventBus eventBus = this.cleanup.clusterData().cluster().environment().eventBus();
                overall.LOGGER.logs().forEach(log -> eventBus.publish((Event)new TransactionLogEvent(config.logOnFailureLevel(), TransactionLogEvent.DEFAULT_CATEGORY, log.toString())));
            }
        }).doOnSuccess(v -> overall.LOGGER.info("finished txn in %dms", (System.nanoTime() - (Long)startTime.get()) / 1000000L)).single().map(v -> TransactionsReactive.createResultFromContext(overall)).doFinally(v -> overall.span().ifPresent(SpanWrapper::finish));
    }

    private Retry<Object> executeCreateRetryWhen(TransactionContext overall) {
        return Retry.anyOf((Class[])new Class[]{AttemptExceptionNeedsRetry.class}).exponentialBackoff(Duration.of(10L, ChronoUnit.MILLIS), Duration.of(250L, ChronoUnit.MILLIS)).doOnRetry(v -> overall.LOGGER.info("<>", "retrying on error '%s'", v.exception())).jitter(Jitter.random()).retryMax(1000L);
    }

    private Mono<AttemptContextReactive> executeHandleErrorsPreRetry(TransactionConfig config, TransactionContext overall, Throwable err) {
        overall.LOGGER.info("<>", "hit error %s", err);
        Mono rollback = Mono.empty();
        Mono cleanupReq = Mono.empty();
        if (err instanceof AttemptException) {
            AttemptException e = (AttemptException)err;
            AttemptContextReactive ctx = e.context();
            if (e.shouldRollback()) {
                ctx.LOGGER.info(ctx.attemptId(), "rolling back on error");
                rollback = ctx.rollbackInternal().then(Mono.defer(() -> {
                    if (ctx.isExpiryOvertimeMode()) {
                        ctx.LOGGER.info(ctx.attemptId(), "successfully rolled back, in expiry-overtime mode so raising expired");
                        AttemptExpired out = new AttemptExpired(ctx, false);
                        out.shouldRollback(false);
                        return Mono.error((Throwable)out);
                    }
                    return Mono.just((Object)0);
                })).then();
            } else {
                ctx.LOGGER.info(ctx.attemptId(), "has been told to skip rollback");
            }
            if (!e.shouldAddCleanupRequest()) {
                ctx.LOGGER.trace(ctx.attemptId(), "skipping addition of cleanup request on failure as directed");
            } else if (!config.runRegularAttemptsCleanupThread()) {
                ctx.LOGGER.trace(ctx.attemptId(), "skipping addition of cleanup request on failure as regular cleanup disabled");
            } else {
                this.addCleanupRequestForContext(ctx);
            }
            TransactionAttempt ta = TransactionAttempt.createFromContext(ctx, Optional.of(err));
            overall.addAttempt(ta);
            ctx.LOGGER.info(ctx.attemptId(), "added attempt %s after error", ta);
            ctx.span().finish();
        } else {
            overall.LOGGER.info("<>", "received non-AttemptException error %s, unable to rollback as don't have context", err.getClass().getSimpleName());
        }
        return rollback.then(cleanupReq).then(Mono.error((Throwable)err));
    }

    private Mono<AttemptContextReactive> executeHandleErrorsPostRetry(TransactionContext overall, Throwable err) {
        if (err instanceof TransactionFailed) {
            overall.LOGGER.info("<>", "%s caught error %s, no need to wrap in TransactionFailed", overall.transactionId(), err.toString());
            return Mono.error((Throwable)err);
        }
        if (err instanceof AttemptExpired) {
            AttemptContextReactive ctx = ((AttemptExpired)err).context();
            ctx.LOGGER.info(ctx.attemptId(), "caught error %s, changing to TransactionExpired", err.toString());
            TransactionExpired ret = new TransactionExpired(TransactionsReactive.createResultFromContext(overall), "Transaction has expired configured timeout of " + this.config.transactionExpirationTime().toMillis() + "msecs, check result() for details");
            return Mono.error((Throwable)ret);
        }
        if (err instanceof AttemptWrappedExceptionNoRetry) {
            AttemptContextReactive ctx = ((AttemptWrappedExceptionNoRetry)err).context();
            if (err.getCause() instanceof AssertionError) {
                ctx.LOGGER.info(ctx.attemptId(), "AttemptWrappedExceptionNoRetry raised containing wrapped AssertionError, rethrowing original", err.getCause());
                return Mono.error((Throwable)err.getCause());
            }
            if (err.getCause() instanceof TransactionFailed) {
                ctx.LOGGER.info(ctx.attemptId(), "AttemptWrappedExceptionNoRetry raised containing wrapped TransactionFailed, rethrowing original", err.getCause());
                return Mono.error((Throwable)err.getCause());
            }
            ctx.LOGGER.info(ctx.attemptId(), "AttemptWrappedExceptionNoRetry raised, wrapping original exception '%s' in TransactionFailed", err.getCause());
            TransactionFailed ret = new TransactionFailed(err.getCause(), TransactionsReactive.createResultFromContext(overall));
            return Mono.error((Throwable)ret);
        }
        if (err instanceof AttemptException) {
            AttemptContextReactive ctx = ((AttemptException)err).context();
            ctx.LOGGER.info(ctx.attemptId(), "caught error %s, wrapping in TransactionFailed", err.toString());
            TransactionFailed ret = new TransactionFailed(err, TransactionsReactive.createResultFromContext(overall));
            return Mono.error((Throwable)ret);
        }
        overall.LOGGER.info("<>", "caught error %s, wrapping in TransactionFailed", err.toString());
        TransactionFailed ret = new TransactionFailed(err, TransactionsReactive.createResultFromContext(overall));
        return Mono.error((Throwable)ret);
    }

    private void executeAddAttemptAndCleanupRequest(TransactionConfig config, TransactionContext overall, AttemptContextReactive ctx) {
        TransactionAttempt ta = TransactionAttempt.createFromContext(ctx, Optional.empty());
        overall.addAttempt(ta);
        ctx.LOGGER.info(ctx.attemptId(), "added attempt %s after success", ta);
        if (config.runRegularAttemptsCleanupThread()) {
            this.addCleanupRequestForContext(ctx);
        } else {
            ctx.LOGGER.trace(ctx.attemptId(), "skipping addition of cleanup request on success");
        }
        ctx.span().finish();
    }

    private Mono<AttemptContextReactive> executeImplicitCommit(AttemptContextReactive ctx) {
        if (!ctx.isDone()) {
            if (ctx.serialized().isPresent()) {
                return Mono.just((Object)ctx);
            }
            ctx.LOGGER.trace(ctx.attemptId(), "doing implicit commit");
            return ctx.commit().then(Mono.just((Object)ctx));
        }
        return Mono.just((Object)ctx);
    }

    AttemptContextReactive createAttemptContext(TransactionContext overall, TransactionConfig config, String attemptId) {
        if (overall != null) {
            return this.attemptContextFactory.create(overall, config, attemptId, this, overall.span());
        }
        return null;
    }

    public Mono<TransactionResult> run(Function<AttemptContextReactive, Mono<Void>> transactionLogic, PerTransactionConfig perConfig) {
        return Mono.defer(() -> {
            TransactionContext overall = new TransactionContext(this.cleanup.clusterData().cluster().environment().eventBus(), UUID.randomUUID().toString(), TransactionsReactive.now(), Duration.ZERO, this.config, perConfig);
            AtomicReference<Long> startTime = new AtomicReference<Long>(0L);
            Mono ob = Mono.fromCallable(() -> {
                String txnId = UUID.randomUUID().toString();
                return this.createAttemptContext(overall, this.config, txnId);
            }).flatMap(ctx -> {
                ctx.LOGGER.info("starting attempt %d/%s/%s", overall.numAttempts(), ctx.transactionId(), ctx.attemptId());
                ctx.LOGGER.info(TransactionsReactive.configDebug(this.config, perConfig));
                Mono result = (Mono)transactionLogic.apply((AttemptContextReactive)ctx);
                Mono realOut = Mono.just((Object)ctx);
                return result.then(realOut).onErrorResume(err -> {
                    StackTraceElement[] st;
                    ctx.LOGGER.info(ctx.attemptId(), "caught exception '%s' in async, rethrowing", err);
                    for (StackTraceElement s : st = err.getStackTrace()) {
                        ctx.LOGGER.info(ctx.attemptId(), "          " + s.toString());
                    }
                    return Mono.error((Throwable)AttemptWrappedExceptionNeedsRetry.wrapIfNeeded(err, ctx, TransactionsReactive.createResultFromContext(overall)));
                }).then(Mono.just((Object)ctx));
            }).doOnSubscribe(v -> startTime.set(System.nanoTime())).doOnNext(v -> v.LOGGER.trace(v.attemptId(), "finished attempt %d in %sms", overall.numAttempts(), (System.nanoTime() - (Long)startTime.get()) / 1000000L));
            return this.executeTransaction(this.config, overall, (Mono<AttemptContextReactive>)ob);
        });
    }

    private static String configDebug(TransactionConfig config, PerTransactionConfig perConfig) {
        StringBuilder sb = new StringBuilder();
        sb.append("config: ");
        sb.append("atrs=");
        sb.append(config.numAtrs());
        sb.append(", expiry=");
        sb.append(config.transactionExpirationTime().toMillis());
        sb.append("msecs durability=");
        sb.append(config.durabilityLevel());
        sb.append(" per-txn config:");
        sb.append(" durability=");
        sb.append(perConfig.durabilityLevel());
        return sb.toString();
    }

    public Mono<TransactionResult> run(Function<AttemptContextReactive, Mono<Void>> transactionLogic) {
        return this.run(transactionLogic, PerTransactionConfigBuilder.create().build());
    }

    @Stability.Volatile
    public Mono<TransactionResult> commit(TransactionSerializedContext serialized, PerTransactionConfig perConfig) {
        return this.deferred(serialized, perConfig, ctx -> Mono.empty());
    }

    @Stability.Volatile
    public Mono<TransactionResult> rollback(TransactionSerializedContext serialized, PerTransactionConfig perConfig) {
        return this.deferred(serialized, perConfig, ctx -> ctx.rollback());
    }

    @Stability.Volatile
    private Mono<TransactionResult> deferred(TransactionSerializedContext serialized, PerTransactionConfig perConfig, Function<AttemptContextReactive, Mono<Void>> initial) {
        JsonObject hydrated = JsonObject.fromJson((String)serialized.encodeAsString());
        String atrBucket = hydrated.getString("atrBucket");
        String atrId = hydrated.getString("atrId");
        return this.cleanup.clusterData().getBucketDefaultCollection(atrBucket).flatMap(atrCollection -> ActiveTransactionRecord.getAndTouchAtr(atrCollection, atrId, this.config.keyValueTimeout(), null, this.config)).flatMap(atrOpt -> {
            if (!atrOpt.isPresent()) {
                return Mono.error((Throwable)new IllegalStateException(String.format("ATR %s/%s could not be found", atrBucket, atrId)));
            }
            ATR atr = (ATR)atrOpt.get();
            Duration currentTimeServer = Duration.ofNanos(atr.cas());
            Duration startTimeServer = Duration.ofMillis(hydrated.getLong("startTimeServerMillis"));
            Duration timeElapsed = currentTimeServer.minus(startTimeServer);
            TransactionContext overall = new TransactionContext(this.cleanup.clusterData().cluster().environment().eventBus(), UUID.randomUUID().toString(), Duration.ofNanos(System.nanoTime()), timeElapsed, this.config, perConfig);
            AtomicReference<Long> startTime = new AtomicReference<Long>(0L);
            overall.LOGGER.info("elapsed time = %dmsecs (ATR start time %dmsecs, current ATR time %dmsecs)", timeElapsed.toMillis(), startTimeServer.toMillis(), currentTimeServer.toMillis());
            Mono ob = Mono.defer(() -> {
                AttemptContextReactive ctx = this.attemptContextFactory.createFrom(hydrated, overall, this.config, this);
                ctx.LOGGER.info("starting attempt %d/%s/%s", overall.numAttempts(), ctx.transactionId(), ctx.attemptId());
                ctx.LOGGER.info(TransactionsReactive.configDebug(this.config, perConfig));
                return ((Mono)initial.apply(ctx)).subscribeOn(Schedulers.elastic()).onErrorResume(err -> {
                    ctx.LOGGER.info(ctx.attemptId(), "caught exception '%s' in deferred, rethrowing", err);
                    return Mono.error((Throwable)AttemptWrappedExceptionNeedsRetry.wrapIfNeeded(err, ctx, TransactionsReactive.createResultFromContext(overall)));
                }).doOnSubscribe(v -> startTime.set(System.nanoTime())).doOnNext(v -> ctx.LOGGER.trace(ctx.attemptId(), "finished attempt %d in %sms", overall.numAttempts(), (System.nanoTime() - (Long)startTime.get()) / 1000000L)).thenReturn((Object)ctx);
            });
            return this.executeTransaction(this.config, overall, (Mono<AttemptContextReactive>)ob);
        });
    }

    Mono<TransactionResult> runBlocking(Consumer<AttemptContext> txnLogic, PerTransactionConfig perConfig) {
        return Mono.defer(() -> {
            TransactionContext overall = new TransactionContext(this.cleanup.clusterData().cluster().environment().eventBus(), UUID.randomUUID().toString(), TransactionsReactive.now(), Duration.ZERO, this.config, perConfig);
            AtomicReference<Long> startTime = new AtomicReference<Long>(0L);
            Mono ob = Mono.defer(() -> {
                String txnId = UUID.randomUUID().toString();
                AttemptContextReactive ctx = this.createAttemptContext(overall, this.config, txnId);
                AttemptContext ctxBlocking = new AttemptContext(ctx);
                ctx.LOGGER.info("starting attempt %d/%s/%s", overall.numAttempts(), ctx.transactionId(), ctx.attemptId());
                ctx.LOGGER.info(TransactionsReactive.configDebug(this.config, perConfig));
                return Mono.fromRunnable(() -> txnLogic.accept(ctxBlocking)).subscribeOn(Schedulers.elastic()).onErrorResume(err -> {
                    StackTraceElement[] st;
                    ctx.LOGGER.info(ctx.attemptId(), "caught exception '%s' in runBlocking, rethrowing", err);
                    for (StackTraceElement s : st = err.getStackTrace()) {
                        ctx.LOGGER.info(ctx.attemptId(), "          " + s.toString());
                    }
                    return Mono.error((Throwable)AttemptWrappedExceptionNeedsRetry.wrapIfNeeded(err, ctx, TransactionsReactive.createResultFromContext(overall)));
                }).doOnSubscribe(v -> startTime.set(System.nanoTime())).doOnNext(v -> ctx.LOGGER.trace(ctx.attemptId(), "finished attempt %d in %sms", overall.numAttempts(), (System.nanoTime() - (Long)startTime.get()) / 1000000L)).thenReturn((Object)ctx);
            });
            return this.executeTransaction(this.config, overall, (Mono<AttemptContextReactive>)ob);
        });
    }

    public TransactionConfig config() {
        return this.config;
    }

    private static Duration now() {
        return Duration.of(System.nanoTime(), ChronoUnit.NANOS);
    }

    TransactionsCleanup cleanup() {
        return this.cleanup;
    }

    private void addCleanupRequestForContext(AttemptContextReactive ctx) {
        if (ctx.atrId().isPresent() && ctx.atrCollection().isPresent()) {
            ctx.LOGGER.trace(ctx.attemptId(), "Adding cleanup request for %s/%s to run in %d msecs", ctx.atrCollection().get().name(), ctx.atrId().get(), this.config.transactionExpirationTime().toMillis());
            this.cleanup.add(new CleanupRequest(ctx.attemptId(), ctx.atrId().get(), ctx.atrCollection().get(), this.config.transactionExpirationTime(), false));
        } else {
            ctx.LOGGER.trace(ctx.attemptId(), "Skipping cleanup request as no ATR entry to remove (due to no mutations)");
        }
    }

    private static TransactionResult createResultFromContext(TransactionContext overall) {
        return new TransactionResult(overall.attempts(), overall.LOGGER, Duration.of(System.nanoTime() - overall.startTimeClient().toNanos(), ChronoUnit.NANOS), overall.transactionId(), overall.serialized());
    }

    @Deprecated
    @Stability.Internal
    public void setAttemptContextFactory(AttemptContextFactory factory) {
        this.attemptContextFactory = factory;
    }
}

